/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.button;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.button.AbstractButtonBuilder;
import is.codion.swing.common.ui.component.button.BooleanNullableCheckBoxValue;
import is.codion.swing.common.ui.component.button.BooleanToggleButtonValue;
import is.codion.swing.common.ui.component.button.NullableCheckBox;
import is.codion.swing.common.ui.component.button.ToggleButtonBuilder;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.ToggleControl;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;

class DefaultToggleButtonBuilder<C extends JToggleButton, B extends ToggleButtonBuilder<C, B>>
extends AbstractButtonBuilder<Boolean, C, B>
implements ToggleButtonBuilder<C, B> {
    private ToggleControl toggleControl;

    DefaultToggleButtonBuilder(Value<Boolean> linkedValue) {
        super(linkedValue);
    }

    @Override
    public final B toggleControl(ToggleControl toggleControl) {
        if (Objects.requireNonNull(toggleControl).value().nullable() && !this.supportsNull()) {
            throw new IllegalArgumentException("This toggle button builder does not support a nullable value");
        }
        this.toggleControl = toggleControl;
        this.action(toggleControl);
        return (B)this;
    }

    @Override
    public final B toggleControl(ToggleControl.Builder toggleControlBuilder) {
        return this.toggleControl(Objects.requireNonNull(toggleControlBuilder).build());
    }

    protected JToggleButton createToggleButton() {
        return new JToggleButton();
    }

    @Override
    protected final C createButton() {
        JToggleButton toggleButton = this.createToggleButton();
        if (this.toggleControl != null) {
            toggleButton.setModel(DefaultToggleButtonBuilder.createButtonModel(this.toggleControl));
        }
        return (C)toggleButton;
    }

    @Override
    protected final ComponentValue<Boolean, C> createComponentValue(JToggleButton component) {
        if (component instanceof NullableCheckBox) {
            return new BooleanNullableCheckBoxValue((NullableCheckBox)component);
        }
        return new BooleanToggleButtonValue<JToggleButton>(component);
    }

    @Override
    protected final void setInitialValue(C component, Boolean initialValue) {
        ((AbstractButton)component).setSelected(initialValue);
    }
}

