/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui;

import java.awt.Dimension;
import java.util.Objects;
import javax.swing.JComponent;

public final class Sizes {
    private static final String COMPONENT = "component";

    private Sizes() {
    }

    public static <T extends JComponent> T setPreferredWidth(T component, int preferredWidth) {
        Objects.requireNonNull(component, COMPONENT);
        component.setPreferredSize(new Dimension(preferredWidth, component.getPreferredSize().height));
        return component;
    }

    public static <T extends JComponent> T setPreferredHeight(T component, int preferredHeight) {
        Objects.requireNonNull(component, COMPONENT);
        component.setPreferredSize(new Dimension(component.getPreferredSize().width, preferredHeight));
        return component;
    }

    public static <T extends JComponent> T setMinimumWidth(T component, int minimumWidth) {
        Objects.requireNonNull(component, COMPONENT);
        component.setMinimumSize(new Dimension(minimumWidth, component.getMinimumSize().height));
        return component;
    }

    public static <T extends JComponent> T setMinimumHeight(T component, int minimumHeight) {
        Objects.requireNonNull(component, COMPONENT);
        component.setMinimumSize(new Dimension(component.getMinimumSize().width, minimumHeight));
        return component;
    }

    public static <T extends JComponent> T setMaximumWidth(T component, int maximumWidth) {
        Objects.requireNonNull(component, COMPONENT);
        component.setMaximumSize(new Dimension(maximumWidth, component.getMaximumSize().height));
        return component;
    }

    public static <T extends JComponent> T setMaximumHeight(T component, int maximumHeight) {
        Objects.requireNonNull(component, COMPONENT);
        component.setMaximumSize(new Dimension(component.getMaximumSize().width, maximumHeight));
        return component;
    }
}

