/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.model.CancelException;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.ui.KeyEvents;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.dialog.DefaultOkCancelDialogBuilder;
import is.codion.swing.common.ui.dialog.InputDialogBuilder;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class DefaultInputDialogBuilder<T>
implements InputDialogBuilder<T> {
    private final JPanel basePanel = new JPanel(Layouts.borderLayout());
    private final ComponentValue<T, ?> componentValue;
    private final OkCancelDialogBuilder okCancelDialogBuilder = new DefaultOkCancelDialogBuilder(this.basePanel);
    private String caption;

    DefaultInputDialogBuilder(ComponentValue<T, ?> componentValue) {
        this.componentValue = Objects.requireNonNull(componentValue);
        this.basePanel.add((Component)componentValue.component(), "Center");
        int gap = (Integer)Layouts.GAP.get();
        this.basePanel.setBorder(BorderFactory.createEmptyBorder(gap, gap, 0, gap));
    }

    @Override
    public InputDialogBuilder<T> owner(Window owner) {
        this.okCancelDialogBuilder.owner(owner);
        return this;
    }

    @Override
    public InputDialogBuilder<T> owner(Component owner) {
        this.okCancelDialogBuilder.owner(owner);
        return this;
    }

    @Override
    public InputDialogBuilder<T> locationRelativeTo(Component component) {
        this.okCancelDialogBuilder.locationRelativeTo(component);
        return this;
    }

    @Override
    public InputDialogBuilder<T> location(Point location) {
        this.okCancelDialogBuilder.location(location);
        return this;
    }

    @Override
    public InputDialogBuilder<T> titleProvider(ValueObserver<String> titleProvider) {
        this.okCancelDialogBuilder.titleProvider(titleProvider);
        return this;
    }

    @Override
    public InputDialogBuilder<T> icon(ImageIcon icon) {
        this.okCancelDialogBuilder.icon(icon);
        return this;
    }

    @Override
    public InputDialogBuilder<T> title(String title) {
        this.okCancelDialogBuilder.title(title);
        return this;
    }

    @Override
    public InputDialogBuilder<T> caption(String caption) {
        this.caption = caption;
        return this;
    }

    @Override
    public InputDialogBuilder<T> inputValid(StateObserver inputValid) {
        this.okCancelDialogBuilder.okEnabled(inputValid);
        return this;
    }

    @Override
    public InputDialogBuilder<T> inputValidator(Predicate<T> validInputPredicate) {
        return this.inputValid(this.createInputValidObserver(Objects.requireNonNull(validInputPredicate)));
    }

    @Override
    public InputDialogBuilder<T> keyEvent(KeyEvents.Builder keyEventBuilder) {
        this.okCancelDialogBuilder.keyEvent(keyEventBuilder);
        return this;
    }

    @Override
    public T show() {
        State okPressed = State.state();
        if (this.caption != null) {
            this.basePanel.add((Component)new JLabel(this.caption), "North");
        }
        this.okCancelDialogBuilder.onOk(new OnOk(this.componentValue, okPressed)).show();
        if (((Boolean)okPressed.get()).booleanValue()) {
            return (T)this.componentValue.get();
        }
        throw new CancelException();
    }

    private StateObserver createInputValidObserver(Predicate<T> inputValidator) {
        State validInputState = State.state((boolean)inputValidator.test(this.componentValue.get()));
        this.componentValue.addListener(new InputValidStateListener<T>(validInputState, inputValidator, this.componentValue));
        return validInputState;
    }

    private static final class OnOk
    implements Runnable {
        private final ComponentValue<?, ?> componentValue;
        private final State okPressed;

        private OnOk(ComponentValue<?, ?> componentValue, State okPressed) {
            this.componentValue = componentValue;
            this.okPressed = okPressed;
        }

        @Override
        public void run() {
            Utilities.parentDialog(this.componentValue.component()).dispose();
            this.okPressed.set((Object)true);
        }
    }

    private static final class InputValidStateListener<T>
    implements Runnable {
        private final State validInputState;
        private final Predicate<T> validInputPredicate;
        private final Value<T> componentValue;

        private InputValidStateListener(State validInputState, Predicate<T> validInputPredicate, Value<T> componentValue) {
            this.validInputState = validInputState;
            this.validInputPredicate = validInputPredicate;
            this.componentValue = componentValue;
        }

        @Override
        public void run() {
            this.validInputState.set((Object)this.validInputPredicate.test(this.componentValue.get()));
        }
    }
}

