/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.combobox;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Objects;
import javax.swing.ComboBoxModel;

final class ComboBoxMouseWheelListener
implements MouseWheelListener {
    private final ComboBoxModel<?> comboBoxModel;
    private final boolean wrapAround;

    ComboBoxMouseWheelListener(ComboBoxModel<?> comboBoxModel, boolean wrapAround) {
        this.comboBoxModel = Objects.requireNonNull(comboBoxModel);
        this.wrapAround = wrapAround;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this.comboBoxModel.getSize() == 0) {
            return;
        }
        int wheelRotation = event.getWheelRotation();
        if (wheelRotation != 0) {
            this.comboBoxModel.setSelectedItem(this.itemToSelect(wheelRotation > 0));
        }
    }

    private Object itemToSelect(boolean next) {
        Object currentSelection = this.comboBoxModel.getSelectedItem();
        for (int i = 0; i < this.comboBoxModel.getSize(); ++i) {
            if (!Objects.equals(currentSelection, this.comboBoxModel.getElementAt(i))) continue;
            return this.comboBoxModel.getElementAt(next ? this.nextIndex(i) : this.previousIndex(i));
        }
        return this.comboBoxModel.getElementAt(next ? this.nextIndex(0) : this.previousIndex(0));
    }

    private int nextIndex(int currentIndex) {
        return currentIndex == this.comboBoxModel.getSize() - 1 ? (this.wrapAround ? 0 : currentIndex) : currentIndex + 1;
    }

    private int previousIndex(int currentIndex) {
        return currentIndex == 0 ? (this.wrapAround ? this.comboBoxModel.getSize() - 1 : currentIndex) : currentIndex - 1;
    }
}

