/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.button;

import is.codion.swing.common.ui.component.button.AbstractControlPanelBuilder;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.ControlHandler;
import is.codion.swing.common.ui.component.button.ToggleButtonBuilder;
import is.codion.swing.common.ui.component.button.ToolBarBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import java.awt.Component;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.JToolBar;

final class DefaultToolBarBuilder
extends AbstractControlPanelBuilder<JToolBar, ToolBarBuilder>
implements ToolBarBuilder {
    private boolean floatable = true;
    private boolean rollover = false;
    private boolean borderPainted = true;

    DefaultToolBarBuilder(Controls controls) {
        super(controls);
    }

    @Override
    public ToolBarBuilder floatable(boolean floatable) {
        this.floatable = floatable;
        return this;
    }

    @Override
    public ToolBarBuilder rollover(boolean rollover) {
        this.rollover = rollover;
        return this;
    }

    @Override
    public ToolBarBuilder borderPainted(boolean borderPainted) {
        this.borderPainted = borderPainted;
        return this;
    }

    @Override
    protected JToolBar createComponent() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(this.floatable);
        toolBar.setOrientation(this.orientation());
        toolBar.setRollover(this.rollover);
        toolBar.setBorderPainted(this.borderPainted);
        Optional<ButtonBuilder<?, ?, ?>> buttonBuilder = this.buttonBuilder();
        Optional<ToggleButtonBuilder<?, ?>> toggleButtonBuilder = this.toggleButtonBuilder();
        new ToolBarControlHandler(toolBar, this.controls(), buttonBuilder.orElse(ButtonBuilder.builder()), !buttonBuilder.isPresent(), toggleButtonBuilder.orElse(this.createToggleButtonBuilder()), !toggleButtonBuilder.isPresent());
        return toolBar;
    }

    private static final class ToolBarControlHandler
    extends ControlHandler {
        private final JToolBar toolBar;
        private final ButtonBuilder<?, ?, ?> buttonBuilder;
        private final boolean defaultButtonBuilder;
        private final ToggleButtonBuilder<?, ?> toggleButtonBuilder;
        private final boolean defaultToggleButtonBuilder;

        private ToolBarControlHandler(JToolBar toolBar, Controls controls, ButtonBuilder<?, ?, ?> buttonBuilder, boolean defaultButtonBuilder, ToggleButtonBuilder<?, ?> toggleButtonBuilder, boolean defaultToggleButtonBuilder) {
            this.toolBar = toolBar;
            this.buttonBuilder = (ButtonBuilder)buttonBuilder.clear();
            this.defaultButtonBuilder = defaultButtonBuilder;
            this.toggleButtonBuilder = (ToggleButtonBuilder)toggleButtonBuilder.clear();
            this.defaultToggleButtonBuilder = defaultToggleButtonBuilder;
            controls.actions().forEach(this);
        }

        @Override
        void onSeparator() {
            this.toolBar.addSeparator();
        }

        @Override
        void onControl(Control control) {
            this.onAction(control);
        }

        @Override
        void onToggleControl(ToggleControl toggleControl) {
            if (this.defaultToggleButtonBuilder) {
                this.toggleButtonBuilder.includeText(ToolBarControlHandler.includeButtonText(toggleControl));
            }
            this.toolBar.add((Component)this.toggleButtonBuilder.toggleControl(toggleControl).build());
            this.toggleButtonBuilder.clear();
        }

        @Override
        void onControls(Controls controls) {
            new ToolBarControlHandler(this.toolBar, controls, this.buttonBuilder, this.defaultButtonBuilder, this.toggleButtonBuilder, this.defaultToggleButtonBuilder);
        }

        @Override
        void onAction(Action action) {
            if (this.defaultButtonBuilder) {
                this.buttonBuilder.includeText(ToolBarControlHandler.includeButtonText(action));
            }
            this.toolBar.add((Component)this.buttonBuilder.action(action).build());
            this.buttonBuilder.clear();
        }

        private static boolean includeButtonText(Action action) {
            return action.getValue("SmallIcon") == null && action.getValue("SwingLargeIconKey") == null;
        }
    }
}

