/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.swing.common.ui.Sizes;
import is.codion.swing.common.ui.component.button.ButtonPanelBuilder;
import is.codion.swing.common.ui.component.panel.BorderLayoutPanelBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.dialog.AbstractDialogBuilder;
import is.codion.swing.common.ui.dialog.DialogBuilder;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;

public final class ProgressDialog
extends JDialog {
    private static final int DEFAULT_PROGRESS_BAR_WIDTH = 400;
    private final JProgressBar progressBar;

    private ProgressDialog(DefaultBuilder builder, Window dialogOwner) {
        super(dialogOwner, dialogOwner == null ? Dialog.ModalityType.MODELESS : Dialog.ModalityType.APPLICATION_MODAL);
        if (builder.titleProvider != null) {
            this.setTitle((String)builder.titleProvider.get());
            builder.titleProvider.addDataListener(this::setTitle);
        }
        if (builder.icon != null) {
            this.setIconImage(builder.icon.getImage());
        }
        this.setDefaultCloseOperation(0);
        this.progressBar = ProgressDialog.createProgressBar(builder);
        this.initializeUI(builder);
        this.setLocationRelativeTo(dialogOwner);
    }

    public void setProgress(int progress) {
        this.progressBar.getModel().setValue(progress);
    }

    public void setMessage(String message) {
        this.progressBar.setString(message);
    }

    private void initializeUI(DefaultBuilder builder) {
        this.setLayout(Layouts.borderLayout());
        this.add((Component)this.createCenterPanel(builder), "Center");
        this.pack();
    }

    private JPanel createCenterPanel(DefaultBuilder builder) {
        BorderLayoutPanelBuilder basePanelBuilder = BorderLayoutPanelBuilder.builder(Layouts.borderLayout());
        if (builder.border != null) {
            basePanelBuilder.border(builder.border);
        }
        if (builder.northPanel != null) {
            basePanelBuilder.northComponent(builder.northPanel);
        }
        if (builder.westPanel != null) {
            basePanelBuilder.westComponent(builder.westPanel);
        }
        if (builder.eastPanel != null) {
            basePanelBuilder.eastComponent(builder.eastPanel);
        }
        basePanelBuilder.centerComponent(this.progressBar);
        if (builder.controls != null) {
            basePanelBuilder.southComponent((JComponent)PanelBuilder.builder(Layouts.flowLayout(4)).add((JComponent)ButtonPanelBuilder.builder(builder.controls).build()).build());
        }
        return (JPanel)basePanelBuilder.build();
    }

    private static JProgressBar createProgressBar(DefaultBuilder builder) {
        JProgressBar progressBar = new JProgressBar();
        progressBar.setStringPainted(builder.stringPainted);
        if (builder.progressBarSize != null) {
            progressBar.setPreferredSize(builder.progressBarSize);
        } else {
            Sizes.setPreferredWidth(progressBar, 400);
        }
        if (builder.indeterminate) {
            progressBar.setIndeterminate(true);
        } else {
            progressBar.setMaximum(builder.maximumProgress);
        }
        return progressBar;
    }

    static class DefaultBuilder
    extends AbstractDialogBuilder<Builder>
    implements Builder {
        private int maximumProgress = 100;
        private boolean indeterminate = true;
        private boolean stringPainted = false;
        private JPanel northPanel;
        private JPanel westPanel;
        private JPanel eastPanel;
        private Controls controls;
        private Dimension progressBarSize;
        private Border border;

        DefaultBuilder() {
        }

        @Override
        public Builder indeterminate(boolean indeterminate) {
            this.indeterminate = indeterminate;
            return this;
        }

        @Override
        public Builder maximumProgress(int maximumProgress) {
            if (maximumProgress < 0) {
                throw new IllegalArgumentException("Maximum progress must be a positive integer");
            }
            this.maximumProgress = maximumProgress;
            return this.indeterminate(false);
        }

        @Override
        public Builder stringPainted(boolean stringPainted) {
            this.stringPainted = stringPainted;
            return this;
        }

        @Override
        public Builder northPanel(JPanel northPanel) {
            this.northPanel = northPanel;
            return this;
        }

        @Override
        public Builder westPanel(JPanel westPanel) {
            this.westPanel = westPanel;
            return this;
        }

        @Override
        public Builder eastPanel(JPanel eastPanel) {
            this.eastPanel = eastPanel;
            return this;
        }

        @Override
        public Builder controls(Controls controls) {
            this.controls = controls;
            return this;
        }

        @Override
        public Builder progressBarSize(Dimension progressBarSize) {
            this.progressBarSize = progressBarSize;
            return this;
        }

        @Override
        public Builder border(Border border) {
            this.border = border;
            return this;
        }

        @Override
        public ProgressDialog build() {
            return new ProgressDialog(this, this.owner);
        }
    }

    public static interface Builder
    extends DialogBuilder<Builder> {
        public Builder indeterminate(boolean var1);

        public Builder maximumProgress(int var1);

        public Builder stringPainted(boolean var1);

        public Builder northPanel(JPanel var1);

        public Builder westPanel(JPanel var1);

        public Builder eastPanel(JPanel var1);

        public Builder controls(Controls var1);

        public Builder progressBarSize(Dimension var1);

        public Builder border(Border var1);

        public ProgressDialog build();
    }
}

