/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.swing.common.ui.control.DefaultToggleControl;
import is.codion.swing.common.ui.control.ToggleControl;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.KeyStroke;

final class ToggleControlBuilder
implements ToggleControl.Builder {
    private final Value<Boolean> value;
    private String name;
    private StateObserver enabled;
    private char mnemonic;
    private Icon smallIcon;
    private Icon largeIcon;
    private String description;
    private KeyStroke keyStroke;

    ToggleControlBuilder(Value<Boolean> value) {
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public ToggleControl.Builder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ToggleControl.Builder enabled(StateObserver enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public ToggleControl.Builder mnemonic(char mnemonic) {
        this.mnemonic = mnemonic;
        return this;
    }

    @Override
    public ToggleControl.Builder smallIcon(Icon smallIcon) {
        this.smallIcon = smallIcon;
        return this;
    }

    @Override
    public ToggleControl.Builder largeIcon(Icon largeIcon) {
        this.largeIcon = largeIcon;
        return this;
    }

    @Override
    public ToggleControl.Builder description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public ToggleControl.Builder keyStroke(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
        return this;
    }

    @Override
    public ToggleControl build() {
        DefaultToggleControl toggleControl = new DefaultToggleControl(this.value, this.name, this.enabled);
        toggleControl.setMnemonic(this.mnemonic);
        toggleControl.setSmallIcon(this.smallIcon);
        toggleControl.setLargeIcon(this.largeIcon);
        toggleControl.setDescription(this.description);
        toggleControl.setKeyStroke(this.keyStroke);
        return toggleControl;
    }
}

