/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.Operator;
import is.codion.common.event.Event;
import is.codion.common.item.Item;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.combobox.ItemComboBoxModel;
import is.codion.swing.common.ui.KeyEvents;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.button.RadioButtonBuilder;
import is.codion.swing.common.ui.component.combobox.Completion;
import is.codion.swing.common.ui.component.combobox.ItemComboBoxBuilder;
import is.codion.swing.common.ui.component.text.NumberField;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;

public final class ColumnConditionPanel<C, T>
extends JPanel {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(ColumnConditionPanel.class.getName());
    private final ColumnConditionModel<? extends C, T> conditionModel;
    private final JToggleButton toggleEnabledButton;
    private final JComboBox<Item<Operator>> operatorCombo;
    private final JComponent equalField;
    private final JComponent upperBoundField;
    private final JComponent lowerBoundField;
    private final JPanel controlPanel = new JPanel(new BorderLayout());
    private final JPanel inputPanel = new JPanel(new BorderLayout());
    private final JPanel rangePanel = new JPanel(new GridLayout(1, 2));
    private final Event<C> focusGainedEvent = Event.event();
    private final State advanced = State.state();

    private ColumnConditionPanel(ColumnConditionModel<? extends C, T> conditionModel, BoundFieldFactory boundFieldFactory) {
        Objects.requireNonNull(conditionModel, "conditionModel");
        Objects.requireNonNull(boundFieldFactory, "boundFieldFactory");
        this.conditionModel = conditionModel;
        boolean modelLocked = (Boolean)conditionModel.locked().get();
        conditionModel.locked().set((Object)false);
        this.equalField = boundFieldFactory.createEqualField();
        this.upperBoundField = boundFieldFactory.createUpperBoundField().orElse(null);
        this.lowerBoundField = boundFieldFactory.createLowerBoundField().orElse(null);
        this.operatorCombo = this.createOperatorComboBox(conditionModel.operators());
        this.toggleEnabledButton = (JToggleButton)((RadioButtonBuilder)((RadioButtonBuilder)Components.radioButton((Value<Boolean>)conditionModel.enabled()).horizontalAlignment(0)).popupMenu(radioButton -> Components.menu(Controls.builder().control(ToggleControl.builder(conditionModel.autoEnable()).name(MESSAGES.getString("auto_enable"))).build()).createPopupMenu())).build();
        conditionModel.locked().set((Object)modelLocked);
        this.initializeUI();
        this.bindEvents();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Utilities.updateUI(this.toggleEnabledButton, this.operatorCombo, this.equalField, this.lowerBoundField, this.upperBoundField, this.controlPanel, this.inputPanel, this.rangePanel);
    }

    public ColumnConditionModel<C, T> model() {
        return this.conditionModel;
    }

    public void requestInputFocus() {
        switch ((Operator)this.conditionModel.operator().get()) {
            case EQUAL: 
            case NOT_EQUAL: {
                this.equalField.requestFocusInWindow();
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case BETWEEN_EXCLUSIVE: 
            case BETWEEN: 
            case NOT_BETWEEN_EXCLUSIVE: 
            case NOT_BETWEEN: {
                this.lowerBoundField.requestFocusInWindow();
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                this.upperBoundField.requestFocusInWindow();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + this.conditionModel.operator().get());
            }
        }
    }

    public State advanced() {
        return this.advanced;
    }

    public JComboBox<Item<Operator>> operatorComboBox() {
        return this.operatorCombo;
    }

    public JComponent equalField() {
        return this.equalField;
    }

    public JComponent upperBoundField() {
        return this.upperBoundField;
    }

    public JComponent lowerBoundField() {
        return this.lowerBoundField;
    }

    public void addFocusGainedListener(Consumer<C> listener) {
        this.focusGainedEvent.addDataListener(listener);
    }

    public static <C, T> Optional<ColumnConditionPanel<C, T>> columnConditionPanel(ColumnConditionModel<C, T> conditionModel) {
        return ColumnConditionPanel.columnConditionPanel(conditionModel, new DefaultBoundFieldFactory(conditionModel));
    }

    public static <C, T> Optional<ColumnConditionPanel<C, T>> columnConditionPanel(ColumnConditionModel<C, T> conditionModel, BoundFieldFactory boundFieldFactory) {
        Objects.requireNonNull(conditionModel);
        Objects.requireNonNull(boundFieldFactory);
        if (boundFieldFactory.supportsType(conditionModel.columnClass())) {
            return Optional.of(new ColumnConditionPanel<C, T>(conditionModel, boundFieldFactory));
        }
        return Optional.empty();
    }

    private void bindEvents() {
        this.advanced.addDataListener(this::onAdvancedChanged);
        this.conditionModel.operator().addDataListener(this::onOperatorChanged);
        FocusGainedListener focusGainedListener = new FocusGainedListener();
        this.operatorCombo.addFocusListener(focusGainedListener);
        KeyEvents.Builder enableOnEnterKeyEvent = KeyEvents.builder(10).modifiers(128).action(Control.control(() -> this.conditionModel.enabled().set((Object)((Boolean)this.conditionModel.enabled().get() == false ? 1 : 0))));
        KeyEvents.Builder previousOperatorKeyEvent = KeyEvents.builder(38).modifiers(128).action(Control.control(this::selectPreviousOperator));
        KeyEvents.Builder nextOperatorKeyEvent = KeyEvents.builder(40).modifiers(128).action(Control.control(this::selectNextOperator));
        enableOnEnterKeyEvent.enable(this.operatorCombo);
        if (this.equalField != null) {
            this.equalField.addFocusListener(focusGainedListener);
            enableOnEnterKeyEvent.enable(this.equalField);
            previousOperatorKeyEvent.enable(this.equalField);
            nextOperatorKeyEvent.enable(this.equalField);
        }
        if (this.upperBoundField != null) {
            this.upperBoundField.addFocusListener(focusGainedListener);
            enableOnEnterKeyEvent.enable(this.upperBoundField);
            previousOperatorKeyEvent.enable(this.upperBoundField);
            nextOperatorKeyEvent.enable(this.upperBoundField);
        }
        if (this.lowerBoundField != null) {
            this.lowerBoundField.addFocusListener(focusGainedListener);
            enableOnEnterKeyEvent.enable(this.lowerBoundField);
            previousOperatorKeyEvent.enable(this.lowerBoundField);
            nextOperatorKeyEvent.enable(this.lowerBoundField);
        }
        this.toggleEnabledButton.addFocusListener(focusGainedListener);
        enableOnEnterKeyEvent.enable(this.toggleEnabledButton);
    }

    private void onOperatorChanged(Operator operator) {
        switch (operator) {
            case EQUAL: 
            case NOT_EQUAL: {
                this.singleValuePanel(this.equalField);
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                this.singleValuePanel(this.lowerBoundField);
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                this.singleValuePanel(this.upperBoundField);
                break;
            }
            case BETWEEN_EXCLUSIVE: 
            case BETWEEN: 
            case NOT_BETWEEN_EXCLUSIVE: 
            case NOT_BETWEEN: {
                this.rangePanel();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + this.conditionModel.operator().get());
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void onAdvancedChanged(boolean advancedView) {
        if (advancedView) {
            this.setAdvanced();
        } else {
            this.setSimple();
        }
    }

    private void setSimple() {
        boolean parentOfFocusOwner;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean bl = parentOfFocusOwner = Utilities.parentOfType(ColumnConditionPanel.class, focusOwner) == this;
        if (parentOfFocusOwner) {
            this.requestFocusInWindow(true);
        }
        this.remove(this.controlPanel);
        this.inputPanel.add((Component)this.toggleEnabledButton, "East");
        this.add((Component)this.inputPanel, "Center");
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.inputPanel.getPreferredSize().height));
        this.revalidate();
        if (parentOfFocusOwner) {
            focusOwner.requestFocusInWindow();
        }
    }

    private void setAdvanced() {
        boolean parentOfFocusOwner;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean bl = parentOfFocusOwner = Utilities.parentOfType(ColumnConditionPanel.class, focusOwner) == this;
        if (parentOfFocusOwner) {
            this.requestFocusInWindow(true);
        }
        this.controlPanel.add((Component)this.toggleEnabledButton, "East");
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.inputPanel, "Center");
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.controlPanel.getPreferredSize().height + this.inputPanel.getPreferredSize().height));
        this.revalidate();
        if (parentOfFocusOwner) {
            focusOwner.requestFocusInWindow();
        }
    }

    private JComboBox<Item<Operator>> createOperatorComboBox(List<Operator> operators) {
        ItemComboBoxModel operatorComboBoxModel = ItemComboBoxModel.itemComboBoxModel(operators.stream().map(operator -> Item.item((Object)operator, (String)ColumnConditionModel.caption((Operator)operator))).collect(Collectors.toList()));
        operatorComboBoxModel.setSelectedItem((Object)operators.get(0));
        return (JComboBox)((ItemComboBoxBuilder)((ItemComboBoxBuilder)Components.itemComboBox(operatorComboBoxModel, this.conditionModel.operator()).completionMode(Completion.Mode.NONE).renderer(new OperatorComboBoxRenderer()).maximumRowCount(operators.size()).toolTipText(((Operator)((Item)operatorComboBoxModel.selectedValue()).get()).description())).onBuild(comboBox -> operatorComboBoxModel.addSelectionListener(selectedOperator -> comboBox.setToolTipText(((Operator)selectedOperator.get()).description())))).build();
    }

    private void selectNextOperator() {
        ItemComboBoxModel itemComboBoxModel = (ItemComboBoxModel)this.operatorCombo.getModel();
        List visibleItems = itemComboBoxModel.visibleItems();
        int index = visibleItems.indexOf(itemComboBoxModel.getSelectedItem());
        if (index < itemComboBoxModel.visibleCount() - 1) {
            itemComboBoxModel.setSelectedItem(visibleItems.get(index + 1));
        }
    }

    private void selectPreviousOperator() {
        ItemComboBoxModel itemComboBoxModel = (ItemComboBoxModel)this.operatorCombo.getModel();
        List visibleItems = itemComboBoxModel.visibleItems();
        int index = visibleItems.indexOf(itemComboBoxModel.getSelectedItem());
        if (index > 0) {
            itemComboBoxModel.setSelectedItem(visibleItems.get(index - 1));
        }
    }

    private void initializeUI() {
        Utilities.linkToEnabledState(this.conditionModel.locked().not(), this.operatorCombo, this.equalField, this.upperBoundField, this.lowerBoundField, this.toggleEnabledButton);
        this.setLayout(new BorderLayout());
        this.controlPanel.add(this.operatorCombo, "Center");
        this.onOperatorChanged((Operator)this.conditionModel.operator().get());
        this.onAdvancedChanged((Boolean)this.advanced.get());
        this.addStringConfigurationPopupMenu();
    }

    private void singleValuePanel(JComponent boundField) {
        if (!Arrays.asList(this.inputPanel.getComponents()).contains(boundField)) {
            boolean requestFocus = this.boundFieldHasFocus();
            this.clearInputPanel(requestFocus);
            this.inputPanel.add((Component)boundField, "Center");
            if (!((Boolean)this.advanced.get()).booleanValue()) {
                this.inputPanel.add((Component)this.toggleEnabledButton, "East");
            }
            if (requestFocus) {
                boundField.requestFocusInWindow();
            }
        }
    }

    private void rangePanel() {
        if (!Arrays.asList(this.inputPanel.getComponents()).contains(this.rangePanel)) {
            boolean requestFocus = this.boundFieldHasFocus();
            this.clearInputPanel(requestFocus);
            this.rangePanel.add(this.lowerBoundField);
            this.rangePanel.add(this.upperBoundField);
            this.inputPanel.add((Component)this.rangePanel, "Center");
            if (!((Boolean)this.advanced.get()).booleanValue()) {
                this.inputPanel.add((Component)this.toggleEnabledButton, "East");
            }
            if (requestFocus) {
                this.lowerBoundField.requestFocusInWindow();
            }
        }
    }

    private void clearInputPanel(boolean requestFocus) {
        if (requestFocus) {
            this.inputPanel.requestFocusInWindow();
        }
        this.inputPanel.removeAll();
    }

    private boolean boundFieldHasFocus() {
        return ColumnConditionPanel.boundFieldHasFocus(this.equalField) || ColumnConditionPanel.boundFieldHasFocus(this.lowerBoundField) || ColumnConditionPanel.boundFieldHasFocus(this.upperBoundField);
    }

    private void addStringConfigurationPopupMenu() {
        if (this.conditionModel.columnClass().equals(String.class)) {
            JPopupMenu popupMenu = Components.menu(Controls.builder().control(ToggleControl.builder(this.conditionModel.caseSensitive()).name(MESSAGES.getString("case_sensitive")).build()).controls(this.createAutomaticWildcardControls()).build()).createPopupMenu();
            this.equalField.setComponentPopupMenu(popupMenu);
            if (this.lowerBoundField != null) {
                this.lowerBoundField.setComponentPopupMenu(popupMenu);
            }
            if (this.upperBoundField != null) {
                this.upperBoundField.setComponentPopupMenu(popupMenu);
            }
        }
    }

    private Controls createAutomaticWildcardControls() {
        Value automaticWildcardValue = this.conditionModel.automaticWildcard();
        ColumnConditionModel.AutomaticWildcard automaticWildcard = (ColumnConditionModel.AutomaticWildcard)automaticWildcardValue.get();
        State automaticWildcardNoneState = State.state((boolean)automaticWildcard.equals((Object)ColumnConditionModel.AutomaticWildcard.NONE));
        State automaticWildcardPostfixState = State.state((boolean)automaticWildcard.equals((Object)ColumnConditionModel.AutomaticWildcard.POSTFIX));
        State automaticWildcardPrefixState = State.state((boolean)automaticWildcard.equals((Object)ColumnConditionModel.AutomaticWildcard.PREFIX));
        State automaticWildcardPrefixAndPostfixState = State.state((boolean)automaticWildcard.equals((Object)ColumnConditionModel.AutomaticWildcard.PREFIX_AND_POSTFIX));
        State.group((State[])new State[]{automaticWildcardNoneState, automaticWildcardPostfixState, automaticWildcardPrefixState, automaticWildcardPrefixAndPostfixState});
        automaticWildcardNoneState.addDataListener(enabled -> {
            if (enabled.booleanValue()) {
                automaticWildcardValue.set((Object)ColumnConditionModel.AutomaticWildcard.NONE);
            }
        });
        automaticWildcardPostfixState.addDataListener(enabled -> {
            if (enabled.booleanValue()) {
                automaticWildcardValue.set((Object)ColumnConditionModel.AutomaticWildcard.POSTFIX);
            }
        });
        automaticWildcardPrefixState.addDataListener(enabled -> {
            if (enabled.booleanValue()) {
                automaticWildcardValue.set((Object)ColumnConditionModel.AutomaticWildcard.PREFIX);
            }
        });
        automaticWildcardPrefixAndPostfixState.addDataListener(enabled -> {
            if (enabled.booleanValue()) {
                automaticWildcardValue.set((Object)ColumnConditionModel.AutomaticWildcard.PREFIX_AND_POSTFIX);
            }
        });
        return Controls.builder().name(MESSAGES.getString("automatic_wildcard")).control(ToggleControl.builder(automaticWildcardNoneState).name(ColumnConditionModel.AutomaticWildcard.NONE.description())).control(ToggleControl.builder(automaticWildcardPostfixState).name(ColumnConditionModel.AutomaticWildcard.POSTFIX.description())).control(ToggleControl.builder(automaticWildcardPrefixState).name(ColumnConditionModel.AutomaticWildcard.PREFIX.description())).control(ToggleControl.builder(automaticWildcardPrefixAndPostfixState).name(ColumnConditionModel.AutomaticWildcard.PREFIX_AND_POSTFIX.description())).build();
    }

    private static boolean boundFieldHasFocus(JComponent field) {
        if (field == null) {
            return false;
        }
        if (field.hasFocus()) {
            return true;
        }
        if (field instanceof JComboBox) {
            return ((JComboBox)field).getEditor().getEditorComponent().hasFocus();
        }
        return false;
    }

    public static interface BoundFieldFactory {
        public boolean supportsType(Class<?> var1);

        public JComponent createEqualField();

        public Optional<JComponent> createUpperBoundField();

        public Optional<JComponent> createLowerBoundField();
    }

    private static final class DefaultBoundFieldFactory
    implements BoundFieldFactory {
        private static final List<Class<?>> SUPPORTED_TYPES = Arrays.asList(String.class, Boolean.class, Short.class, Integer.class, Double.class, BigDecimal.class, Long.class, LocalTime.class, LocalDate.class, LocalDateTime.class, OffsetDateTime.class);
        private final ColumnConditionModel<?, ?> columnConditionModel;

        private DefaultBoundFieldFactory(ColumnConditionModel<?, ?> columnConditionModel) {
            this.columnConditionModel = Objects.requireNonNull(columnConditionModel, "columnConditionModel");
        }

        @Override
        public boolean supportsType(Class<?> columnClass) {
            return SUPPORTED_TYPES.contains(Objects.requireNonNull(columnClass));
        }

        @Override
        public JComponent createEqualField() {
            return this.createField(this.columnConditionModel.equalValues().value());
        }

        @Override
        public Optional<JComponent> createUpperBoundField() {
            if (this.columnConditionModel.columnClass().equals(Boolean.class)) {
                return Optional.empty();
            }
            return Optional.of(this.createField(this.columnConditionModel.upperBoundValue()));
        }

        @Override
        public Optional<JComponent> createLowerBoundField() {
            if (this.columnConditionModel.columnClass().equals(Boolean.class)) {
                return Optional.empty();
            }
            return Optional.of(this.createField(this.columnConditionModel.lowerBoundValue()));
        }

        private JComponent createField(Value<?> linkedValue) {
            Class columnClass = this.columnConditionModel.columnClass();
            if (columnClass.equals(Boolean.class)) {
                return ((CheckBoxBuilder)Components.checkBox(linkedValue).nullable(true).horizontalAlignment(0)).build();
            }
            if (columnClass.equals(Short.class)) {
                return ((NumberField.Builder)Components.shortField(linkedValue).format(this.columnConditionModel.format())).build();
            }
            if (columnClass.equals(Integer.class)) {
                return ((NumberField.Builder)Components.integerField(linkedValue).format(this.columnConditionModel.format())).build();
            }
            if (columnClass.equals(Double.class)) {
                return ((NumberField.Builder)Components.doubleField(linkedValue).format(this.columnConditionModel.format())).build();
            }
            if (columnClass.equals(BigDecimal.class)) {
                return ((NumberField.Builder)Components.bigDecimalField(linkedValue).format(this.columnConditionModel.format())).build();
            }
            if (columnClass.equals(Long.class)) {
                return ((NumberField.Builder)Components.longField(linkedValue).format(this.columnConditionModel.format())).build();
            }
            if (columnClass.equals(LocalTime.class)) {
                return Components.localTimeField(this.columnConditionModel.dateTimePattern(), linkedValue).build();
            }
            if (columnClass.equals(LocalDate.class)) {
                return Components.localDateField(this.columnConditionModel.dateTimePattern(), linkedValue).build();
            }
            if (columnClass.equals(LocalDateTime.class)) {
                return Components.localDateTimeField(this.columnConditionModel.dateTimePattern(), linkedValue).build();
            }
            if (columnClass.equals(OffsetDateTime.class)) {
                return Components.offsetDateTimeField(this.columnConditionModel.dateTimePattern(), linkedValue).build();
            }
            if (columnClass.equals(String.class)) {
                return Components.textField(linkedValue).build();
            }
            throw new IllegalArgumentException("Unsupported type: " + columnClass);
        }
    }

    private final class FocusGainedListener
    extends FocusAdapter {
        private FocusGainedListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!e.isTemporary()) {
                ColumnConditionPanel.this.focusGainedEvent.accept(ColumnConditionPanel.this.conditionModel.columnIdentifier());
            }
        }
    }

    private static final class OperatorComboBoxRenderer
    implements ListCellRenderer<Item<Operator>> {
        private final DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer();

        private OperatorComboBoxRenderer() {
            this.listCellRenderer.setHorizontalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Item<Operator>> list, Item<Operator> value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.listCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    public static interface Factory<C> {
        public <T> Optional<ColumnConditionPanel<C, T>> createConditionPanel(ColumnConditionModel<C, T> var1);
    }
}

