/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.icon;

import is.codion.swing.common.ui.icon.FontImageIcon;
import is.codion.swing.common.ui.icon.Icons;
import java.awt.Color;
import java.util.Objects;
import javax.swing.ImageIcon;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.swing.FontIcon;

final class DefaultFontImageIcon
implements FontImageIcon {
    private final FontIcon fontIcon;
    private final ImageIcon imageIcon;
    private final FontImageIcon.IconPainter iconPainter;

    private DefaultFontImageIcon(DefaultBuilder builder) {
        this.fontIcon = FontIcon.of((Ikon)builder.ikon, (int)builder.size, (Color)builder.color);
        this.imageIcon = builder.imageIconFactory.createImageIcon(this.fontIcon);
        this.iconPainter = builder.iconPainter;
        this.iconPainter.paintIcon(this.fontIcon, this.imageIcon);
    }

    @Override
    public ImageIcon imageIcon() {
        return this.imageIcon;
    }

    @Override
    public void setColor(Color color) {
        this.fontIcon.setIconColor(color);
        this.iconPainter.paintIcon(this.fontIcon, this.imageIcon);
    }

    static final class DefaultBuilder
    implements FontImageIcon.Builder {
        private static final FontImageIcon.IconPainter DEFAULT_ICON_PAINTER = new DefaultIconPainter();
        private static final FontImageIcon.ImageIconFactory DEFAULT_ICON_FACTORY = new DefaultImageIconFactory();
        private final Ikon ikon;
        private int size = (Integer)Icons.ICON_SIZE.get();
        private Color color = (Color)Icons.ICON_COLOR.get();
        private FontImageIcon.IconPainter iconPainter = DEFAULT_ICON_PAINTER;
        private FontImageIcon.ImageIconFactory imageIconFactory = DEFAULT_ICON_FACTORY;

        DefaultBuilder(Ikon ikon) {
            this.ikon = Objects.requireNonNull(ikon);
        }

        @Override
        public FontImageIcon.Builder size(int size) {
            this.size = size;
            return this;
        }

        @Override
        public FontImageIcon.Builder color(Color color) {
            this.color = Objects.requireNonNull(color);
            return this;
        }

        @Override
        public FontImageIcon.Builder iconPainter(FontImageIcon.IconPainter iconPainter) {
            this.iconPainter = Objects.requireNonNull(iconPainter);
            return this;
        }

        @Override
        public FontImageIcon.Builder imageIconFactory(FontImageIcon.ImageIconFactory imageIconFactory) {
            this.imageIconFactory = Objects.requireNonNull(imageIconFactory);
            return this;
        }

        @Override
        public FontImageIcon build() {
            return new DefaultFontImageIcon(this);
        }
    }

    private static final class DefaultImageIconFactory
    implements FontImageIcon.ImageIconFactory {
        private DefaultImageIconFactory() {
        }
    }

    private static final class DefaultIconPainter
    implements FontImageIcon.IconPainter {
        private DefaultIconPainter() {
        }
    }
}

