/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.dialog;

import is.codion.common.state.State;
import is.codion.swing.common.ui.component.calendar.CalendarPanel;
import is.codion.swing.common.ui.dialog.AbstractDialogBuilder;
import is.codion.swing.common.ui.dialog.CalendarDialogBuilder;
import is.codion.swing.common.ui.dialog.DefaultOkCancelDialogBuilder;
import is.codion.swing.common.ui.dialog.OkCancelDialogBuilder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.ResourceBundle;

final class DefaultCalendarDialogBuilder
extends AbstractDialogBuilder<CalendarDialogBuilder>
implements CalendarDialogBuilder {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(DefaultCalendarDialogBuilder.class.getName());
    private LocalDate initialDate;
    private LocalDateTime initialDateTime;

    DefaultCalendarDialogBuilder() {
    }

    @Override
    public CalendarDialogBuilder initialValue(LocalDate initialValue) {
        this.initialDate = initialValue;
        if (initialValue != null) {
            this.initialDateTime = initialValue.atStartOfDay();
        }
        return this;
    }

    @Override
    public CalendarDialogBuilder initialValue(LocalDateTime initialValue) {
        this.initialDateTime = initialValue;
        if (initialValue != null) {
            this.initialDate = initialValue.toLocalDate();
        }
        return this;
    }

    @Override
    public Optional<LocalDate> selectLocalDate() {
        CalendarPanel calendarPanel = CalendarPanel.dateCalendarPanel();
        if (this.initialDate != null) {
            calendarPanel.setLocalDate(this.initialDate);
        }
        State okPressed = State.state();
        ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)new DefaultOkCancelDialogBuilder(calendarPanel).owner(this.owner)).locationRelativeTo(this.locationRelativeTo)).title(MESSAGES.getString("select_date"))).onShown(dialog -> calendarPanel.requestCurrentDayButtonFocus())).onOk(() -> okPressed.set((Object)true)).show();
        return (Boolean)okPressed.get() != false ? Optional.of(calendarPanel.getLocalDate()) : Optional.empty();
    }

    @Override
    public Optional<LocalDateTime> selectLocalDateTime() {
        CalendarPanel calendarPanel = CalendarPanel.dateTimeCalendarPanel();
        if (this.initialDateTime != null) {
            calendarPanel.setLocalDateTime(this.initialDateTime);
        }
        State okPressed = State.state();
        ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)new DefaultOkCancelDialogBuilder(calendarPanel).owner(this.owner)).locationRelativeTo(this.locationRelativeTo)).title(MESSAGES.getString("select_date_time"))).onShown(dialog -> calendarPanel.requestCurrentDayButtonFocus())).onOk(() -> okPressed.set((Object)true)).show();
        return (Boolean)okPressed.get() != false ? Optional.of(calendarPanel.getLocalDateTime()) : Optional.empty();
    }
}

