/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.control;

import is.codion.common.state.StateObserver;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.DefaultControls;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

final class ControlsBuilder
implements Controls.Builder {
    private final List<Action> controls = new ArrayList<Action>();
    private String name;
    private String description;
    private char mnemonic = '\u0000';
    private StateObserver enabled;
    private Icon smallIcon;
    private Icon largeIcon;
    private KeyStroke keyStroke;

    ControlsBuilder() {
    }

    @Override
    public Controls.Builder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Controls.Builder description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public Controls.Builder mnemonic(char mnenomic) {
        this.mnemonic = mnenomic;
        return this;
    }

    @Override
    public Controls.Builder keyStroke(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
        return this;
    }

    @Override
    public Controls.Builder enabled(StateObserver enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public Controls.Builder smallIcon(Icon smallIcon) {
        this.smallIcon = smallIcon;
        return this;
    }

    @Override
    public Control.Builder largeIcon(Icon largeIcon) {
        this.largeIcon = largeIcon;
        return this;
    }

    @Override
    public Controls.Builder control(Control control) {
        this.controls.add(Objects.requireNonNull(control));
        return this;
    }

    @Override
    public Controls.Builder control(Control.Builder controlBuilder) {
        this.controls.add(Objects.requireNonNull(controlBuilder).build());
        return this;
    }

    @Override
    public Controls.Builder controls(Control ... controls) {
        this.controls.addAll(Arrays.asList(Objects.requireNonNull(controls)));
        return this;
    }

    @Override
    public Controls.Builder controls(Control.Builder ... controlBuilders) {
        this.controls.addAll(Arrays.stream(controlBuilders).map(new BuildControl()).collect(Collectors.toList()));
        return this;
    }

    @Override
    public Controls.Builder action(Action action) {
        this.controls.add(Objects.requireNonNull(action));
        return this;
    }

    @Override
    public Controls.Builder actions(Action ... actions) {
        this.controls.addAll(Arrays.asList(Objects.requireNonNull(actions)));
        return this;
    }

    @Override
    public Controls.Builder separator() {
        this.controls.add(null);
        return this;
    }

    @Override
    public Controls build() {
        DefaultControls defaultControls = new DefaultControls(this.name, this.enabled, this.controls);
        defaultControls.setMnemonic(this.mnemonic);
        defaultControls.setSmallIcon(this.smallIcon);
        defaultControls.setLargeIcon(this.largeIcon);
        defaultControls.setDescription(this.description);
        defaultControls.setKeyStroke(this.keyStroke);
        return defaultControls;
    }

    private static final class BuildControl
    implements Function<Control.Builder, Control> {
        private BuildControl() {
        }

        @Override
        public Control apply(Control.Builder builder) {
            return builder.build();
        }
    }
}

