/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.value.Value;
import java.util.ResourceBundle;

final class StringLengthValidator
implements Value.Validator<String> {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(StringLengthValidator.class.getName());
    private int maximumLength;

    StringLengthValidator(int maximumLength) {
        this.maximumLength = maximumLength;
    }

    int getMaximumLength() {
        return this.maximumLength;
    }

    void setMaximumLength(int maximumLength) {
        this.maximumLength = maximumLength < 0 ? -1 : maximumLength;
    }

    public void validate(String text) {
        if (text != null && this.maximumLength >= 0 && text.length() > this.maximumLength) {
            throw new IllegalArgumentException(MESSAGES.getString("length_exceeds_maximum") + " " + this.maximumLength);
        }
    }
}

