/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.value.Value;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.Document;

public class HintTextField
extends JTextField {
    private final Value<String> hintText;
    private Color hintColor;

    public HintTextField(Document document) {
        this(document, null);
    }

    public HintTextField(String hintText) {
        this(null, hintText);
    }

    public HintTextField(Document document, String hintText) {
        super(document, null, 0);
        this.hintText = Value.value((Object)hintText, (Object)"");
        this.hintText.addListener(this::repaint);
        this.updateHintTextColor();
        this.addPropertyChangeListener("UI", new UpdateHintTextColorOnUIChange());
        this.addFocusListener(new UpdateHintFocusListener());
    }

    public final Value<String> hintText() {
        return this.hintText;
    }

    @Override
    public final void paint(Graphics graphics) {
        super.paint(graphics);
        if (!((String)this.hintText.get()).isEmpty() && !this.isFocusOwner() && this.getText().isEmpty()) {
            this.paintHintText(graphics);
        }
    }

    @Override
    public final void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        super.addPropertyChangeListener(property, listener);
    }

    @Override
    public final synchronized void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
    }

    private void paintHintText(Graphics graphics) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Insets insets = this.getInsets();
        graphics.setColor(this.hintColor);
        graphics.drawString((String)this.hintText.get(), insets.left, this.getHeight() - graphics.getFontMetrics().getDescent() - insets.bottom);
    }

    private void updateHintTextColor() {
        this.hintColor = HintTextField.hintForegroundColor();
        this.repaint();
    }

    private static Color hintForegroundColor() {
        Color foreground = UIManager.getColor("TextField.foreground");
        Color background = UIManager.getColor("TextField.background");
        int r = (int)Math.sqrt((Math.pow(background.getRed(), 2.0) + Math.pow(foreground.getRed(), 2.0)) / 2.0);
        int g = (int)Math.sqrt((Math.pow(background.getGreen(), 2.0) + Math.pow(foreground.getGreen(), 2.0)) / 2.0);
        int b = (int)Math.sqrt((Math.pow(background.getBlue(), 2.0) + Math.pow(foreground.getBlue(), 2.0)) / 2.0);
        return new Color(r, g, b, foreground.getAlpha());
    }

    private final class UpdateHintTextColorOnUIChange
    implements PropertyChangeListener {
        private UpdateHintTextColorOnUIChange() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            HintTextField.this.updateHintTextColor();
        }
    }

    private final class UpdateHintFocusListener
    implements FocusListener {
        private UpdateHintFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            HintTextField.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            HintTextField.this.repaint();
        }
    }
}

