/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.text;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.KeyEvents;
import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.text.CaseDocumentFilter;
import is.codion.swing.common.ui.component.text.DeleteNextWordAction;
import is.codion.swing.common.ui.component.text.DeletePreviousWordAction;
import is.codion.swing.common.ui.component.text.MaximumTextFieldLength;
import is.codion.swing.common.ui.component.text.MoveCaretToEndListener;
import is.codion.swing.common.ui.component.text.MoveCaretToStartListener;
import is.codion.swing.common.ui.component.text.OnTextChangedListener;
import is.codion.swing.common.ui.component.text.SelectAllFocusListener;
import is.codion.swing.common.ui.component.text.TextComponentBuilder;
import is.codion.swing.common.ui.component.text.TextFieldDocumentCase;
import is.codion.swing.common.ui.component.text.UpdateOn;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

abstract class AbstractTextComponentBuilder<T, C extends JTextComponent, B extends TextComponentBuilder<T, C, B>>
extends AbstractComponentBuilder<T, C, B>
implements TextComponentBuilder<T, C, B> {
    protected UpdateOn updateOn = UpdateOn.VALUE_CHANGE;
    private final List<CaretListener> caretListeners = new ArrayList<CaretListener>();
    private boolean editable = true;
    private boolean upperCase;
    private boolean lowerCase;
    private int maximumLength = -1;
    private Insets margin;
    private boolean controlDeleteWord = true;
    private Color disabledTextColor;
    private Color selectedTextColor;
    private Color selectionColor;
    private boolean selectAllOnFocusGained;
    private boolean moveCaretToEndOnFocusGained;
    private boolean moveCaretToStartOnFocusGained;
    private Consumer<String> onTextChanged;
    private boolean dragEnabled = false;
    private Character focusAcceleratorKey;

    protected AbstractTextComponentBuilder(Value<T> linkedValue) {
        super(linkedValue);
    }

    @Override
    public final B editable(boolean editable) {
        this.editable = editable;
        return (B)this;
    }

    @Override
    public final B updateOn(UpdateOn updateOn) {
        this.updateOn = Objects.requireNonNull(updateOn);
        return (B)this;
    }

    @Override
    public final B upperCase(boolean upperCase) {
        if (upperCase && this.lowerCase) {
            throw new IllegalArgumentException("Field is already lowercase");
        }
        this.upperCase = upperCase;
        return (B)this;
    }

    @Override
    public final B lowerCase(boolean lowerCase) {
        if (lowerCase && this.upperCase) {
            throw new IllegalArgumentException("Field is already uppercase");
        }
        this.lowerCase = lowerCase;
        return (B)this;
    }

    @Override
    public final B maximumLength(int maximumLength) {
        this.maximumLength = maximumLength;
        return (B)this;
    }

    @Override
    public final B margin(Insets margin) {
        this.margin = margin;
        return (B)this;
    }

    @Override
    public final B controlDeleteWord(boolean controlDeleteWord) {
        this.controlDeleteWord = controlDeleteWord;
        return (B)this;
    }

    @Override
    public final B disabledTextColor(Color disabledTextColor) {
        this.disabledTextColor = Objects.requireNonNull(disabledTextColor);
        return (B)this;
    }

    @Override
    public final B selectedTextColor(Color selectedTextColor) {
        this.selectedTextColor = Objects.requireNonNull(selectedTextColor);
        return (B)this;
    }

    @Override
    public final B selectionColor(Color selectionColor) {
        this.selectionColor = Objects.requireNonNull(selectionColor);
        return (B)this;
    }

    @Override
    public final B selectAllOnFocusGained(boolean selectAllOnFocusGained) {
        this.selectAllOnFocusGained = selectAllOnFocusGained;
        return (B)this;
    }

    @Override
    public final B moveCaretToEndOnFocusGained(boolean moveCaretToEndOnFocusGained) {
        if (this.moveCaretToStartOnFocusGained) {
            throw new IllegalArgumentException("Caret is already set to move to start on focus gained");
        }
        this.moveCaretToEndOnFocusGained = moveCaretToEndOnFocusGained;
        return (B)this;
    }

    @Override
    public final B moveCaretToStartOnFocusGained(boolean moveCaretToStartOnFocusGained) {
        if (this.moveCaretToEndOnFocusGained) {
            throw new IllegalArgumentException("Caret is already set to move to end on focus gained");
        }
        this.moveCaretToStartOnFocusGained = moveCaretToStartOnFocusGained;
        return (B)this;
    }

    @Override
    public final B caretListener(CaretListener caretListener) {
        this.caretListeners.add(Objects.requireNonNull(caretListener));
        return (B)this;
    }

    @Override
    public final B onTextChanged(Consumer<String> onTextChanged) {
        this.onTextChanged = Objects.requireNonNull(onTextChanged);
        return (B)this;
    }

    @Override
    public final B dragEnabled(boolean dragEnabled) {
        this.dragEnabled = dragEnabled;
        return (B)this;
    }

    @Override
    public final B focusAccelerator(char focusAcceleratorKey) {
        this.focusAcceleratorKey = Character.valueOf(focusAcceleratorKey);
        return (B)this;
    }

    @Override
    protected final C createComponent() {
        C textComponent = this.createTextComponent();
        ((JTextComponent)textComponent).setEditable(this.editable);
        ((JTextComponent)textComponent).setDragEnabled(this.dragEnabled);
        this.caretListeners.forEach(arg_0 -> textComponent.addCaretListener(arg_0));
        if (this.focusAcceleratorKey != null) {
            ((JTextComponent)textComponent).setFocusAccelerator(this.focusAcceleratorKey.charValue());
        }
        if (this.margin != null) {
            ((JTextComponent)textComponent).setMargin(this.margin);
        }
        if (this.upperCase) {
            new TextFieldDocumentCase(((JTextComponent)textComponent).getDocument(), CaseDocumentFilter.DocumentCase.UPPERCASE);
        }
        if (this.lowerCase) {
            new TextFieldDocumentCase(((JTextComponent)textComponent).getDocument(), CaseDocumentFilter.DocumentCase.LOWERCASE);
        }
        if (this.maximumLength > 0) {
            new MaximumTextFieldLength(((JTextComponent)textComponent).getDocument(), this.maximumLength);
        }
        if (this.controlDeleteWord) {
            this.keyEvent(KeyEvents.builder(127).modifiers(128).action(new DeleteNextWordAction()));
            this.keyEvent(KeyEvents.builder(8).modifiers(128).action(new DeletePreviousWordAction()));
        }
        if (this.disabledTextColor != null) {
            ((JTextComponent)textComponent).setDisabledTextColor(this.disabledTextColor);
        }
        if (this.selectedTextColor != null) {
            ((JTextComponent)textComponent).setSelectedTextColor(this.selectedTextColor);
        }
        if (this.selectionColor != null) {
            ((JTextComponent)textComponent).setSelectionColor(this.selectionColor);
        }
        if (this.selectAllOnFocusGained) {
            ((Component)textComponent).addFocusListener(new SelectAllFocusListener((JTextComponent)textComponent));
        }
        if (this.moveCaretToStartOnFocusGained) {
            ((Component)textComponent).addFocusListener(new MoveCaretToStartListener((JTextComponent)textComponent));
        }
        if (this.moveCaretToEndOnFocusGained) {
            ((Component)textComponent).addFocusListener(new MoveCaretToEndListener((JTextComponent)textComponent));
        }
        if (this.onTextChanged != null) {
            ((JTextComponent)textComponent).getDocument().addDocumentListener((DocumentListener)((Object)new OnTextChangedListener(this.onTextChanged, (JTextComponent)textComponent)));
        }
        return textComponent;
    }

    @Override
    protected void setInitialValue(C component, T initialValue) {
        if (initialValue instanceof String) {
            ((JTextComponent)component).setText((String)initialValue);
        } else if (initialValue instanceof Character) {
            ((JTextComponent)component).setText(String.valueOf(initialValue));
        } else if (initialValue != null) {
            throw new IllegalArgumentException("Unsupported type: " + initialValue.getClass());
        }
        ((JTextComponent)component).setCaretPosition(0);
    }

    protected abstract C createTextComponent();
}

