/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.table;

import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableColumnModel;
import is.codion.swing.common.ui.KeyEvents;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.scrollpane.ScrollPaneBuilder;
import is.codion.swing.common.ui.component.table.FilteredTable;
import is.codion.swing.common.ui.control.Control;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;

final class ColumnSelectionPanel<C>
extends JPanel {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(ColumnSelectionPanel.class.getName());
    private static final int COLUMNS_SELECTION_PANEL_HEIGHT = 250;
    private static final int COLUMN_SCROLL_BAR_UNIT_INCREMENT = 16;
    private final FilteredTableColumnModel<C> columnModel;
    private final Map<TableColumn, State> visibleStates;
    private final List<JCheckBox> checkBoxes;

    ColumnSelectionPanel(FilteredTableColumnModel<C> columnModel) {
        super(new BorderLayout());
        this.columnModel = columnModel;
        this.visibleStates = this.createVisibleStates();
        this.checkBoxes = this.visibleStates.entrySet().stream().map(entry -> (JCheckBox)((CheckBoxBuilder)Components.checkBox((Value<Boolean>)((Value)entry.getValue())).text(Objects.toString(((TableColumn)entry.getKey()).getHeaderValue()))).build()).collect(Collectors.toList());
        JScrollPane checkBoxPanel = this.createCheckBoxPanel();
        this.add((Component)this.createNorthPanel(checkBoxPanel.getBorder().getBorderInsets(checkBoxPanel)), "North");
        this.add((Component)checkBoxPanel, "Center");
    }

    void requestColumnPanelFocus() {
        if (!this.checkBoxes.isEmpty()) {
            this.checkBoxes.get(0).requestFocusInWindow();
        }
    }

    void applyChanges() {
        this.columnModel.visible().forEach(tableColumn -> {
            if (!((Boolean)this.visibleStates.get(tableColumn).get()).booleanValue()) {
                this.columnModel.visible(tableColumn.getIdentifier()).set((Object)false);
            }
        });
        new ArrayList<FilteredTableColumn>(this.columnModel.hidden()).forEach(tableColumn -> {
            if (((Boolean)this.visibleStates.get(tableColumn).get()).booleanValue()) {
                this.columnModel.visible(tableColumn.getIdentifier()).set((Object)true);
            }
        });
    }

    private Map<TableColumn, State> createVisibleStates() {
        LinkedHashMap<TableColumn, State> states = new LinkedHashMap<TableColumn, State>();
        this.columnModel.columns().stream().sorted(new FilteredTable.ColumnComparator()).forEach(column -> states.put((TableColumn)column, State.state((boolean)((Boolean)this.columnModel.visible(column.getIdentifier()).get()))));
        return states;
    }

    private JPanel createNorthPanel(Insets insets) {
        JCheckBox selectAllBox = (JCheckBox)((CheckBoxBuilder)((CheckBoxBuilder)((CheckBoxBuilder)Components.checkBox().linkedValue(State.and(this.visibleStates.values()))).text(MESSAGES.getString("select_all"))).mnemonic(MESSAGES.getString("select_all_mnemonic").charAt(0))).build();
        JCheckBox selectNoneBox = (JCheckBox)((CheckBoxBuilder)((CheckBoxBuilder)((CheckBoxBuilder)Components.checkBox().linkedValue(State.and((Collection)this.visibleStates.values().stream().map(StateObserver::not).collect(Collectors.toList())))).text(MESSAGES.getString("select_none"))).mnemonic(MESSAGES.getString("select_none_mnemonic").charAt(0))).build();
        selectAllBox.addActionListener(new SelectAll(selectAllBox, selectNoneBox));
        selectNoneBox.addActionListener(new SelectNone(selectAllBox, selectNoneBox));
        List<JCheckBox> selectCheckBoxes = Arrays.asList(selectAllBox, selectNoneBox);
        KeyEvents.builder(38).condition(0).action(Control.control(new TransferFocusCommand(selectCheckBoxes, false))).enable(selectAllBox).enable(selectNoneBox);
        KeyEvents.builder(40).condition(0).action(Control.control(new TransferFocusCommand(selectCheckBoxes, true))).enable(selectAllBox).enable(selectNoneBox);
        return (JPanel)((PanelBuilder)Components.gridLayoutPanel(2, 1).addAll(selectAllBox, selectNoneBox).border(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right))).build();
    }

    private void selectAll() {
        this.visibleStates.values().forEach(state -> state.set((Object)true));
    }

    private void selectNone() {
        this.visibleStates.values().forEach(state -> state.set((Object)false));
    }

    private JScrollPane createCheckBoxPanel() {
        final JPanel northPanel = (JPanel)Components.gridLayoutPanel(0, 1).addAll(this.checkBoxes).build();
        KeyEvents.Builder upEventBuilder = KeyEvents.builder(38).condition(0).action(Control.control(new TransferFocusCommand(this.checkBoxes, false)));
        KeyEvents.Builder downEventBuilder = KeyEvents.builder(40).condition(0).action(Control.control(new TransferFocusCommand(this.checkBoxes, true)));
        this.checkBoxes.forEach(checkBox -> {
            upEventBuilder.enable((JComponent)checkBox);
            downEventBuilder.enable((JComponent)checkBox);
            checkBox.addFocusListener(new FocusAdapter((JCheckBox)checkBox){
                final /* synthetic */ JCheckBox val$checkBox;
                {
                    this.val$checkBox = jCheckBox;
                }

                @Override
                public void focusGained(FocusEvent e) {
                    northPanel.scrollRectToVisible(this.val$checkBox.getBounds());
                }
            });
        });
        return (JScrollPane)((ScrollPaneBuilder)Components.borderLayoutPanel().northComponent(northPanel).scrollPane().preferredHeight(250)).verticalUnitIncrement(16).build();
    }

    private final class SelectAll
    implements ActionListener {
        private final JCheckBox selectAllBox;
        private final JCheckBox selectNoneBox;

        private SelectAll(JCheckBox selectAllBox, JCheckBox selectNoneBox) {
            this.selectAllBox = selectAllBox;
            this.selectNoneBox = selectNoneBox;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.selectAllBox.isSelected()) {
                ColumnSelectionPanel.this.selectAll();
            } else {
                ColumnSelectionPanel.this.selectNone();
                this.selectNoneBox.setSelected(true);
            }
        }
    }

    private final class SelectNone
    implements ActionListener {
        private final JCheckBox selectAllBox;
        private final JCheckBox selectNoneBox;

        private SelectNone(JCheckBox selectAllBox, JCheckBox selectNoneBox) {
            this.selectAllBox = selectAllBox;
            this.selectNoneBox = selectNoneBox;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.selectNoneBox.isSelected()) {
                ColumnSelectionPanel.this.selectNone();
            } else {
                ColumnSelectionPanel.this.selectAll();
                this.selectAllBox.setSelected(true);
            }
        }
    }

    private static final class TransferFocusCommand
    implements Control.Command {
        private final List<JCheckBox> checkBoxes;
        private final boolean next;

        private TransferFocusCommand(List<JCheckBox> checkBoxes, boolean next) {
            this.next = next;
            this.checkBoxes = checkBoxes;
        }

        @Override
        public void perform() {
            this.checkBoxes.stream().filter(Component::isFocusOwner).findAny().ifPresent(checkBox -> this.checkBoxes.get(this.next ? this.nextIndex(this.checkBoxes.indexOf(checkBox)) : this.previousIndex(this.checkBoxes.indexOf(checkBox))).requestFocusInWindow());
        }

        private int nextIndex(int currentIndex) {
            return currentIndex == this.checkBoxes.size() - 1 ? 0 : currentIndex + 1;
        }

        private int previousIndex(int currentIndex) {
            return currentIndex == 0 ? this.checkBoxes.size() - 1 : currentIndex - 1;
        }
    }
}

