/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.panel;

import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.panel.PanelBuilder;
import is.codion.swing.common.ui.component.value.ComponentValue;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class DefaultPanelBuilder
extends AbstractComponentBuilder<Void, JPanel, PanelBuilder>
implements PanelBuilder {
    private final JPanel panel;
    private final List<ComponentConstraints> componentConstraints = new ArrayList<ComponentConstraints>();
    private LayoutManager layout;

    DefaultPanelBuilder(JPanel panel) {
        this.panel = Objects.requireNonNull(panel);
    }

    DefaultPanelBuilder(LayoutManager layout) {
        this.layout = layout;
        this.panel = null;
    }

    @Override
    public PanelBuilder layout(LayoutManager layoutManager) {
        this.layout = Objects.requireNonNull(layoutManager);
        return this;
    }

    @Override
    public PanelBuilder add(JComponent component) {
        this.componentConstraints.add(new ComponentConstraints(Objects.requireNonNull(component)));
        return this;
    }

    @Override
    public PanelBuilder add(JComponent component, Object constraints) {
        if (constraints instanceof JComponent) {
            throw new IllegalArgumentException("Use addAll() when adding multiple components");
        }
        this.componentConstraints.add(new ComponentConstraints(Objects.requireNonNull(component), Objects.requireNonNull(constraints)));
        return this;
    }

    @Override
    public PanelBuilder addAll(JComponent ... components) {
        this.addAll(Arrays.asList(components));
        return this;
    }

    @Override
    public PanelBuilder addAll(Collection<? extends JComponent> components) {
        Objects.requireNonNull(components).forEach(component -> this.componentConstraints.add(new ComponentConstraints(Objects.requireNonNull(component))));
        return this;
    }

    @Override
    protected JPanel createComponent() {
        JPanel component;
        JPanel jPanel = component = this.panel == null ? new JPanel() : this.panel;
        if (this.layout != null) {
            component.setLayout(this.layout);
        }
        this.componentConstraints.forEach(componentConstraint -> {
            if (componentConstraint.constraints != null) {
                component.add((Component)componentConstraint.component, componentConstraint.constraints);
            } else {
                component.add(componentConstraint.component);
            }
        });
        return component;
    }

    @Override
    protected ComponentValue<Void, JPanel> createComponentValue(JPanel component) {
        throw new UnsupportedOperationException("A ComponentValue can not be based on a JPanel");
    }

    @Override
    protected void setInitialValue(JPanel component, Void initialValue) {
    }

    private static final class ComponentConstraints {
        private final JComponent component;
        private final Object constraints;

        private ComponentConstraints(JComponent component) {
            this(component, null);
        }

        private ComponentConstraints(JComponent component, Object constraints) {
            this.component = component;
            this.constraints = constraints;
        }
    }
}

