/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.button;

import is.codion.swing.common.ui.component.button.CheckBoxMenuItemBuilder;
import is.codion.swing.common.ui.component.button.ControlHandler;
import is.codion.swing.common.ui.component.button.DefaultMenuItemBuilder;
import is.codion.swing.common.ui.component.button.MenuBuilder;
import is.codion.swing.common.ui.component.button.MenuItemBuilder;
import is.codion.swing.common.ui.component.button.ToggleMenuItemBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuListener;

final class DefaultMenuBuilder
extends DefaultMenuItemBuilder<JMenu, MenuBuilder>
implements MenuBuilder {
    private final Controls controls;
    private final List<MenuListener> menuListeners = new ArrayList<MenuListener>();
    private final List<PopupMenuListener> popupMenuListeners = new ArrayList<PopupMenuListener>();
    private MenuItemBuilder<?, ?> menuItemBuilder = MenuItemBuilder.builder();
    private ToggleMenuItemBuilder<?, ?> toggleMenuItemBuilder = CheckBoxMenuItemBuilder.builder();

    DefaultMenuBuilder(Controls controls) {
        super(controls);
        this.controls = controls == null ? Controls.controls() : controls;
    }

    @Override
    public MenuBuilder controls(Controls controls) {
        this.controls.add(Objects.requireNonNull(controls));
        return this;
    }

    @Override
    public MenuBuilder separator() {
        this.controls.addSeparator();
        return this;
    }

    @Override
    public MenuBuilder menuListener(MenuListener menuListener) {
        this.menuListeners.add(Objects.requireNonNull(menuListener));
        return this;
    }

    @Override
    public MenuBuilder popupMenuListener(PopupMenuListener popupMenuListener) {
        this.popupMenuListeners.add(Objects.requireNonNull(popupMenuListener));
        return this;
    }

    @Override
    public MenuBuilder menuItemBuilder(MenuItemBuilder<?, ?> menuItemBuilder) {
        this.menuItemBuilder = Objects.requireNonNull(menuItemBuilder);
        return this;
    }

    @Override
    public MenuBuilder toggleMenuItemBuilder(ToggleMenuItemBuilder<?, ?> toggleMenuItemBuilder) {
        this.toggleMenuItemBuilder = Objects.requireNonNull(toggleMenuItemBuilder);
        return this;
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = ((JMenu)this.createComponent()).getPopupMenu();
        this.popupMenuListeners.forEach(popupMenu::addPopupMenuListener);
        return popupMenu;
    }

    @Override
    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.controls.actions().stream().filter(Controls.class::isInstance).map(Controls.class::cast).filter(Controls::notEmpty).forEach(subControls -> menuBar.add((JMenu)new DefaultMenuBuilder((Controls)subControls).createComponent()));
        return menuBar;
    }

    @Override
    protected JMenu createButton() {
        JMenu menu = new JMenu(this.controls);
        this.menuListeners.forEach(menu::addMenuListener);
        new MenuControlHandler(menu, this.controls, this.menuItemBuilder, this.toggleMenuItemBuilder);
        return menu;
    }

    private static final class MenuControlHandler
    extends ControlHandler {
        private final JMenu menu;
        private final MenuItemBuilder<?, ?> menuItemBuilder;
        private final ToggleMenuItemBuilder<?, ?> toggleMenuItemBuilder;

        private MenuControlHandler(JMenu menu, Controls controls, MenuItemBuilder<?, ?> menuItemBuilder, ToggleMenuItemBuilder<?, ?> toggleMenuItemBuilder) {
            this.menu = menu;
            this.menuItemBuilder = (MenuItemBuilder)menuItemBuilder.clear();
            this.toggleMenuItemBuilder = (ToggleMenuItemBuilder)toggleMenuItemBuilder.clear();
            controls.actions().forEach(this);
        }

        @Override
        void onSeparator() {
            this.menu.addSeparator();
        }

        @Override
        void onControl(Control control) {
            this.menu.add((JMenuItem)((MenuItemBuilder)this.menuItemBuilder.control(control)).build());
            this.menuItemBuilder.clear();
        }

        @Override
        void onToggleControl(ToggleControl toggleControl) {
            this.menu.add((JMenuItem)this.toggleMenuItemBuilder.toggleControl(toggleControl).build());
            this.toggleMenuItemBuilder.clear();
        }

        @Override
        void onControls(Controls controls) {
            JMenu subMenu = new JMenu(controls);
            new MenuControlHandler(subMenu, controls, this.menuItemBuilder, this.toggleMenuItemBuilder);
            this.menu.add(subMenu);
        }

        @Override
        void onAction(Action action) {
            this.menu.add(action);
        }
    }
}

