/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.button;

import is.codion.swing.common.ui.component.button.AbstractControlPanelBuilder;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.ButtonPanelBuilder;
import is.codion.swing.common.ui.component.button.ControlHandler;
import is.codion.swing.common.ui.component.button.ToggleButtonBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class DefaultButtonPanelBuilder
extends AbstractControlPanelBuilder<JPanel, ButtonPanelBuilder>
implements ButtonPanelBuilder {
    private boolean buttonsFocusable = true;
    private Dimension preferredButtonSize;
    private int buttonGap = (Integer)Layouts.GAP.get();

    DefaultButtonPanelBuilder(Action ... actions) {
        this(Controls.controls(actions));
    }

    DefaultButtonPanelBuilder(Controls controls) {
        super(controls);
    }

    @Override
    public ButtonPanelBuilder buttonsFocusable(boolean buttonsFocusable) {
        this.buttonsFocusable = buttonsFocusable;
        return this;
    }

    @Override
    public ButtonPanelBuilder preferredButtonSize(Dimension preferredButtonSize) {
        this.preferredButtonSize = Objects.requireNonNull(preferredButtonSize);
        return this;
    }

    @Override
    public ButtonPanelBuilder buttonGap(int buttonGap) {
        this.buttonGap = buttonGap;
        return this;
    }

    @Override
    protected JPanel createComponent() {
        JPanel panel = this.createPanel();
        new ButtonControlHandler(panel, this.controls(), this.getButtonBuilder(), this.getToggleButtonBuilder());
        return panel;
    }

    private JPanel createPanel() {
        return new JPanel(this.orientation() == 0 ? new GridLayout(1, 0, this.buttonGap, 0) : new GridLayout(0, 1, 0, this.buttonGap));
    }

    private ToggleButtonBuilder<?, ?> getToggleButtonBuilder() {
        return this.toggleButtonBuilder().orElse((ToggleButtonBuilder)((ToggleButtonBuilder)this.createToggleButtonBuilder().focusable(this.buttonsFocusable)).preferredSize(this.preferredButtonSize));
    }

    private ButtonBuilder<?, ?, ?> getButtonBuilder() {
        return this.buttonBuilder().orElse((ButtonBuilder)((ButtonBuilder)ButtonBuilder.builder().focusable(this.buttonsFocusable)).preferredSize(this.preferredButtonSize));
    }

    private final class ButtonControlHandler
    extends ControlHandler {
        private final JPanel panel;
        private final ButtonBuilder<?, ?, ?> buttonBuilder;
        private final ToggleButtonBuilder<?, ?> toggleButtonBuilder;

        private ButtonControlHandler(JPanel panel, Controls controls, ButtonBuilder<?, ?, ?> buttonBuilder, ToggleButtonBuilder<?, ?> toggleButtonBuilder) {
            this.panel = panel;
            this.buttonBuilder = (ButtonBuilder)buttonBuilder.clear();
            this.toggleButtonBuilder = (ToggleButtonBuilder)toggleButtonBuilder.clear();
            controls.actions().forEach(this);
        }

        @Override
        void onSeparator() {
            this.panel.add(new JLabel());
        }

        @Override
        void onControl(Control control) {
            this.onAction(control);
        }

        @Override
        void onToggleControl(ToggleControl toggleControl) {
            this.panel.add((Component)this.toggleButtonBuilder.toggleControl(toggleControl).build());
            this.toggleButtonBuilder.clear();
        }

        @Override
        void onControls(Controls controls) {
            JPanel controlPanel = DefaultButtonPanelBuilder.this.createPanel();
            new ButtonControlHandler(controlPanel, controls, this.buttonBuilder, this.toggleButtonBuilder);
            this.panel.add(controlPanel);
        }

        @Override
        void onAction(Action action) {
            this.panel.add((Component)this.buttonBuilder.action(action).build());
            this.buttonBuilder.clear();
        }
    }
}

