/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.button;

import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.button.AbstractButtonBuilder;
import is.codion.swing.common.ui.component.button.BooleanToggleButtonValue;
import is.codion.swing.common.ui.component.button.ToggleMenuItemBuilder;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.ToggleControl;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;

abstract class AbstractToggleMenuItemBuilder<C extends JMenuItem, B extends ToggleMenuItemBuilder<C, B>>
extends AbstractButtonBuilder<Boolean, C, B>
implements ToggleMenuItemBuilder<C, B> {
    private ToggleControl toggleControl;
    private ToggleMenuItemBuilder.PersistMenu persistMenu = (ToggleMenuItemBuilder.PersistMenu)((Object)PERSIST_MENU.get());

    AbstractToggleMenuItemBuilder(Value<Boolean> linkedValue) {
        super(linkedValue);
        this.horizontalAlignment(10);
    }

    @Override
    public final B toggleControl(ToggleControl toggleControl) {
        if (Objects.requireNonNull(toggleControl).value().nullable()) {
            throw new IllegalArgumentException("A toggle menu item does not support a nullable value");
        }
        this.toggleControl = toggleControl;
        this.action(toggleControl);
        return (B)this;
    }

    @Override
    public final B toggleControl(ToggleControl.Builder toggleControlBuilder) {
        return this.toggleControl(Objects.requireNonNull(toggleControlBuilder).build());
    }

    @Override
    public final B persistMenu(ToggleMenuItemBuilder.PersistMenu persistMenu) {
        this.persistMenu = Objects.requireNonNull(persistMenu);
        return (B)this;
    }

    protected abstract JMenuItem createMenuItem(ToggleMenuItemBuilder.PersistMenu var1);

    @Override
    protected final C createButton() {
        JMenuItem menuItem = this.createMenuItem(this.persistMenu);
        if (this.toggleControl != null) {
            menuItem.setModel(AbstractToggleMenuItemBuilder.createButtonModel(this.toggleControl));
        }
        return (C)menuItem;
    }

    @Override
    protected final ComponentValue<Boolean, C> createComponentValue(C component) {
        return new BooleanToggleButtonValue<C>(component);
    }

    @Override
    protected final void setInitialValue(C component, Boolean initialValue) {
        ((AbstractButton)component).setSelected(initialValue);
    }

    @Override
    protected final boolean supportsNull() {
        return false;
    }
}

