/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.component.button;

import is.codion.swing.common.ui.component.builder.AbstractComponentBuilder;
import is.codion.swing.common.ui.component.button.ButtonBuilder;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.button.ControlPanelBuilder;
import is.codion.swing.common.ui.component.button.RadioButtonBuilder;
import is.codion.swing.common.ui.component.button.ToggleButtonBuilder;
import is.codion.swing.common.ui.component.button.ToggleButtonType;
import is.codion.swing.common.ui.component.value.ComponentValue;
import is.codion.swing.common.ui.control.Controls;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.JComponent;

abstract class AbstractControlPanelBuilder<C extends JComponent, B extends ControlPanelBuilder<C, B>>
extends AbstractComponentBuilder<Void, C, B>
implements ControlPanelBuilder<C, B> {
    private final Controls controls = Controls.controls();
    private int orientation = 0;
    private ToggleButtonType toggleButtonType = ToggleButtonType.BUTTON;
    private ButtonBuilder<?, ?, ?> buttonBuilder;
    private ToggleButtonBuilder<?, ?> toggleButtonBuilder;

    protected AbstractControlPanelBuilder(Controls controls) {
        if (controls != null) {
            this.controls.addAll(controls);
        }
    }

    @Override
    public final B orientation(int orientation) {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("Unknown orientation value: " + orientation);
        }
        this.orientation = orientation;
        return (B)this;
    }

    @Override
    public final B action(Action action) {
        this.controls.add(Objects.requireNonNull(action));
        return (B)this;
    }

    @Override
    public final B controls(Controls controls) {
        this.controls.addAll(Objects.requireNonNull(controls));
        return (B)this;
    }

    @Override
    public final B separator() {
        this.controls.addSeparator();
        return (B)this;
    }

    @Override
    public final B toggleButtonType(ToggleButtonType toggleButtonType) {
        this.toggleButtonType = Objects.requireNonNull(toggleButtonType);
        return (B)this;
    }

    @Override
    public final B buttonBuilder(ButtonBuilder<?, ?, ?> buttonBuilder) {
        this.buttonBuilder = Objects.requireNonNull(buttonBuilder);
        return (B)this;
    }

    @Override
    public final B toggleButtonBuilder(ToggleButtonBuilder<?, ?> toggleButtonBuilder) {
        this.toggleButtonBuilder = Objects.requireNonNull(toggleButtonBuilder);
        return (B)this;
    }

    @Override
    protected final ComponentValue<Void, C> createComponentValue(C component) {
        throw new UnsupportedOperationException("A ComponentValue can not be based on this component type");
    }

    @Override
    protected final void setInitialValue(C component, Void initialValue) {
    }

    protected final Controls controls() {
        return this.controls;
    }

    protected final int orientation() {
        return this.orientation;
    }

    protected final Optional<ButtonBuilder<?, ?, ?>> buttonBuilder() {
        return Optional.ofNullable(this.buttonBuilder);
    }

    protected final Optional<ToggleButtonBuilder<?, ?>> toggleButtonBuilder() {
        return Optional.ofNullable(this.toggleButtonBuilder);
    }

    protected final ToggleButtonBuilder<?, ?> createToggleButtonBuilder() {
        switch (this.toggleButtonType) {
            case CHECKBOX: {
                return CheckBoxBuilder.builder();
            }
            case BUTTON: {
                return ToggleButtonBuilder.builder();
            }
            case RADIO_BUTTON: {
                return RadioButtonBuilder.builder();
            }
        }
        throw new IllegalArgumentException("Unknown toggle button type: " + this.toggleButtonType);
    }
}

