/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui;

import is.codion.swing.common.ui.Utilities;
import java.awt.Cursor;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class WaitCursor {
    private static final Map<Window, Integer> WAIT_CURSOR_REQUESTS = new HashMap<Window, Integer>();
    private static final Cursor WAIT_CURSOR = new Cursor(3);
    private static final Cursor DEFAULT_CURSOR = new Cursor(0);

    private WaitCursor() {
    }

    public static void show(JComponent component) {
        WaitCursor.show(Utilities.parentWindow(component));
    }

    public static void hide(JComponent component) {
        WaitCursor.hide(Utilities.parentWindow(component));
    }

    public static void show(Window window) {
        WaitCursor.setWaitCursor(true, window);
    }

    public static void hide(Window window) {
        WaitCursor.setWaitCursor(false, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setWaitCursor(boolean on, Window window) {
        if (window == null) {
            return;
        }
        Map<Window, Integer> map = WAIT_CURSOR_REQUESTS;
        synchronized (map) {
            int requests = WAIT_CURSOR_REQUESTS.computeIfAbsent(window, win -> 0);
            requests = on ? ++requests : --requests;
            if (requests == 1 && on || requests == 0 && !on) {
                WaitCursor.setCursor(on, window);
            }
            if (requests == 0) {
                WAIT_CURSOR_REQUESTS.remove(window);
            } else {
                WAIT_CURSOR_REQUESTS.put(window, requests);
            }
        }
    }

    private static void setCursor(boolean on, Window window) {
        if (SwingUtilities.isEventDispatchThread()) {
            window.setCursor(on ? WAIT_CURSOR : DEFAULT_CURSOR);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> window.setCursor(on ? WAIT_CURSOR : DEFAULT_CURSOR));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

