/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui;

import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.state.StateObserver;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class Utilities {
    private static final String COMPONENT = "component";

    private Utilities() {
    }

    public static void updateUI(JComponent ... components) {
        if (components != null) {
            Utilities.updateUI(Arrays.asList(components));
        }
    }

    public static void updateUI(Collection<? extends JComponent> components) {
        if (components != null) {
            for (JComponent jComponent : components) {
                if (jComponent == null) continue;
                jComponent.updateUI();
            }
        }
    }

    public static void linkToEnabledState(StateObserver enabledState, Action ... actions) {
        Objects.requireNonNull(enabledState, "enabledState");
        Objects.requireNonNull(actions, "actions");
        for (Action action : actions) {
            if (action == null) continue;
            action.setEnabled((Boolean)enabledState.get());
            enabledState.addDataListener((Consumer)new EnableActionListener(action));
        }
    }

    public static void linkToEnabledState(StateObserver enabledState, JComponent ... components) {
        Objects.requireNonNull(enabledState, "enabledState");
        Objects.requireNonNull(components, "components");
        for (JComponent component : components) {
            if (component == null) continue;
            component.setEnabled((Boolean)enabledState.get());
            enabledState.addDataListener((Consumer)new EnableComponentListener(component));
        }
    }

    public static <T> EventObserver<T> propertyChangeObserver(JComponent component, String property) {
        Objects.requireNonNull(component, COMPONENT);
        Objects.requireNonNull(property, "property");
        Event event = Event.event();
        component.addPropertyChangeListener(property, changeEvent -> event.accept(changeEvent.getNewValue()));
        return event.observer();
    }

    public static void linkBoundedRangeModels(BoundedRangeModel main, BoundedRangeModel linked) {
        main.addChangeListener(new BoundedRangeModelListener(Objects.requireNonNull(main, "main"), Objects.requireNonNull(linked, "linked")));
    }

    public static void expandAll(JTree tree, TreePath parent) {
        Objects.requireNonNull(tree, "tree");
        Objects.requireNonNull(parent, "parent");
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                Utilities.expandAll(tree, parent.pathByAddingChild(e.nextElement()));
            }
        }
        tree.expandPath(parent);
    }

    public static void collapseAll(JTree tree, TreePath parent) {
        Objects.requireNonNull(tree, "tree");
        Objects.requireNonNull(parent, "parent");
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                Utilities.collapseAll(tree, parent.pathByAddingChild(e.nextElement()));
            }
        }
        tree.collapsePath(parent);
    }

    public static ImageIcon loadIcon(Class<?> resourceClass, String resourceName) {
        URL url = Objects.requireNonNull(resourceClass).getResource(resourceName);
        if (url == null) {
            throw new IllegalArgumentException("Resource: " + resourceName + " for class " + resourceClass + " not found");
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
    }

    public static void setFontSizePercentage(int fontSizePercentage) {
        float multiplier = (float)fontSizePercentage / 100.0f;
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        Enumeration enumeration = defaults.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            Object defaultValue = defaults.get(key);
            if (!(defaultValue instanceof Font)) continue;
            Font font = (Font)defaultValue;
            int newSize = Math.round((float)font.getSize() * multiplier);
            if (defaultValue instanceof FontUIResource) {
                defaults.put(key, new FontUIResource(font.getName(), font.getStyle(), newSize));
                continue;
            }
            defaults.put(key, new Font(font.getName(), font.getStyle(), newSize));
        }
    }

    public static void setClipboard(String string) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
    }

    public static <T> T parentOfType(Class<T> clazz, Component component) {
        return (T)SwingUtilities.getAncestorOfClass(clazz, component);
    }

    public static Window parentWindow(Component component) {
        if (component instanceof Window) {
            return (Window)component;
        }
        return Utilities.parentOfType(Window.class, component);
    }

    public static JFrame parentFrame(Component component) {
        if (component instanceof JFrame) {
            return (JFrame)component;
        }
        return Utilities.parentOfType(JFrame.class, component);
    }

    public static JDialog parentDialog(Component component) {
        if (component instanceof JDialog) {
            return (JDialog)component;
        }
        return Utilities.parentOfType(JDialog.class, component);
    }

    public static boolean disposeParentWindow(Component component) {
        Window parentWindow = Utilities.parentWindow(component);
        if (parentWindow != null) {
            parentWindow.dispose();
            return true;
        }
        return false;
    }

    public static String systemLookAndFeelClassName() {
        String systemLookAndFeel = UIManager.getSystemLookAndFeelClassName();
        if (systemLookAndFeel.endsWith("GTKLookAndFeel")) {
            systemLookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";
        }
        return systemLookAndFeel;
    }

    public static boolean systemOrCrossPlatformLookAndFeelEnabled() {
        String lookAndFeelClassName = UIManager.getLookAndFeel().getClass().getName();
        return lookAndFeelClassName.equals(Utilities.systemLookAndFeelClassName()) || lookAndFeelClassName.equals(UIManager.getCrossPlatformLookAndFeelClassName());
    }

    public static void printFocusOwner() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new PrintFocusOwnerPropertyChangeListener());
    }

    private static final class EnableActionListener
    implements Consumer<Boolean> {
        private final Action action;

        private EnableActionListener(Action action) {
            this.action = action;
        }

        @Override
        public void accept(Boolean enabled) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.action.setEnabled(enabled);
            } else {
                SwingUtilities.invokeLater(() -> this.action.setEnabled(enabled));
            }
        }
    }

    private static final class EnableComponentListener
    implements Consumer<Boolean> {
        private final JComponent component;

        private EnableComponentListener(JComponent component) {
            this.component = component;
        }

        @Override
        public void accept(Boolean enabled) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.component.setEnabled(enabled);
            } else {
                SwingUtilities.invokeLater(() -> this.component.setEnabled(enabled));
            }
        }
    }

    private static final class BoundedRangeModelListener
    implements ChangeListener {
        private final BoundedRangeModel main;
        private final BoundedRangeModel linked;

        private BoundedRangeModelListener(BoundedRangeModel main, BoundedRangeModel linked) {
            this.main = main;
            this.linked = linked;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.linked.setRangeProperties(this.main.getValue(), this.main.getExtent(), this.main.getMinimum(), this.main.getMaximum(), this.main.getValueIsAdjusting());
        }
    }

    private static final class PrintFocusOwnerPropertyChangeListener
    implements PropertyChangeListener {
        private PrintFocusOwnerPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            Component oldValue = (Component)changeEvent.getOldValue();
            Component newValue = (Component)changeEvent.getNewValue();
            System.out.println((oldValue == null ? "null" : oldValue.getClass().getSimpleName()) + " -> " + (newValue == null ? "null" : newValue.getClass().getSimpleName()));
        }
    }
}

