/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.tools.randomizer;

import is.codion.common.event.Event;
import is.codion.common.model.randomizer.ItemRandomizer;
import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.spinner.NumberSpinnerBuilder;
import is.codion.swing.common.ui.layout.Layouts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class ItemRandomizerPanel<T>
extends JPanel {
    private static final int SPINNER_COLUMNS = 3;
    private final ItemRandomizer<T> itemRandomizer;
    private final JPanel configPanel = new JPanel(Layouts.gridLayout((int)0, (int)1));
    private final JList<ItemRandomizer.RandomItem<T>> itemList = new JList(new DefaultListModel());
    private final Event<List<ItemRandomizer.RandomItem<T>>> selectedItemChangedEvent = Event.event();

    private ItemRandomizerPanel(ItemRandomizer<T> itemRandomizer) {
        this.itemRandomizer = Objects.requireNonNull(itemRandomizer, "itemRandomizer");
        this.initializeUI();
    }

    public ItemRandomizer<T> itemRandomizer() {
        return this.itemRandomizer;
    }

    public void addSelectedItemListener(Consumer<List<ItemRandomizer.RandomItem<T>>> listener) {
        this.selectedItemChangedEvent.addDataListener(listener);
    }

    public void removeSelectedItemListener(Consumer<List<ItemRandomizer.RandomItem<T>>> listener) {
        this.selectedItemChangedEvent.removeDataListener(listener);
    }

    public List<ItemRandomizer.RandomItem<T>> selectedItems() {
        return this.itemList.getSelectedValuesList();
    }

    public static <T> ItemRandomizerPanel<T> itemRandomizerPanel(ItemRandomizer<T> itemRandomizer) {
        return new ItemRandomizerPanel<T>(itemRandomizer);
    }

    private void initializeUI() {
        ArrayList<ItemRandomizer.RandomItem> items = new ArrayList<ItemRandomizer.RandomItem>(this.itemRandomizer.items());
        items.sort(Comparator.comparing(item -> item.item().toString()));
        items.forEach(((DefaultListModel)this.itemList.getModel())::addElement);
        this.itemList.addListSelectionListener(e -> this.selectedItemChangedEvent.accept(this.itemList.getSelectedValuesList()));
        this.addSelectedItemListener(selectedItems -> {
            this.configPanel.removeAll();
            for (ItemRandomizer.RandomItem item : selectedItems) {
                this.configPanel.add(this.createWeightPanel(item));
            }
            this.revalidate();
        });
        this.setLayout(Layouts.borderLayout());
        this.add((Component)new JScrollPane(this.itemList), "Center");
        this.add((Component)this.configPanel, "South");
    }

    private JPanel createWeightPanel(ItemRandomizer.RandomItem<T> item) {
        return (JPanel)Components.borderLayoutPanel((BorderLayout)Layouts.borderLayout()).northComponent((JComponent)new JLabel(item.item().toString())).westComponent(((CheckBoxBuilder)Components.checkBox((Value)new EnabledModelValue(item.item())).text("Enabled")).build()).centerComponent(Components.label((String)"Weight").horizontalAlignment(4).build()).eastComponent(((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner((Value)new WeightModelValue(item.item())).minimum((Number)0).columns(3)).toolTipText(item.item().toString())).build()).build();
    }

    private final class EnabledModelValue
    extends AbstractValue<Boolean> {
        private final T item;

        private EnabledModelValue(T item) {
            super((Object)false);
            this.item = item;
        }

        public Boolean get() {
            return ItemRandomizerPanel.this.itemRandomizer.isItemEnabled(this.item);
        }

        protected void setValue(Boolean value) {
            ItemRandomizerPanel.this.itemRandomizer.setItemEnabled(this.item, value.booleanValue());
        }
    }

    private final class WeightModelValue
    extends AbstractValue<Integer> {
        private final T item;

        private WeightModelValue(T item) {
            super((Object)0);
            this.item = item;
        }

        public Integer get() {
            return ItemRandomizerPanel.this.itemRandomizer.weight(this.item);
        }

        protected void setValue(Integer value) {
            ItemRandomizerPanel.this.itemRandomizer.setWeight(this.item, value.intValue());
        }
    }
}

