/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.ui.tools.loadtest;

import com.formdev.flatlaf.intellijthemes.FlatAllIJThemes;
import is.codion.common.Separators;
import is.codion.common.model.CancelException;
import is.codion.common.model.loadtest.LoadTest;
import is.codion.common.model.randomizer.ItemRandomizer;
import is.codion.common.state.State;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.model.tools.loadtest.LoadTestModel;
import is.codion.swing.common.ui.Utilities;
import is.codion.swing.common.ui.Windows;
import is.codion.swing.common.ui.component.Components;
import is.codion.swing.common.ui.component.button.CheckBoxBuilder;
import is.codion.swing.common.ui.component.button.ToggleButtonBuilder;
import is.codion.swing.common.ui.component.spinner.NumberSpinnerBuilder;
import is.codion.swing.common.ui.component.table.FilteredTable;
import is.codion.swing.common.ui.component.table.FilteredTableCellRenderer;
import is.codion.swing.common.ui.component.table.FilteredTableCellRendererFactory;
import is.codion.swing.common.ui.component.text.MemoryUsageField;
import is.codion.swing.common.ui.component.text.NumberField;
import is.codion.swing.common.ui.component.text.TextAreaBuilder;
import is.codion.swing.common.ui.component.text.TextFieldBuilder;
import is.codion.swing.common.ui.control.Control;
import is.codion.swing.common.ui.control.Controls;
import is.codion.swing.common.ui.control.ToggleControl;
import is.codion.swing.common.ui.dialog.Dialogs;
import is.codion.swing.common.ui.dialog.LoginDialogBuilder;
import is.codion.swing.common.ui.icon.Logos;
import is.codion.swing.common.ui.laf.LookAndFeelProvider;
import is.codion.swing.common.ui.layout.Layouts;
import is.codion.swing.common.ui.tools.loadtest.ChartUtil;
import is.codion.swing.common.ui.tools.randomizer.ItemRandomizerPanel;
import java.awt.Component;
import java.awt.Window;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;

public final class LoadTestPanel<T>
extends JPanel {
    private static final int DEFAULT_MEMORY_USAGE_UPDATE_INTERVAL_MS = 2000;
    private static final double DEFAULT_SCREEN_SIZE_RATIO = 0.75;
    private static final int USER_COLUMNS = 6;
    private static final int SMALL_TEXT_FIELD_COLUMNS = 3;
    private static final int SPINNER_STEP_SIZE = 10;
    private static final double RESIZE_WEIGHT = 0.8;
    private static final NumberFormat DURATION_FORMAT = NumberFormat.getIntegerInstance();
    private static final String DEFAULT_TITLE = "Codion LoadTest";
    private final LoadTestModel<T> loadTestModel;
    private final LoadTest<T> loadTest;
    private final JPanel scenarioBase = (JPanel)Components.gridLayoutPanel((int)0, (int)1).build();
    private boolean exiting;

    private LoadTestPanel(LoadTestModel<T> loadTestModel) {
        this.loadTestModel = Objects.requireNonNull(loadTestModel, "loadTestModel");
        this.loadTest = loadTestModel.loadTest();
        this.loadTestModel.applicationTableModel().refresher().addRefreshFailedListener(this::displayException);
        this.initializeUI();
    }

    public LoadTestModel<T> model() {
        return this.loadTestModel;
    }

    public void run() {
        SwingUtilities.invokeLater(this::showFrame);
    }

    public static <T> LoadTestPanel<T> loadTestPanel(LoadTestModel<T> loadTestModel) {
        return new LoadTestPanel<T>(loadTestModel);
    }

    private JFrame showFrame() {
        return Windows.frame((JComponent)this).icon(Logos.logoTransparent()).menuBar(Components.menu((Controls)this.createMainMenuControls()).createMenuBar()).title(this.loadTest.name().orElse(DEFAULT_TITLE)).defaultCloseOperation(2).onClosing(windowEvent -> this.exit()).size(Windows.screenSizeRatio((double)0.75)).centerFrame(true).show();
    }

    private Controls createMainMenuControls() {
        Control.Builder[] builderArray = new Control.Builder[1];
        builderArray[0] = ((Controls.Builder)((Controls.Builder)Controls.builder().name("View")).mnemonic('V')).control(Dialogs.lookAndFeelSelectionDialog().owner((JComponent)this).userPreferencePropertyName(LoadTestPanel.class.getName()).createControl()).control(ToggleControl.builder((State)this.loadTestModel.collectChartData()).name("Collect chart data")).control(Control.builder(() -> this.loadTestModel.clearCharts()).name("Clear charts"));
        return (Controls)Controls.builder().controls(new Control.Builder[]{((Controls.Builder)((Controls.Builder)Controls.builder().name("File")).mnemonic('F')).control(Control.builder(this::exit).name("Exit").mnemonic('X'))}).controls(builderArray).build();
    }

    private void initializeUI() {
        this.setLayout(Layouts.borderLayout());
        int gap = (Integer)Layouts.GAP.get();
        this.setBorder(BorderFactory.createEmptyBorder(gap, gap, 0, gap));
        this.add((Component)this.createCenterPanel(), "Center");
        this.add((Component)LoadTestPanel.createSouthPanel(), "South");
    }

    private ItemRandomizerPanel<LoadTest.Scenario<T>> createScenarioPanel() {
        ItemRandomizerPanel panel = ItemRandomizerPanel.itemRandomizerPanel(this.loadTest.scenarioChooser());
        panel.setBorder(BorderFactory.createTitledBorder("Usage scenarios"));
        panel.addSelectedItemListener(this::onScenarioSelectionChanged);
        return panel;
    }

    private JPanel createAddRemoveApplicationPanel() {
        return (JPanel)Components.borderLayoutPanel().westComponent(Components.button((Control.Builder)Control.builder(() -> this.loadTest.removeApplicationBatch()).name("-").description("Remove application batch")).build()).centerComponent(((NumberField.Builder)((NumberField.Builder)((NumberField.Builder)((NumberField.Builder)((NumberField.Builder)Components.integerField().editable(false)).focusable(false)).horizontalAlignment(0)).columns(5)).linkedValue(this.loadTest.applicationCount())).build()).eastComponent(Components.button((Control.Builder)Control.builder(() -> this.loadTest.addApplicationBatch()).name("+").description("Add application batch")).build()).build();
    }

    private JPanel createCenterPanel() {
        return (JPanel)Components.borderLayoutPanel().centerComponent(Components.tabbedPane().tab("Applications", (JComponent)this.createApplicationsPanel()).tab("Scenarios", Components.borderLayoutPanel().westComponent(this.createScenarioPanel()).centerComponent((JComponent)this.scenarioBase).build()).tab("Overview", Components.borderLayoutPanel().centerComponent(Components.splitPane().orientation(0).oneTouchExpandable(true).topComponent((JComponent)this.createScenarioOverviewChartPanel()).bottomComponent((JComponent)this.createSouthChartPanel()).resizeWeight(0.8).build()).build()).build()).build();
    }

    private JPanel createApplicationsPanel() {
        return (JPanel)Components.borderLayoutPanel().northComponent(Components.borderLayoutPanel().centerComponent(Components.flowLayoutPanel((int)3).add((JComponent)new JLabel("Batch size")).add(((NumberSpinnerBuilder)((NumberSpinnerBuilder)((NumberSpinnerBuilder)Components.integerSpinner((Value)this.loadTest.applicationBatchSize()).editable(false)).columns(3)).toolTipText("Application batch size")).build()).add((JComponent)this.createAddRemoveApplicationPanel()).add((JComponent)this.createUserPanel()).add((JComponent)new JLabel("Min. think time", 0)).add(((NumberSpinnerBuilder)Components.integerSpinner((Value)this.loadTest.minimumThinkTime()).stepSize((Number)10).columns(3)).build()).add((JComponent)new JLabel("Max. think time", 0)).add(((NumberSpinnerBuilder)Components.integerSpinner((Value)this.loadTest.maximumThinkTime()).stepSize((Number)10).columns(3)).build()).add(((ToggleButtonBuilder)((ToggleButtonBuilder)Components.toggleButton((Value)this.loadTest.paused()).text("Pause")).mnemonic(80)).build()).build()).eastComponent(((CheckBoxBuilder)Components.checkBox((Value)this.loadTestModel.autoRefreshApplications()).text("Automatic refresh")).build()).build()).centerComponent(Components.scrollPane(this.createApplicationsTable()).build()).build();
    }

    private JPanel createUserPanel() {
        User user = (User)this.loadTest.user().get();
        JTextField usernameField = (JTextField)((TextFieldBuilder)((TextFieldBuilder)Components.stringField().initialValue((Object)(user == null ? null : user.username()))).columns(6).editable(false)).build();
        this.loadTest.user().addDataListener(u -> usernameField.setText(u.username()));
        return (JPanel)Components.flexibleGridLayoutPanel((int)1, (int)3).add((JComponent)new JLabel("User")).add((JComponent)usernameField).add((JComponent)new JButton((Action)Control.builder(this::setUser).name("...").description("Set the application user").build())).build();
    }

    private void setUser() {
        User user = (User)this.loadTest.user().get();
        try {
            this.loadTest.user().set((Object)((LoginDialogBuilder)((LoginDialogBuilder)Dialogs.loginDialog().owner((Component)this)).title("User")).defaultUser(user == null ? null : User.user((String)user.username())).show());
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    private JTabbedPane createScenarioOverviewChartPanel() {
        return (JTabbedPane)Components.tabbedPane().tab("Scenarios run", (JComponent)this.createScenarioChartPanel()).tab("Failed runs", (JComponent)this.createFailureChartPanel()).build();
    }

    private ChartPanel createScenarioChartPanel() {
        JFreeChart scenarioChart = ChartFactory.createXYStepChart(null, null, null, (XYDataset)this.loadTestModel.scenarioDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.setColors(scenarioChart);
        ChartPanel scenarioChartPanel = new ChartPanel(scenarioChart);
        scenarioChartPanel.setBorder((Border)BorderFactory.createTitledBorder("Scenarios run per second"));
        return scenarioChartPanel;
    }

    private ChartPanel createFailureChartPanel() {
        JFreeChart failureChart = ChartFactory.createXYStepChart(null, null, null, (XYDataset)this.loadTestModel.scenarioFailureDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.setColors(failureChart);
        ChartPanel failureChartPanel = new ChartPanel(failureChart);
        failureChartPanel.setBorder((Border)BorderFactory.createTitledBorder("Scenario run failures per second"));
        return failureChartPanel;
    }

    private JPanel createSouthChartPanel() {
        return (JPanel)Components.gridLayoutPanel((int)1, (int)4).add((JComponent)this.createMemoryUsageChartPanel()).add((JComponent)this.createSystemLoadChartPanel()).add((JComponent)this.createThinkTimeChartPanel()).add((JComponent)this.createNumberOfApplicationsChartPanel()).build();
    }

    private ChartPanel createMemoryUsageChartPanel() {
        JFreeChart memoryUsageChart = ChartFactory.createXYStepChart(null, null, null, (XYDataset)this.loadTestModel.memoryUsageDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.setColors(memoryUsageChart);
        ChartPanel memoryUsageChartPanel = new ChartPanel(memoryUsageChart);
        memoryUsageChartPanel.setBorder((Border)BorderFactory.createTitledBorder("Memory usage (MB)"));
        return memoryUsageChartPanel;
    }

    private ChartPanel createSystemLoadChartPanel() {
        JFreeChart systemLoadChart = ChartFactory.createXYStepChart(null, null, null, (XYDataset)this.loadTestModel.systemLoadDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.setColors(systemLoadChart);
        systemLoadChart.getXYPlot().getRangeAxis().setRange(0.0, 100.0);
        ChartPanel systemLoadChartPanel = new ChartPanel(systemLoadChart);
        systemLoadChartPanel.setBorder((Border)BorderFactory.createTitledBorder("System load"));
        return systemLoadChartPanel;
    }

    private ChartPanel createThinkTimeChartPanel() {
        JFreeChart thinkTimeChart = ChartFactory.createXYStepChart(null, null, null, (XYDataset)this.loadTestModel.thinkTimeDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.setColors(thinkTimeChart);
        ChartPanel thinkTimeChartPanel = new ChartPanel(thinkTimeChart);
        thinkTimeChartPanel.setBorder((Border)BorderFactory.createTitledBorder("Think time (ms)"));
        return thinkTimeChartPanel;
    }

    private ChartPanel createNumberOfApplicationsChartPanel() {
        JFreeChart numberOfApplicationsChart = ChartFactory.createXYStepChart(null, null, null, (XYDataset)this.loadTestModel.numberOfApplicationsDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.setColors(numberOfApplicationsChart);
        ChartPanel numberOfApplicationsChartPanel = new ChartPanel(numberOfApplicationsChart);
        numberOfApplicationsChartPanel.setBorder((Border)BorderFactory.createTitledBorder("Application count"));
        return numberOfApplicationsChartPanel;
    }

    private FilteredTable<LoadTestModel.ApplicationRow, Integer> createApplicationsTable() {
        return (FilteredTable)((FilteredTable.Builder)FilteredTable.builder((FilteredTableModel)this.model().applicationTableModel()).autoResizeMode(4).doubleClickAction((Action)Control.control(this::viewException)).scrollToSelectedItem(false).cellRendererFactory((FilteredTableCellRendererFactory)new ApplicationTableCellRendererFactory()).popupMenuControls(table -> (Controls)Controls.builder().control(Control.builder(() -> ((FilteredTableModel)table.getModel()).refresh()).name("Refresh").enabled(this.model().autoRefreshApplications().not())).separator().control(Control.builder(() -> this.model().removeSelectedApplications()).name("Remove selected")).separator().controls(new Control[]{((Controls.Builder)Controls.builder().name("Columns")).control((Control)table.createToggleColumnsControls()).control(table.createResetColumnsControl()).control(table.createAutoResizeModeControl()).build()}).build())).build();
    }

    private void viewException() {
        this.model().applicationTableModel().selectionModel().selectedItem().map(LoadTestPanel::exception).ifPresent(this::displayException);
    }

    private void onScenarioSelectionChanged(List<ItemRandomizer.RandomItem<LoadTest.Scenario<T>>> selectedScenarios) {
        this.scenarioBase.removeAll();
        selectedScenarios.forEach(scenario -> this.scenarioBase.add(this.createScenarioPanel((LoadTest.Scenario)scenario.item())));
        this.validate();
        this.repaint();
    }

    private JPanel createScenarioPanel(LoadTest.Scenario<T> item) {
        return (JPanel)Components.borderLayoutPanel().centerComponent(Components.tabbedPane().tab("Duration", (JComponent)this.createScenarioDurationChartPanel(item)).tab("Exceptions", (JComponent)this.createScenarioExceptionsPanel(item)).build()).build();
    }

    private ChartPanel createScenarioDurationChartPanel(LoadTest.Scenario<T> scenario) {
        JFreeChart scenarioDurationChart = ChartFactory.createXYStepChart(null, null, null, (XYDataset)this.loadTestModel.scenarioDurationDataset(scenario.name()), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.setColors(scenarioDurationChart);
        ChartPanel scenarioDurationChartPanel = new ChartPanel(scenarioDurationChart);
        scenarioDurationChartPanel.setBorder(BorderFactory.createEtchedBorder());
        DeviationRenderer renderer = new DeviationRenderer();
        renderer.setDefaultShapesVisible(false);
        scenarioDurationChart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        return scenarioDurationChartPanel;
    }

    private JPanel createScenarioExceptionsPanel(LoadTest.Scenario<T> scenario) {
        JTextArea exceptionsArea = (JTextArea)((TextAreaBuilder)Components.textArea().editable(false)).build();
        JButton refreshButton = (JButton)Components.button((Control.Builder)Control.builder((Control.Command)new RefreshExceptionsCommand(exceptionsArea, scenario)).name("Refresh")).build();
        refreshButton.doClick();
        JButton clearButton = (JButton)Components.button((Control.Builder)Control.builder((Control.Command)new ClearExceptionsCommand(exceptionsArea, scenario)).name("Clear")).build();
        return (JPanel)Components.borderLayoutPanel().northComponent(Components.flowLayoutPanel((int)3).add((JComponent)refreshButton).add((JComponent)clearButton).build()).centerComponent(Components.scrollPane((JComponent)exceptionsArea).build()).build();
    }

    private void setColors(JFreeChart chart) {
        ChartUtil.linkColors(this, chart);
    }

    private synchronized void exit() {
        if (this.exiting) {
            return;
        }
        this.exiting = true;
        JFrame frame = Utilities.parentFrame((Component)this);
        if (frame != null) {
            frame.setTitle(frame.getTitle() + " - Closing...");
        }
        this.loadTest.shutdown();
        System.exit(0);
    }

    private void displayException(Throwable exception) {
        Dialogs.displayExceptionDialog((Throwable)exception, (Window)Utilities.parentWindow((Component)this));
    }

    private static Throwable exception(LoadTestModel.ApplicationRow application) {
        List results = application.results();
        return results.isEmpty() ? null : (Throwable)((LoadTest.Scenario.Result)results.get(results.size() - 1)).exception().orElse(null);
    }

    private static JPanel createSouthPanel() {
        return (JPanel)Components.flowLayoutPanel((int)4).add((JComponent)new JLabel("Memory usage:")).add((JComponent)new MemoryUsageField(2000)).build();
    }

    static {
        FilteredTableCellRenderer.NUMERICAL_HORIZONTAL_ALIGNMENT.set((Object)0);
        Arrays.stream(FlatAllIJThemes.INFOS).forEach(LookAndFeelProvider::addLookAndFeelProvider);
        LookAndFeelProvider.findLookAndFeelProvider((String)LookAndFeelProvider.defaultLookAndFeelName((String)LoadTestPanel.class.getName())).ifPresent(LookAndFeelProvider::enable);
    }

    private final class ApplicationTableCellRendererFactory
    implements FilteredTableCellRendererFactory<Integer> {
        private ApplicationTableCellRendererFactory() {
        }

        public TableCellRenderer tableCellRenderer(FilteredTableColumn<Integer> column) {
            FilteredTableCellRenderer.Builder builder = FilteredTableCellRenderer.builder((FilteredTableModel)LoadTestPanel.this.model().applicationTableModel(), (Object)((Integer)column.getIdentifier()), Integer.class);
            if (((Integer)column.getIdentifier()).equals(4)) {
                builder.displayValueProvider(duration -> duration == null ? null : DURATION_FORMAT.format(duration));
            }
            return builder.build();
        }
    }

    private final class RefreshExceptionsCommand
    implements Control.Command {
        private final JTextArea exceptionsTextArea;
        private final LoadTest.Scenario<?> scenario;

        private RefreshExceptionsCommand(JTextArea exceptionsTextArea, LoadTest.Scenario<?> scenario) {
            this.exceptionsTextArea = exceptionsTextArea;
            this.scenario = scenario;
        }

        public void execute() {
            this.exceptionsTextArea.replaceRange("", 0, this.exceptionsTextArea.getDocument().getLength());
            for (Throwable exception : LoadTestPanel.this.loadTestModel.exceptions(this.scenario.name())) {
                this.exceptionsTextArea.append(exception.getMessage());
                this.exceptionsTextArea.append(Separators.LINE_SEPARATOR);
                this.exceptionsTextArea.append(Separators.LINE_SEPARATOR);
            }
        }
    }

    private final class ClearExceptionsCommand
    implements Control.Command {
        private final JTextArea exceptionsTextArea;
        private final LoadTest.Scenario<?> scenario;

        private ClearExceptionsCommand(JTextArea exceptionsTextArea, LoadTest.Scenario<?> scenario) {
            this.exceptionsTextArea = exceptionsTextArea;
            this.scenario = scenario;
        }

        public void execute() {
            LoadTestPanel.this.loadTestModel.clearExceptions(this.scenario.name());
            this.exceptionsTextArea.replaceRange("", 0, this.exceptionsTextArea.getDocument().getLength());
        }
    }
}

