/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component.table;

import is.codion.common.event.EventObserver;
import is.codion.common.model.FilterModel;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.table.DefaultFilterTableModel;
import is.codion.swing.common.model.component.table.FilterTableSelectionModel;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.table.TableModel;

public interface FilterTableModel<R, C>
extends TableModel,
FilterModel<R> {
    public EventObserver<?> dataChangedEvent();

    public EventObserver<?> clearedEvent();

    public int indexOf(R var1);

    public R itemAt(int var1);

    public Columns<R, C> columns();

    public String getStringAt(int var1, C var2);

    public void addItems(Collection<R> var1);

    public void addItemsSorted(Collection<R> var1);

    public void addItemsAt(int var1, Collection<R> var2);

    public void addItemsAtSorted(int var1, Collection<R> var2);

    public void addItem(R var1);

    public void addItemAt(int var1, R var2);

    public void addItemSorted(R var1);

    public void setItemAt(int var1, R var2);

    public void removeItems(Collection<R> var1);

    public void removeItem(R var1);

    public R removeItemAt(int var1);

    public List<R> removeItems(int var1, int var2);

    public <T> Collection<T> values(C var1);

    public Class<?> getColumnClass(C var1);

    public <T> Collection<T> selectedValues(C var1);

    public Value<RefreshStrategy> refreshStrategy();

    public Value<Comparator<R>> comparator();

    public void sortItems();

    public FilterTableSelectionModel<R> selectionModel();

    public TableConditionModel<C> filterModel();

    public void refresh();

    public void refreshThen(Consumer<Collection<R>> var1);

    public void clear();

    public void fireTableDataChanged();

    public void fireTableRowsUpdated(int var1, int var2);

    public static <R, C> Builder<R, C> builder(Columns<R, C> columns) {
        return new DefaultFilterTableModel.DefaultBuilder<R, C>(columns);
    }

    public static interface Columns<R, C> {
        public List<C> identifiers();

        public Class<?> columnClass(C var1);

        public Object value(R var1, C var2);

        default public C identifier(int index) {
            return this.identifiers().get(index);
        }

        default public String string(R row, C identifier) {
            Object columnValue = this.value(row, identifier);
            return columnValue == null ? "" : columnValue.toString();
        }

        default public <T> Comparable<T> comparable(R row, C identifier) {
            Object value = this.value(row, identifier);
            if (value instanceof Comparable) {
                return (Comparable)value;
            }
            return null;
        }

        default public Comparator<?> comparator(C identifier) {
            if (Comparable.class.isAssignableFrom(this.columnClass(identifier))) {
                return DefaultFilterTableModel.COMPARABLE_COMPARATOR;
            }
            return DefaultFilterTableModel.STRING_COMPARATOR;
        }
    }

    public static interface Builder<R, C> {
        public Builder<R, C> filterModelFactory(ColumnConditionModel.Factory<C> var1);

        public Builder<R, C> items(Supplier<Collection<R>> var1);

        public Builder<R, C> validator(Predicate<R> var1);

        public Builder<R, C> refreshStrategy(RefreshStrategy var1);

        public Builder<R, C> asyncRefresh(boolean var1);

        public FilterTableModel<R, C> build();
    }

    public static enum RefreshStrategy {
        CLEAR,
        MERGE;

    }
}

