/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component.table;

import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.model.component.table.FilterTableSelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.DefaultListSelectionModel;

final class DefaultFilterTableSelectionModel<R>
extends DefaultListSelectionModel
implements FilterTableSelectionModel<R> {
    private final Event<?> selectionChangingEvent = Event.event();
    private final Event<?> selectionEvent = Event.event();
    private final Event<Integer> selectedIndexEvent = Event.event();
    private final Event<List<Integer>> selectedIndexesEvent = Event.event();
    private final Event<R> selectedItemEvent = Event.event();
    private final Event<List<R>> selectedItemsEvent = Event.event();
    private final State singleSelectionMode = State.state((boolean)false);
    private final State selectionEmpty = State.state((boolean)true);
    private final State singleSelection = State.state((boolean)false);
    private final StateObserver multipleSelection = State.and((StateObserver[])new StateObserver[]{this.selectionEmpty.not(), this.singleSelection.not()});
    private int selectedIndex = -1;
    private final FilterTableModel<R, ?> tableModel;

    DefaultFilterTableSelectionModel(FilterTableModel<R, ?> tableModel) {
        this.tableModel = Objects.requireNonNull(tableModel, "tableModel");
        this.bindEvents();
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        if (this.getSelectionMode() != selectionMode) {
            this.clearSelection();
            super.setSelectionMode(selectionMode);
            this.singleSelectionMode.set((Object)(selectionMode == 0 ? 1 : 0));
        }
    }

    public State singleSelectionMode() {
        return this.singleSelectionMode;
    }

    public void addSelectedIndex(int index) {
        DefaultFilterTableSelectionModel.checkIndex(index, this.tableModel.getRowCount());
        this.addSelectionInterval(index, index);
    }

    public void removeSelectedIndex(int index) {
        DefaultFilterTableSelectionModel.checkIndex(index, this.tableModel.getRowCount());
        this.removeSelectionInterval(index, index);
    }

    public void removeSelectedIndexes(Collection<Integer> indexes) {
        indexes.forEach(index -> {
            DefaultFilterTableSelectionModel.checkIndex(index, this.tableModel.getRowCount());
            this.removeSelectionInterval((int)index, (int)index);
        });
    }

    public void setSelectedIndex(int index) {
        DefaultFilterTableSelectionModel.checkIndex(index, this.tableModel.getRowCount());
        this.setSelectionInterval(index, index);
    }

    public int selectionCount() {
        if (this.isSelectionEmpty()) {
            return 0;
        }
        return (int)IntStream.rangeClosed(this.getMinSelectionIndex(), this.getMaxSelectionIndex()).filter(this::isSelectedIndex).count();
    }

    public void addSelectedIndexes(Collection<Integer> indexes) {
        if (Objects.requireNonNull(indexes).isEmpty()) {
            return;
        }
        this.checkIndexes(indexes);
        this.setValueIsAdjusting(true);
        for (Integer index : indexes) {
            this.addSelectionInterval(index, index);
        }
        this.setValueIsAdjusting(false);
    }

    public void setSelectedIndexes(Collection<Integer> indexes) {
        Objects.requireNonNull(indexes);
        this.checkIndexes(indexes);
        this.setValueIsAdjusting(true);
        this.clearSelection();
        this.addSelectedIndexes(indexes);
        this.setValueIsAdjusting(false);
    }

    public List<Integer> getSelectedIndexes() {
        if (this.isSelectionEmpty()) {
            return Collections.emptyList();
        }
        return IntStream.rangeClosed(this.getMinSelectionIndex(), this.getMaxSelectionIndex()).filter(this::isSelectedIndex).boxed().collect(Collectors.toList());
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void selectAll() {
        this.setSelectionInterval(0, this.tableModel.getRowCount() - 1);
    }

    public void setSelectedItems(Predicate<R> predicate) {
        this.setSelectedIndexes(this.indexesToSelect(Objects.requireNonNull(predicate)));
    }

    public void addSelectedItems(Predicate<R> predicate) {
        this.addSelectedIndexes(this.indexesToSelect(Objects.requireNonNull(predicate)));
    }

    public R getSelectedItem() {
        int index = this.getSelectedIndex();
        if (index >= 0 && index < this.tableModel.getRowCount()) {
            return this.tableModel.itemAt(index);
        }
        return null;
    }

    public Optional<R> selectedItem() {
        return Optional.ofNullable(this.getSelectedItem());
    }

    public boolean isSelected(R item) {
        Objects.requireNonNull(item);
        return this.isSelectedIndex(this.tableModel.indexOf(item));
    }

    public List<R> getSelectedItems() {
        return this.getSelectedIndexes().stream().mapToInt(Integer::intValue).mapToObj(this.tableModel::itemAt).collect(Collectors.toList());
    }

    public void setSelectedItem(R item) {
        this.setSelectedItems(Collections.singletonList(item));
    }

    public void setSelectedItems(Collection<R> items) {
        if (!this.isSelectionEmpty()) {
            this.clearSelection();
        }
        this.addSelectedItems(items);
    }

    public void addSelectedItem(R item) {
        this.addSelectedItems(Collections.singletonList(item));
    }

    public void addSelectedItems(Collection<R> items) {
        Objects.requireNonNull(items, "items");
        this.addSelectedIndexes(items.stream().mapToInt(this.tableModel::indexOf).filter(index -> index >= 0).boxed().collect(Collectors.toList()));
    }

    public void removeSelectedItem(R item) {
        this.removeSelectedItems(Collections.singletonList(Objects.requireNonNull(item)));
    }

    public void removeSelectedItems(Collection<R> items) {
        Objects.requireNonNull(items).forEach(item -> this.removeSelectedIndex(this.tableModel.indexOf(item)));
    }

    @Override
    public void addSelectionInterval(int fromIndex, int toIndex) {
        this.selectionChangingEvent.run();
        super.addSelectionInterval(fromIndex, toIndex);
    }

    @Override
    public void setSelectionInterval(int fromIndex, int toIndex) {
        this.selectionChangingEvent.run();
        super.setSelectionInterval(fromIndex, toIndex);
    }

    @Override
    public void removeSelectionInterval(int fromIndex, int toIndex) {
        this.selectionChangingEvent.run();
        super.removeSelectionInterval(fromIndex, toIndex);
    }

    @Override
    public void insertIndexInterval(int fromIndex, int length, boolean before) {
        this.selectionChangingEvent.run();
        super.insertIndexInterval(fromIndex, length, before);
    }

    @Override
    public void removeIndexInterval(int fromIndex, int toIndex) {
        this.selectionChangingEvent.run();
        super.removeIndexInterval(fromIndex, toIndex);
    }

    public void moveSelectionUp() {
        if (this.tableModel.getRowCount() > 0) {
            int lastIndex = this.tableModel.getRowCount() - 1;
            if (this.isSelectionEmpty()) {
                this.setSelectionInterval(lastIndex, lastIndex);
            } else {
                this.setSelectedIndexes(this.getSelectedIndexes().stream().map(index -> index == 0 ? lastIndex : index - 1).collect(Collectors.toList()));
            }
        }
    }

    public void moveSelectionDown() {
        if (this.tableModel.getRowCount() > 0) {
            if (this.isSelectionEmpty()) {
                this.setSelectionInterval(0, 0);
            } else {
                this.setSelectedIndexes(this.getSelectedIndexes().stream().map(index -> index == this.tableModel.getRowCount() - 1 ? 0 : index + 1).collect(Collectors.toList()));
            }
        }
    }

    @Override
    public void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        super.fireValueChanged(firstIndex, lastIndex, isAdjusting);
        if (!isAdjusting) {
            this.selectionEmpty.set((Object)this.isSelectionEmpty());
            this.singleSelection.set((Object)(this.selectionCount() == 1 ? 1 : 0));
            int minSelIndex = this.getMinSelectionIndex();
            if (this.selectedIndex != minSelIndex) {
                this.selectedIndex = minSelIndex;
                this.selectedIndexEvent.accept((Object)this.selectedIndex);
                this.selectedItemEvent.accept(this.getSelectedItem());
            }
            List<Integer> selectedIndexes = this.getSelectedIndexes();
            this.selectionEvent.run();
            this.selectedIndexesEvent.accept(selectedIndexes);
            this.selectedItemsEvent.accept(selectedIndexes.stream().mapToInt(modelIndex -> modelIndex).mapToObj(this.tableModel::itemAt).collect(Collectors.toList()));
        }
    }

    public EventObserver<?> selectionChangingEvent() {
        return this.selectionChangingEvent.observer();
    }

    public EventObserver<Integer> selectedIndexEvent() {
        return this.selectedIndexEvent.observer();
    }

    public EventObserver<List<Integer>> selectedIndexesEvent() {
        return this.selectedIndexesEvent.observer();
    }

    public EventObserver<?> selectionEvent() {
        return this.selectionEvent.observer();
    }

    public EventObserver<R> selectedItemEvent() {
        return this.selectedItemEvent.observer();
    }

    public EventObserver<List<R>> selectedItemsEvent() {
        return this.selectedItemsEvent.observer();
    }

    public StateObserver multipleSelection() {
        return this.multipleSelection;
    }

    public StateObserver singleSelection() {
        return this.singleSelection.observer();
    }

    public StateObserver selectionEmpty() {
        return this.selectionEmpty.observer();
    }

    public StateObserver selectionNotEmpty() {
        return this.selectionEmpty.not();
    }

    private void bindEvents() {
        this.singleSelectionMode.addConsumer(singleSelection -> this.setSelectionMode(singleSelection != false ? 0 : 2));
    }

    private List<Integer> indexesToSelect(Predicate<R> predicate) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        List visibleItems = this.tableModel.visibleItems();
        for (int i = 0; i < visibleItems.size(); ++i) {
            Object item = visibleItems.get(i);
            if (!predicate.test(item)) continue;
            indexes.add(i);
        }
        return indexes;
    }

    private void checkIndexes(Collection<Integer> indexes) {
        int size = this.tableModel.getRowCount();
        for (Integer index : indexes) {
            DefaultFilterTableSelectionModel.checkIndex(index, size);
        }
    }

    private static void checkIndex(int index, int size) {
        if (index < 0 || index > size - 1) {
            throw new IndexOutOfBoundsException("Index: " + index + ", size: " + size);
        }
    }
}

