/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component.combobox;

import is.codion.common.i18n.Messages;
import is.codion.common.item.Item;
import is.codion.swing.common.model.component.combobox.DefaultFilterComboBoxModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class ItemComboBoxModel<T>
extends DefaultFilterComboBoxModel<Item<T>> {
    private ItemComboBoxModel(List<Item<T>> items) {
        this.selectedItemTranslator().set((Object)new SelectedItemTranslator());
        this.setItems(items);
    }

    private ItemComboBoxModel(Comparator<Item<T>> comparator, Collection<Item<T>> items) {
        this.selectedItemTranslator().set((Object)new SelectedItemTranslator());
        this.comparator().set(comparator);
        this.setItems(items);
        if (this.containsItem(Item.item(null))) {
            this.setSelectedItem(null);
        }
    }

    public int indexOf(T value) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!Objects.equals(((Item)this.getElementAt(i)).get(), value)) continue;
            return i;
        }
        return -1;
    }

    public static <T> ItemComboBoxModel<T> itemComboBoxModel() {
        return new ItemComboBoxModel<T>(null, Collections.emptyList());
    }

    public static <T> ItemComboBoxModel<T> itemComboBoxModel(List<Item<T>> items) {
        return new ItemComboBoxModel<T>(null, items);
    }

    public static <T> ItemComboBoxModel<T> sortedItemComboBoxModel() {
        return ItemComboBoxModel.sortedItemComboBoxModel(Collections.emptyList());
    }

    public static <T> ItemComboBoxModel<T> sortedItemComboBoxModel(List<Item<T>> items) {
        return new ItemComboBoxModel<T>(items);
    }

    public static <T> ItemComboBoxModel<T> sortedItemComboBoxModel(Comparator<Item<T>> comparator) {
        return new ItemComboBoxModel<T>(Objects.requireNonNull(comparator), Collections.emptyList());
    }

    public static <T> ItemComboBoxModel<T> sortedItemComboBoxModel(List<Item<T>> items, Comparator<Item<T>> comparator) {
        Objects.requireNonNull(items);
        Objects.requireNonNull(comparator);
        return new ItemComboBoxModel<T>(comparator, items);
    }

    public static ItemComboBoxModel<Boolean> booleanItemComboBoxModel() {
        return ItemComboBoxModel.booleanItemComboBoxModel("-");
    }

    public static ItemComboBoxModel<Boolean> booleanItemComboBoxModel(String nullCaption) {
        return ItemComboBoxModel.booleanItemComboBoxModel(nullCaption, Messages.yes(), Messages.no());
    }

    public static ItemComboBoxModel<Boolean> booleanItemComboBoxModel(String nullCaption, String trueCaption, String falseCaption) {
        return new ItemComboBoxModel<Boolean>(null, Arrays.asList(Item.item(null, (String)nullCaption), Item.item((Object)true, (String)trueCaption), Item.item((Object)false, (String)falseCaption)));
    }

    private final class SelectedItemTranslator
    implements Function<Object, Item<T>> {
        private SelectedItemTranslator() {
        }

        @Override
        public Item<T> apply(Object item) {
            if (item instanceof Item) {
                return this.findItem((Object)((Item)item));
            }
            return this.findItem(item);
        }

        private Item<T> findItem(Item<T> item) {
            int index = ItemComboBoxModel.this.visibleItems().indexOf(item);
            if (index >= 0) {
                return (Item)ItemComboBoxModel.this.getElementAt(index);
            }
            return null;
        }

        private Item<T> findItem(T value) {
            int index = ItemComboBoxModel.this.indexOf(value);
            if (index >= 0) {
                return (Item)ItemComboBoxModel.this.getElementAt(index);
            }
            return null;
        }
    }
}

