/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component.table;

import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.model.FilterModel;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.AbstractFilterModelRefresher;
import is.codion.swing.common.model.component.table.DefaultFilterTableSelectionModel;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.model.component.table.FilterTableSelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

final class DefaultFilterTableModel<R, C>
extends AbstractTableModel
implements FilterTableModel<R, C> {
    static final Comparator<Comparable<Object>> COMPARABLE_COMPARATOR = Comparable::compareTo;
    static final Comparator<?> STRING_COMPARATOR = Comparator.comparing(Object::toString);
    private final Event<?> dataChangedEvent = Event.event();
    private final Event<?> clearedEvent = Event.event();
    private final FilterTableModel.Columns<R, C> columns;
    private final List<R> visibleItems = new ArrayList<R>();
    private final List<R> filteredItems = new ArrayList<R>();
    private final FilterTableSelectionModel<R> selectionModel;
    private final TableConditionModel<C> filterModel;
    private final CombinedIncludeCondition combinedIncludeCondition;
    private final Predicate<R> validator;
    private final DefaultRefresher refresher;
    private final RemoveSelectionListener removeSelectionListener;
    private final Value<Comparator<R>> comparator = Value.nullable().notify(Value.Notify.WHEN_SET).build();

    private DefaultFilterTableModel(DefaultBuilder<R, C> builder) {
        ColumnConditionModel.Factory factory;
        this.columns = Objects.requireNonNull(builder.columns);
        this.selectionModel = new DefaultFilterTableSelectionModel(this);
        if (builder.filterModelFactory == null) {
            ColumnConditionModel.Factory factory2;
            factory = factory2;
        } else {
            factory = builder.filterModelFactory;
        }
        this.filterModel = TableConditionModel.tableConditionModel(this.createColumnFilterModels(factory));
        this.combinedIncludeCondition = new CombinedIncludeCondition(this.filterModel.conditionModels().values());
        this.refresher = new DefaultRefresher(builder.items == null ? this::items : builder.items);
        this.refresher.async().set((Object)builder.asyncRefresh);
        this.refresher.refreshStrategy.set((Object)builder.refreshStrategy);
        this.validator = builder.validator;
        this.removeSelectionListener = new RemoveSelectionListener();
        this.bindEventsInternal();
    }

    public Collection<R> items() {
        ArrayList<R> items = new ArrayList<R>(this.visibleItems);
        items.addAll(this.filteredItems);
        return Collections.unmodifiableList(items);
    }

    public List<R> visibleItems() {
        return Collections.unmodifiableList(this.visibleItems);
    }

    public Collection<R> filteredItems() {
        return Collections.unmodifiableList(this.filteredItems);
    }

    public int visibleCount() {
        return this.getRowCount();
    }

    public int filteredCount() {
        return this.filteredItems.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.identifiers().size();
    }

    @Override
    public int getRowCount() {
        return this.visibleItems.size();
    }

    public boolean containsItem(R item) {
        return this.visible(item) || this.filtered(item);
    }

    public boolean visible(R item) {
        return this.visibleItems.contains(item);
    }

    public boolean filtered(R item) {
        return this.filteredItems.contains(item);
    }

    public FilterModel.Refresher<R> refresher() {
        return this.refresher;
    }

    @Override
    public void refresh() {
        this.refreshThen(null);
    }

    @Override
    public void refreshThen(Consumer<Collection<R>> afterRefresh) {
        this.refresher.refreshThen(afterRefresh);
    }

    @Override
    public void clear() {
        this.filteredItems.clear();
        int size = this.visibleItems.size();
        if (size > 0) {
            this.visibleItems.clear();
            this.fireTableRowsDeleted(0, size - 1);
        }
        this.clearedEvent.run();
    }

    @Override
    public FilterTableSelectionModel<R> selectionModel() {
        return this.selectionModel;
    }

    @Override
    public TableConditionModel<C> filterModel() {
        return this.filterModel;
    }

    @Override
    public <T> Collection<T> values(C columnIdentifier) {
        return this.columnValues(IntStream.range(0, this.visibleCount()).boxed(), this.columns.identifiers().indexOf(columnIdentifier));
    }

    @Override
    public <T> Collection<T> selectedValues(C columnIdentifier) {
        return this.columnValues(this.selectionModel().getSelectedIndexes().stream(), this.columns.identifiers().indexOf(columnIdentifier));
    }

    @Override
    public Value<FilterTableModel.RefreshStrategy> refreshStrategy() {
        return this.refresher.refreshStrategy;
    }

    @Override
    public R itemAt(int rowIndex) {
        return this.visibleItems.get(rowIndex);
    }

    @Override
    public int indexOf(R item) {
        return this.visibleItems.indexOf(item);
    }

    @Override
    public Value<Comparator<R>> comparator() {
        return this.comparator;
    }

    @Override
    public void sortItems() {
        if (this.comparator.isNotNull()) {
            List selectedItems = this.selectionModel.getSelectedItems();
            this.visibleItems.sort((Comparator)this.comparator.get());
            this.fireTableRowsUpdated(0, this.visibleItems.size());
            this.selectionModel.setSelectedItems(selectedItems);
        }
    }

    public void filterItems() {
        List selectedItems = this.selectionModel.getSelectedItems();
        this.visibleItems.addAll(this.filteredItems);
        this.filteredItems.clear();
        ListIterator<R> visibleItemsIterator = this.visibleItems.listIterator();
        while (visibleItemsIterator.hasNext()) {
            R item = visibleItemsIterator.next();
            if (this.include(item)) continue;
            visibleItemsIterator.remove();
            this.filteredItems.add(item);
        }
        if (this.comparator.isNotNull()) {
            this.visibleItems.sort((Comparator)this.comparator.get());
        }
        this.fireTableDataChanged();
        this.selectionModel.setSelectedItems(selectedItems);
    }

    public Value<Predicate<R>> includeCondition() {
        return this.combinedIncludeCondition.includeCondition;
    }

    @Override
    public void addItems(Collection<R> items) {
        this.addItemsAt(this.visibleItems.size(), items);
    }

    @Override
    public void addItemsSorted(Collection<R> items) {
        this.addItemsAtSorted(this.visibleItems.size(), items);
    }

    @Override
    public void addItemsAt(int index, Collection<R> items) {
        this.addItemsAtInternal(index, items);
    }

    @Override
    public void addItemsAtSorted(int index, Collection<R> items) {
        if (this.addItemsAtInternal(index, items) && this.comparator.isNotNull()) {
            this.visibleItems.sort((Comparator)this.comparator.get());
            this.fireTableDataChanged();
        }
    }

    @Override
    public void addItem(R item) {
        this.addItemInternal(item);
    }

    @Override
    public void addItemAt(int index, R item) {
        this.addItemAtInternal(index, item);
    }

    @Override
    public void addItemSorted(R item) {
        if (this.addItemInternal(item) && this.comparator.isNotNull()) {
            this.visibleItems.sort((Comparator)this.comparator.get());
            this.fireTableDataChanged();
        }
    }

    @Override
    public void setItemAt(int index, R item) {
        this.validate(item);
        if (this.include(item)) {
            this.visibleItems.set(index, item);
            this.fireTableRowsUpdated(index, index);
        }
    }

    @Override
    public void removeItem(R item) {
        this.removeItemInternal(item, true);
    }

    @Override
    public void removeItems(Collection<R> items) {
        this.selectionModel.setValueIsAdjusting(true);
        boolean visibleItemRemoved = false;
        for (R item : Objects.requireNonNull(items)) {
            visibleItemRemoved = this.removeItemInternal(item, false) || visibleItemRemoved;
        }
        this.selectionModel.setValueIsAdjusting(false);
        if (visibleItemRemoved) {
            this.dataChangedEvent.run();
        }
    }

    @Override
    public R removeItemAt(int index) {
        R removed = this.visibleItems.remove(index);
        this.fireTableRowsDeleted(index, index);
        this.dataChangedEvent.run();
        return removed;
    }

    @Override
    public List<R> removeItems(int fromIndex, int toIndex) {
        List<R> subList = this.visibleItems.subList(fromIndex, toIndex);
        ArrayList<R> removedItems = new ArrayList<R>(subList);
        subList.clear();
        this.fireTableRowsDeleted(fromIndex, toIndex);
        this.dataChangedEvent.run();
        return removedItems;
    }

    @Override
    public Class<?> getColumnClass(C columnIdentifier) {
        return this.columns.columnClass(Objects.requireNonNull(columnIdentifier));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columns.columnClass(this.columns.identifier(columnIndex));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.columns.value(this.itemAt(rowIndex), this.columns.identifier(columnIndex));
    }

    @Override
    public FilterTableModel.Columns<R, C> columns() {
        return this.columns;
    }

    @Override
    public String getStringAt(int rowIndex, C columnIdentifier) {
        return this.columns.string(this.itemAt(rowIndex), Objects.requireNonNull(columnIdentifier));
    }

    @Override
    public EventObserver<?> dataChangedEvent() {
        return this.dataChangedEvent.observer();
    }

    @Override
    public EventObserver<?> clearedEvent() {
        return this.clearedEvent.observer();
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        super.addTableModelListener(listener);
        if (listener instanceof JTable) {
            this.removeTableModelListener(this.removeSelectionListener);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        super.removeTableModelListener(listener);
        if (listener instanceof JTable) {
            this.addTableModelListener(this.removeSelectionListener);
        }
    }

    private void bindEventsInternal() {
        this.addTableModelListener(e -> {
            if (e.getType() != -1) {
                this.dataChangedEvent.run();
            }
        });
        this.addTableModelListener(this.removeSelectionListener);
        this.filterModel.conditionChangedEvent().addListener(this::filterItems);
        this.comparator.addListener(this::sortItems);
    }

    private List<Object> columnValues(Stream<Integer> rowIndexStream, int columnModelIndex) {
        return rowIndexStream.map(rowIndex -> this.getValueAt((int)rowIndex, columnModelIndex)).collect(Collectors.toList());
    }

    private boolean addItemInternal(R item) {
        return this.addItemAtInternal(this.getRowCount(), item);
    }

    private boolean addItemAtInternal(int index, R item) {
        this.validate(item);
        if (this.include(item)) {
            this.visibleItems.add(index, item);
            this.fireTableRowsInserted(index, index);
            return true;
        }
        this.filteredItems.add(item);
        return false;
    }

    private boolean addItemsAtInternal(int index, Collection<R> items) {
        Objects.requireNonNull(items);
        ArrayList<R> visible = new ArrayList<R>(items.size());
        ArrayList<R> filtered = new ArrayList<R>(items.size());
        for (R item : items) {
            this.validate(item);
            if (this.include(item)) {
                visible.add(item);
                continue;
            }
            filtered.add(item);
        }
        if (!visible.isEmpty()) {
            this.visibleItems.addAll(index, visible);
            this.fireTableRowsInserted(index, index + visible.size());
        }
        this.filteredItems.addAll(filtered);
        return !visible.isEmpty();
    }

    private boolean removeItemInternal(R item, boolean notifyDataChanged) {
        int visibleItemIndex = this.visibleItems.indexOf(item);
        if (visibleItemIndex >= 0) {
            this.visibleItems.remove(visibleItemIndex);
            this.fireTableRowsDeleted(visibleItemIndex, visibleItemIndex);
            if (notifyDataChanged) {
                this.dataChangedEvent.run();
            }
        } else {
            int filteredIndex = this.filteredItems.indexOf(item);
            if (filteredIndex >= 0) {
                this.filteredItems.remove(item);
            }
        }
        return visibleItemIndex >= 0;
    }

    private void validate(R item) {
        Objects.requireNonNull(item);
        if (!this.validator.test(item)) {
            throw new IllegalArgumentException("Invalid item: " + item);
        }
    }

    private boolean include(R item) {
        return this.combinedIncludeCondition.test(item);
    }

    private Collection<ColumnConditionModel<C, ?>> createColumnFilterModels(ColumnConditionModel.Factory<C> filterModelFactory) {
        return this.columns.identifiers().stream().map(arg_0 -> filterModelFactory.createConditionModel(arg_0)).filter(Optional::isPresent).map(Optional::get).map(model -> model).collect(Collectors.toList());
    }

    static final class DefaultBuilder<R, C>
    implements FilterTableModel.Builder<R, C> {
        private final FilterTableModel.Columns<R, C> columns;
        private Supplier<Collection<R>> items;
        private Predicate<R> validator = new ValidPredicate();
        private ColumnConditionModel.Factory<C> filterModelFactory;
        private FilterTableModel.RefreshStrategy refreshStrategy = FilterTableModel.RefreshStrategy.CLEAR;
        private boolean asyncRefresh = (Boolean)FilterModel.ASYNC_REFRESH.get();

        DefaultBuilder(FilterTableModel.Columns<R, C> columns) {
            if (Objects.requireNonNull(columns).identifiers().isEmpty()) {
                throw new IllegalArgumentException("No columns specified");
            }
            this.columns = Objects.requireNonNull(columns);
        }

        @Override
        public FilterTableModel.Builder<R, C> filterModelFactory(ColumnConditionModel.Factory<C> filterModelFactory) {
            this.filterModelFactory = Objects.requireNonNull(filterModelFactory);
            return this;
        }

        @Override
        public FilterTableModel.Builder<R, C> items(Supplier<Collection<R>> items) {
            this.items = Objects.requireNonNull(items);
            return this;
        }

        @Override
        public FilterTableModel.Builder<R, C> validator(Predicate<R> validator) {
            this.validator = Objects.requireNonNull(validator);
            return this;
        }

        @Override
        public FilterTableModel.Builder<R, C> refreshStrategy(FilterTableModel.RefreshStrategy refreshStrategy) {
            this.refreshStrategy = Objects.requireNonNull(refreshStrategy);
            return this;
        }

        @Override
        public FilterTableModel.Builder<R, C> asyncRefresh(boolean asyncRefresh) {
            this.asyncRefresh = asyncRefresh;
            return this;
        }

        @Override
        public FilterTableModel<R, C> build() {
            return new DefaultFilterTableModel(this);
        }

        private static final class ValidPredicate<R>
        implements Predicate<R> {
            private ValidPredicate() {
            }

            @Override
            public boolean test(R r) {
                return true;
            }
        }
    }

    private final class DefaultFilterModelFactory
    implements ColumnConditionModel.Factory<C> {
        private DefaultFilterModelFactory() {
        }

        public Optional<ColumnConditionModel<C, ?>> createConditionModel(C columnIdentifier) {
            Class<?> columnClass = DefaultFilterTableModel.this.getColumnClass(columnIdentifier);
            if (Comparable.class.isAssignableFrom(columnClass)) {
                return Optional.of(ColumnConditionModel.builder(columnIdentifier, columnClass).build());
            }
            return Optional.empty();
        }
    }

    private final class CombinedIncludeCondition
    implements Predicate<R> {
        private final List<ColumnConditionModel<C, ?>> columnFilters;
        private final Value<Predicate<R>> includeCondition = Value.value();

        private CombinedIncludeCondition(Collection<ColumnConditionModel<C, ?>> columnFilters) {
            this.columnFilters = columnFilters == null ? Collections.emptyList() : new ArrayList(columnFilters);
            this.includeCondition.addListener(DefaultFilterTableModel.this::filterItems);
        }

        @Override
        public boolean test(R item) {
            if (this.includeCondition.isNotNull() && !((Predicate)this.includeCondition.get()).test(item)) {
                return false;
            }
            return this.columnFilters.stream().filter(conditionModel -> (Boolean)conditionModel.enabled().get()).allMatch(conditionModel -> this.accepts(item, (ColumnConditionModel)conditionModel, DefaultFilterTableModel.this.columns));
        }

        private boolean accepts(R item, ColumnConditionModel<C, ?> conditionModel, FilterTableModel.Columns<R, C> columns) {
            if (conditionModel.columnClass().equals(String.class)) {
                String stringValue = columns.string(item, conditionModel.columnIdentifier());
                return conditionModel.accepts((Comparable)((Object)(stringValue.isEmpty() ? null : stringValue)));
            }
            return conditionModel.accepts(columns.comparable(item, conditionModel.columnIdentifier()));
        }
    }

    private final class DefaultRefresher
    extends AbstractFilterModelRefresher<R> {
        private final Value<FilterTableModel.RefreshStrategy> refreshStrategy;

        private DefaultRefresher(Supplier<Collection<R>> items) {
            super(items);
            this.refreshStrategy = Value.nonNull((Object)((Object)FilterTableModel.RefreshStrategy.CLEAR)).build();
        }

        protected void processResult(Collection<R> items) {
            if (this.refreshStrategy.isEqualTo((Object)FilterTableModel.RefreshStrategy.MERGE) && !items.isEmpty()) {
                this.merge((Object)items);
            } else {
                this.clearAndAdd(items);
            }
        }

        private void merge(Collection<R> items) {
            HashSet itemSet = new HashSet(items);
            DefaultFilterTableModel.this.items().stream().filter(item -> !itemSet.contains(item)).forEach(DefaultFilterTableModel.this::removeItem);
            items.forEach(this::merge);
        }

        private void merge(R item) {
            int index = DefaultFilterTableModel.this.indexOf(item);
            if (index == -1) {
                DefaultFilterTableModel.this.addItemInternal(item);
            } else {
                DefaultFilterTableModel.this.setItemAt(index, item);
            }
        }

        private void clearAndAdd(Collection<R> items) {
            List selectedItems = DefaultFilterTableModel.this.selectionModel.getSelectedItems();
            DefaultFilterTableModel.this.clear();
            DefaultFilterTableModel.this.addItemsSorted(items);
            DefaultFilterTableModel.this.selectionModel.setSelectedItems(selectedItems);
        }
    }

    private final class RemoveSelectionListener
    implements TableModelListener {
        private RemoveSelectionListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == -1) {
                DefaultFilterTableModel.this.selectionModel.removeIndexInterval(e.getFirstRow(), e.getLastRow());
            }
        }
    }
}

