/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component.combobox;

import is.codion.common.Text;
import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.model.FilterModel;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.AbstractFilterModelRefresher;
import is.codion.swing.common.model.component.combobox.FilterComboBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class DefaultFilterComboBoxModel<T>
implements FilterComboBoxModel<T> {
    private static final Predicate<?> DEFAULT_ITEM_VALIDATOR = new DefaultValidator();
    private static final Function<Object, ?> DEFAULT_SELECTED_ITEM_TRANSLATOR = new DefaultSelectedItemTranslator();
    private static final Predicate<?> DEFAULT_VALID_SELECTION_PREDICATE = new DefaultValidSelectionPredicate();
    private static final Comparator<?> DEFAULT_COMPARATOR = new DefaultComparator();
    private final Event<T> selectionEvent = Event.event();
    private final State selectionEmpty = State.state((boolean)true);
    private final State includeNull = State.state();
    private final Value<T> nullItem = Value.value();
    private final State filterSelectedItem = State.state((boolean)true);
    private final List<T> visibleItems = new ArrayList<T>();
    private final List<T> filteredItems = new ArrayList<T>();
    private final FilterModel.Refresher<T> refresher;
    private final Value<Predicate<T>> includeCondition = Value.value();
    private final Value<Predicate<T>> validator = Value.nonNull(DEFAULT_ITEM_VALIDATOR).build();
    private final Value<Function<Object, T>> selectedItemTranslator = Value.nonNull(DEFAULT_SELECTED_ITEM_TRANSLATOR).build();
    private final Value<Predicate<T>> validSelectionPredicate = Value.nonNull(DEFAULT_VALID_SELECTION_PREDICATE).build();
    private final Value<Comparator<T>> comparator = Value.nullable(DEFAULT_COMPARATOR).build();
    private boolean cleared = true;
    private T selectedItem = null;
    private final CopyOnWriteArrayList<ListDataListener> listDataListeners = new CopyOnWriteArrayList();

    protected DefaultFilterComboBoxModel() {
        this.refresher = new DefaultRefresher(new DefaultItems());
        this.includeCondition.addListener(this::filterItems);
        this.validator.addValidator(validator -> this.items().stream().filter(Objects::nonNull).forEach(validator::test));
        this.comparator.addListener(this::sortItems);
        this.validSelectionPredicate.addValidator(predicate -> {
            if (predicate != null && !predicate.test(this.selectedItem)) {
                throw new IllegalArgumentException("The current selected item does not satisfy the valid selection predicate");
            }
        });
        this.includeNull.addConsumer(value -> {
            if (value.booleanValue() && !this.visibleItems.contains(null)) {
                this.visibleItems.add(0, null);
            } else {
                this.visibleItems.remove(null);
            }
        });
        this.nullItem.addValidator(this::validate);
    }

    public final FilterModel.Refresher<T> refresher() {
        return this.refresher;
    }

    public final void refresh() {
        this.refreshThen(null);
    }

    public final void refreshThen(Consumer<Collection<T>> afterRefresh) {
        this.refresher.refreshThen(afterRefresh);
    }

    @Override
    public final void clear() {
        this.setSelectedItem(null);
        this.setItems(Collections.emptyList());
    }

    @Override
    public final boolean cleared() {
        return this.cleared;
    }

    @Override
    public final void setItems(Collection<T> items) {
        Objects.requireNonNull(items);
        this.filteredItems.clear();
        this.visibleItems.clear();
        if (((Boolean)this.includeNull.get()).booleanValue()) {
            this.visibleItems.add(0, null);
        }
        this.visibleItems.addAll(items.stream().map(this::validate).collect(Collectors.toList()));
        this.filterItems();
        this.cleared = items.isEmpty();
    }

    public final void filterItems() {
        this.visibleItems.addAll(this.filteredItems);
        this.filteredItems.clear();
        if (this.includeCondition.isNotNull()) {
            ListIterator<T> iterator = this.visibleItems.listIterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (item == null || ((Predicate)this.includeCondition.get()).test(item)) continue;
                this.filteredItems.add(item);
                iterator.remove();
            }
        }
        this.sortItems();
        if (this.selectedItem != null && this.visibleItems.contains(this.selectedItem)) {
            this.selectedItem = this.visibleItems.get(this.visibleItems.indexOf(this.selectedItem));
        }
        if (this.selectedItem != null && !this.visibleItems.contains(this.selectedItem) && ((Boolean)this.filterSelectedItem.get()).booleanValue()) {
            this.setSelectedItem(null);
        } else {
            this.fireContentsChanged();
        }
    }

    public final List<T> visibleItems() {
        if (this.visibleItems.isEmpty()) {
            return Collections.emptyList();
        }
        if (!((Boolean)this.includeNull.get()).booleanValue()) {
            return Collections.unmodifiableList(this.visibleItems);
        }
        return Collections.unmodifiableList(this.visibleItems.subList(1, this.getSize()));
    }

    public final Collection<T> filteredItems() {
        return Collections.unmodifiableList(this.filteredItems);
    }

    public final Collection<T> items() {
        ArrayList<T> entities = new ArrayList<T>(this.visibleItems());
        entities.addAll(this.filteredItems);
        return Collections.unmodifiableList(entities);
    }

    public final Value<Predicate<T>> includeCondition() {
        return this.includeCondition;
    }

    public final int filteredCount() {
        return this.filteredItems.size();
    }

    public final int visibleCount() {
        return this.visibleItems.size();
    }

    public final boolean visible(T item) {
        if (item == null) {
            return (Boolean)this.includeNull.get();
        }
        return this.visibleItems.contains(item);
    }

    public final boolean filtered(T item) {
        return this.filteredItems.contains(item);
    }

    @Override
    public final void add(T item) {
        this.validate(item);
        if (this.includeCondition.isNull() || ((Predicate)this.includeCondition.get()).test(item)) {
            if (!this.visibleItems.contains(item)) {
                this.visibleItems.add(item);
                this.sortItems();
            }
        } else if (!this.filteredItems.contains(item)) {
            this.filteredItems.add(item);
        }
    }

    @Override
    public final void remove(T item) {
        Objects.requireNonNull(item);
        this.filteredItems.remove(item);
        if (this.visibleItems.remove(item)) {
            this.fireContentsChanged();
        }
    }

    @Override
    public final void replace(T item, T replacement) {
        this.validate(replacement);
        this.remove(item);
        this.add(replacement);
        if (Objects.equals(this.selectedItem, item)) {
            this.selectedItem = ((Function)this.selectedItemTranslator.get()).apply(null);
            this.setSelectedItem(replacement);
        }
    }

    @Override
    public final void sortItems() {
        if (this.comparator.isNotNull() && !this.visibleItems.isEmpty()) {
            if (((Boolean)this.includeNull.get()).booleanValue()) {
                this.visibleItems.remove(0);
            }
            this.visibleItems.sort((Comparator)this.comparator.get());
            if (((Boolean)this.includeNull.get()).booleanValue()) {
                this.visibleItems.add(0, null);
            }
            this.fireContentsChanged();
        }
    }

    public final boolean containsItem(T item) {
        return this.visibleItems.contains(item) || this.filteredItems.contains(item);
    }

    @Override
    public final Value<Comparator<T>> comparator() {
        return this.comparator;
    }

    @Override
    public final Value<Predicate<T>> validator() {
        return this.validator;
    }

    @Override
    public final Value<Function<Object, T>> selectedItemTranslator() {
        return this.selectedItemTranslator;
    }

    @Override
    public final Value<Predicate<T>> validSelectionPredicate() {
        return this.validSelectionPredicate;
    }

    @Override
    public final State includeNull() {
        return this.includeNull;
    }

    @Override
    public final Value<T> nullItem() {
        return this.nullItem;
    }

    @Override
    public final boolean nullSelected() {
        return (Boolean)this.includeNull.get() != false && this.selectedItem == null;
    }

    @Override
    public final StateObserver selectionEmpty() {
        return this.selectionEmpty.observer();
    }

    @Override
    public final T selectedValue() {
        if (this.nullSelected()) {
            return null;
        }
        return this.selectedItem;
    }

    @Override
    public final T getSelectedItem() {
        if (this.selectedItem == null && this.nullItem.isNotNull()) {
            return (T)this.nullItem.get();
        }
        return this.selectedItem;
    }

    @Override
    public final void setSelectedItem(Object item) {
        Object toSelect = ((Function)this.selectedItemTranslator.get()).apply(Objects.equals(this.nullItem.get(), item) ? null : item);
        if (!Objects.equals(this.selectedItem, toSelect) && ((Predicate)this.validSelectionPredicate.get()).test(toSelect)) {
            this.selectedItem = toSelect;
            this.fireContentsChanged();
            this.selectionEmpty.set((Object)(this.selectedValue() == null ? 1 : 0));
            this.selectionEvent.accept(this.selectedItem);
        }
    }

    @Override
    public final State filterSelectedItem() {
        return this.filterSelectedItem;
    }

    @Override
    public final void addListDataListener(ListDataListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.listDataListeners.add(listener);
    }

    @Override
    public final void removeListDataListener(ListDataListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.listDataListeners.remove(listener);
    }

    @Override
    public final T getElementAt(int index) {
        T element = this.visibleItems.get(index);
        if (element == null) {
            return (T)this.nullItem.get();
        }
        return element;
    }

    @Override
    public final int getSize() {
        return this.visibleItems.size();
    }

    @Override
    public final <V> Value<V> createSelectorValue(FilterComboBoxModel.ItemFinder<T, V> itemFinder) {
        return new SelectorValue<V>(itemFinder);
    }

    @Override
    public final EventObserver<T> selectionEvent() {
        return this.selectionEvent.observer();
    }

    private void fireContentsChanged() {
        ListDataEvent event = new ListDataEvent(this, 0, 0, Integer.MAX_VALUE);
        for (ListDataListener dataListener : this.listDataListeners) {
            dataListener.contentsChanged(event);
        }
    }

    private T validate(T item) {
        if (!((Predicate)this.validator.get()).test(item)) {
            throw new IllegalArgumentException("Invalid item: " + item);
        }
        return item;
    }

    private final class DefaultRefresher
    extends AbstractFilterModelRefresher<T> {
        private DefaultRefresher(Supplier<Collection<T>> items) {
            super(items);
        }

        protected void processResult(Collection<T> items) {
            DefaultFilterComboBoxModel.this.setItems(items);
        }
    }

    private final class DefaultItems
    implements Supplier<Collection<T>> {
        private DefaultItems() {
        }

        @Override
        public Collection<T> get() {
            return DefaultFilterComboBoxModel.this.items();
        }
    }

    private final class SelectorValue<V>
    extends AbstractValue<V> {
        private final FilterComboBoxModel.ItemFinder<T, V> itemFinder;

        private SelectorValue(FilterComboBoxModel.ItemFinder<T, V> itemFinder) {
            this.itemFinder = Objects.requireNonNull(itemFinder);
            DefaultFilterComboBoxModel.this.selectionEvent.addListener(() -> this.notifyListeners());
        }

        public V get() {
            if (((Boolean)DefaultFilterComboBoxModel.this.selectionEmpty.get()).booleanValue()) {
                return null;
            }
            return this.itemFinder.value(DefaultFilterComboBoxModel.this.selectedValue());
        }

        protected void setValue(V value) {
            DefaultFilterComboBoxModel.this.setSelectedItem(value == null ? null : this.itemFinder.findItem(DefaultFilterComboBoxModel.this.visibleItems(), value));
        }
    }

    private static final class DefaultValidator<T>
    implements Predicate<T> {
        private DefaultValidator() {
        }

        @Override
        public boolean test(T item) {
            return true;
        }
    }

    private static final class DefaultSelectedItemTranslator<T>
    implements Function<Object, T> {
        private DefaultSelectedItemTranslator() {
        }

        @Override
        public T apply(Object item) {
            return (T)item;
        }
    }

    private static final class DefaultValidSelectionPredicate<T>
    implements Predicate<T> {
        private DefaultValidSelectionPredicate() {
        }

        @Override
        public boolean test(T item) {
            return true;
        }
    }

    private static final class DefaultComparator<T>
    implements Comparator<T> {
        private final Comparator<T> comparator = Text.collator();

        private DefaultComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return this.comparator.compare(o1, o2);
        }
    }
}

