/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component.table;

import is.codion.common.Text;
import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.model.FilteredModel;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.ColumnSummaryModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.model.table.TableSummaryModel;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.AbstractFilteredModelRefresher;
import is.codion.swing.common.model.component.table.DefaultFilteredTableColumnModel;
import is.codion.swing.common.model.component.table.DefaultFilteredTableSearchModel;
import is.codion.swing.common.model.component.table.DefaultFilteredTableSelectionModel;
import is.codion.swing.common.model.component.table.DefaultFilteredTableSortModel;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableColumnModel;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.model.component.table.FilteredTableSearchModel;
import is.codion.swing.common.model.component.table.FilteredTableSelectionModel;
import is.codion.swing.common.model.component.table.FilteredTableSortModel;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

final class DefaultFilteredTableModel<R, C>
extends AbstractTableModel
implements FilteredTableModel<R, C> {
    private final Event<?> dataChangedEvent = Event.event();
    private final Event<?> clearedEvent = Event.event();
    private final FilteredTableModel.ColumnValueProvider<R, C> columnValueProvider;
    private final List<R> visibleItems = new ArrayList<R>();
    private final List<R> filteredItems = new ArrayList<R>();
    private final FilteredTableSelectionModel<R> selectionModel;
    private final FilteredTableColumnModel<C> columnModel;
    private final FilteredTableSortModel<R, C> sortModel;
    private final FilteredTableSearchModel searchModel;
    private final TableConditionModel<C> filterModel;
    private final TableSummaryModel<C> summaryModel;
    private final CombinedIncludeCondition combinedIncludeCondition;
    private final Predicate<R> itemValidator;
    private final DefaultRefresher refresher;
    private final RemoveSelectionListener removeSelectionListener;

    private DefaultFilteredTableModel(DefaultBuilder<R, C> builder) {
        ColumnSummaryModel.SummaryValueProvider.Factory factory;
        ColumnConditionModel.Factory factory2;
        this.columnModel = new DefaultFilteredTableColumnModel(Objects.requireNonNull(builder.columnFactory).createColumns());
        this.searchModel = new DefaultFilteredTableSearchModel(this);
        this.columnValueProvider = Objects.requireNonNull(builder.columnValueProvider);
        this.sortModel = new DefaultFilteredTableSortModel<R, C>(this.columnModel, this.columnValueProvider);
        this.selectionModel = new DefaultFilteredTableSelectionModel(this);
        if (builder.filterModelFactory == null) {
            ColumnConditionModel.Factory factory3;
            factory2 = factory3;
        } else {
            factory2 = builder.filterModelFactory;
        }
        this.filterModel = TableConditionModel.tableConditionModel(this.createColumnFilterModels(factory2));
        if (builder.summaryValueProviderFactory == null) {
            ColumnSummaryModel.SummaryValueProvider.Factory factory4;
            factory = factory4;
            super();
        } else {
            factory = builder.summaryValueProviderFactory;
        }
        this.summaryModel = TableSummaryModel.tableSummaryModel(factory);
        this.combinedIncludeCondition = new CombinedIncludeCondition(this.filterModel.conditionModels().values());
        this.refresher = new DefaultRefresher(builder.itemSupplier == null ? this::items : builder.itemSupplier);
        this.refresher.async().set((Object)builder.asyncRefresh);
        this.refresher.mergeOnRefresh.set((Object)builder.mergeOnRefresh);
        this.itemValidator = builder.itemValidator;
        this.removeSelectionListener = new RemoveSelectionListener();
        this.bindEventsInternal();
    }

    public Collection<R> items() {
        ArrayList<R> items = new ArrayList<R>(this.visibleItems);
        items.addAll(this.filteredItems);
        return Collections.unmodifiableList(items);
    }

    public List<R> visibleItems() {
        return Collections.unmodifiableList(this.visibleItems);
    }

    public Collection<R> filteredItems() {
        return Collections.unmodifiableList(this.filteredItems);
    }

    public int visibleCount() {
        return this.getRowCount();
    }

    public int filteredCount() {
        return this.filteredItems.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.visibleItems.size();
    }

    public boolean containsItem(R item) {
        return this.visible(item) || this.filtered(item);
    }

    public boolean visible(R item) {
        return this.visibleItems.contains(item);
    }

    public boolean filtered(R item) {
        return this.filteredItems.contains(item);
    }

    public FilteredModel.Refresher<R> refresher() {
        return this.refresher;
    }

    @Override
    public void refresh() {
        this.refreshThen(null);
    }

    @Override
    public void refreshThen(Consumer<Collection<R>> afterRefresh) {
        this.refresher.refreshThen(afterRefresh);
    }

    @Override
    public void clear() {
        this.filteredItems.clear();
        int size = this.visibleItems.size();
        if (size > 0) {
            this.visibleItems.clear();
            this.fireTableRowsDeleted(0, size - 1);
        }
        this.clearedEvent.run();
    }

    @Override
    public FilteredTableColumnModel<C> columnModel() {
        return this.columnModel;
    }

    @Override
    public FilteredTableSelectionModel<R> selectionModel() {
        return this.selectionModel;
    }

    @Override
    public FilteredTableSortModel<R, C> sortModel() {
        return this.sortModel;
    }

    @Override
    public FilteredTableSearchModel searchModel() {
        return this.searchModel;
    }

    @Override
    public TableConditionModel<C> filterModel() {
        return this.filterModel;
    }

    @Override
    public TableSummaryModel<C> summaryModel() {
        return this.summaryModel;
    }

    @Override
    public <T> Collection<T> values(C columnIdentifier) {
        return this.columnValues(IntStream.range(0, this.visibleCount()).boxed(), this.columnModel.column(columnIdentifier).getModelIndex());
    }

    @Override
    public <T> Collection<T> selectedValues(C columnIdentifier) {
        return this.columnValues(this.selectionModel().getSelectedIndexes().stream(), this.columnModel.column(columnIdentifier).getModelIndex());
    }

    @Override
    public State mergeOnRefresh() {
        return this.refresher.mergeOnRefresh;
    }

    @Override
    public R itemAt(int rowIndex) {
        return this.visibleItems.get(rowIndex);
    }

    @Override
    public int indexOf(R item) {
        return this.visibleItems.indexOf(item);
    }

    @Override
    public void sortItems() {
        if (this.sortModel.sorted()) {
            List selectedItems = this.selectionModel.getSelectedItems();
            this.visibleItems.sort(this.sortModel.comparator());
            this.fireTableRowsUpdated(0, this.visibleItems.size());
            this.selectionModel.setSelectedItems(selectedItems);
        }
    }

    public void filterItems() {
        List selectedItems = this.selectionModel.getSelectedItems();
        this.visibleItems.addAll(this.filteredItems);
        this.filteredItems.clear();
        ListIterator<R> visibleItemsIterator = this.visibleItems.listIterator();
        while (visibleItemsIterator.hasNext()) {
            R item = visibleItemsIterator.next();
            if (this.include(item)) continue;
            visibleItemsIterator.remove();
            this.filteredItems.add(item);
        }
        this.visibleItems.sort(this.sortModel.comparator());
        this.fireTableDataChanged();
        this.selectionModel.setSelectedItems(selectedItems);
    }

    public Value<Predicate<R>> includeCondition() {
        return this.combinedIncludeCondition.includeCondition;
    }

    @Override
    public void addItems(Collection<R> items) {
        this.addItemsAt(this.visibleItems.size(), items);
    }

    @Override
    public void addItemsSorted(Collection<R> items) {
        this.addItemsAtSorted(this.visibleItems.size(), items);
    }

    @Override
    public void addItemsAt(int index, Collection<R> items) {
        this.addItemsAtInternal(index, items);
    }

    @Override
    public void addItemsAtSorted(int index, Collection<R> items) {
        if (this.addItemsAtInternal(index, items) && this.sortModel.sorted()) {
            this.visibleItems.sort(this.sortModel.comparator());
            this.fireTableDataChanged();
        }
    }

    @Override
    public void addItem(R item) {
        this.addItemInternal(item);
    }

    @Override
    public void addItemAt(int index, R item) {
        this.addItemAtInternal(index, item);
    }

    @Override
    public void addItemSorted(R item) {
        if (this.addItemInternal(item) && this.sortModel.sorted()) {
            this.visibleItems.sort(this.sortModel.comparator());
            this.fireTableDataChanged();
        }
    }

    @Override
    public void setItemAt(int index, R item) {
        this.validate(item);
        if (this.include(item)) {
            this.visibleItems.set(index, item);
            this.fireTableRowsUpdated(index, index);
        }
    }

    @Override
    public void removeItem(R item) {
        this.removeItemInternal(item, true);
    }

    @Override
    public void removeItems(Collection<R> items) {
        this.selectionModel.setValueIsAdjusting(true);
        boolean visibleItemRemoved = false;
        for (R item : Objects.requireNonNull(items)) {
            visibleItemRemoved = this.removeItemInternal(item, false) || visibleItemRemoved;
        }
        this.selectionModel.setValueIsAdjusting(false);
        if (visibleItemRemoved) {
            this.dataChangedEvent.run();
        }
    }

    @Override
    public R removeItemAt(int index) {
        R removed = this.visibleItems.remove(index);
        this.fireTableRowsDeleted(index, index);
        this.dataChangedEvent.run();
        return removed;
    }

    @Override
    public List<R> removeItems(int fromIndex, int toIndex) {
        List<R> subList = this.visibleItems.subList(fromIndex, toIndex);
        ArrayList<R> removedItems = new ArrayList<R>(subList);
        subList.clear();
        this.fireTableRowsDeleted(fromIndex, toIndex);
        this.dataChangedEvent.run();
        return removedItems;
    }

    @Override
    public Class<?> getColumnClass(C columnIdentifier) {
        return this.columnModel.column(columnIdentifier).columnClass();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getColumnClass(this.columnModel().columnIdentifier(columnIndex));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.columnValueProvider.value(this.itemAt(rowIndex), this.columnModel().columnIdentifier(columnIndex));
    }

    @Override
    public String getStringAt(int rowIndex, C columnIdentifier) {
        return this.columnValueProvider.string(this.itemAt(rowIndex), columnIdentifier);
    }

    @Override
    public String rowsAsDelimitedString(char delimiter) {
        List rows = this.selectionModel.isSelectionEmpty() ? IntStream.range(0, this.getRowCount()).boxed().collect(Collectors.toList()) : this.selectionModel.getSelectedIndexes();
        List<FilteredTableColumn<C>> visibleColumns = this.columnModel().visible();
        return Text.delimitedString(visibleColumns.stream().map(column -> String.valueOf(column.getHeaderValue())).collect(Collectors.toList()), rows.stream().map(row -> this.stringValues((int)row, visibleColumns)).collect(Collectors.toList()), (String)String.valueOf(delimiter));
    }

    @Override
    public EventObserver<?> dataChangedEvent() {
        return this.dataChangedEvent.observer();
    }

    @Override
    public EventObserver<?> clearedEvent() {
        return this.clearedEvent.observer();
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        super.addTableModelListener(listener);
        if (listener instanceof JTable) {
            this.removeTableModelListener(this.removeSelectionListener);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        super.removeTableModelListener(listener);
        if (listener instanceof JTable) {
            this.addTableModelListener(this.removeSelectionListener);
        }
    }

    private void bindEventsInternal() {
        this.addTableModelListener(e -> {
            if (e.getType() != -1) {
                this.dataChangedEvent.run();
            }
        });
        this.addTableModelListener(this.removeSelectionListener);
        this.filterModel.conditionChangedEvent().addListener(this::filterItems);
        this.sortModel.sortingChangedEvent().addListener(this::sortItems);
    }

    private List<Object> columnValues(Stream<Integer> rowIndexStream, int columnModelIndex) {
        return rowIndexStream.map(rowIndex -> this.getValueAt((int)rowIndex, columnModelIndex)).collect(Collectors.toList());
    }

    private List<String> stringValues(int row, List<FilteredTableColumn<C>> columns) {
        return columns.stream().map(column -> this.getStringAt(row, column.getIdentifier())).collect(Collectors.toList());
    }

    private boolean addItemInternal(R item) {
        return this.addItemAtInternal(this.getRowCount(), item);
    }

    private boolean addItemAtInternal(int index, R item) {
        this.validate(item);
        if (this.include(item)) {
            this.visibleItems.add(index, item);
            this.fireTableRowsInserted(index, index);
            return true;
        }
        this.filteredItems.add(item);
        return false;
    }

    private boolean addItemsAtInternal(int index, Collection<R> items) {
        Objects.requireNonNull(items);
        ArrayList<R> visible = new ArrayList<R>(items.size());
        ArrayList<R> filtered = new ArrayList<R>(items.size());
        for (R item : items) {
            this.validate(item);
            if (this.include(item)) {
                visible.add(item);
                continue;
            }
            filtered.add(item);
        }
        if (!visible.isEmpty()) {
            this.visibleItems.addAll(index, visible);
            this.fireTableRowsInserted(index, index + visible.size());
        }
        this.filteredItems.addAll(filtered);
        return !visible.isEmpty();
    }

    private boolean removeItemInternal(R item, boolean notifyDataChanged) {
        int visibleItemIndex = this.visibleItems.indexOf(item);
        if (visibleItemIndex >= 0) {
            this.visibleItems.remove(visibleItemIndex);
            this.fireTableRowsDeleted(visibleItemIndex, visibleItemIndex);
            if (notifyDataChanged) {
                this.dataChangedEvent.run();
            }
        } else {
            int filteredIndex = this.filteredItems.indexOf(item);
            if (filteredIndex >= 0) {
                this.filteredItems.remove(item);
            }
        }
        return visibleItemIndex >= 0;
    }

    private void validate(R item) {
        Objects.requireNonNull(item);
        if (!this.itemValidator.test(item)) {
            throw new IllegalArgumentException("Invalid item: " + item);
        }
    }

    private boolean include(R item) {
        return this.combinedIncludeCondition.test(item);
    }

    private Collection<ColumnConditionModel<C, ?>> createColumnFilterModels(ColumnConditionModel.Factory<C> filterModelFactory) {
        return this.columnModel.columns().stream().map(FilteredTableColumn::getIdentifier).map(arg_0 -> filterModelFactory.createConditionModel(arg_0)).filter(Optional::isPresent).map(Optional::get).map(conditionModel -> conditionModel).collect(Collectors.toList());
    }

    static final class DefaultBuilder<R, C>
    implements FilteredTableModel.Builder<R, C> {
        private final FilteredTableModel.ColumnFactory<C> columnFactory;
        private final FilteredTableModel.ColumnValueProvider<R, C> columnValueProvider;
        private Supplier<Collection<R>> itemSupplier;
        private Predicate<R> itemValidator = new ValidPredicate();
        private ColumnConditionModel.Factory<C> filterModelFactory;
        private ColumnSummaryModel.SummaryValueProvider.Factory<C> summaryValueProviderFactory;
        private boolean mergeOnRefresh = false;
        private boolean asyncRefresh = (Boolean)FilteredModel.ASYNC_REFRESH.get();

        DefaultBuilder(FilteredTableModel.ColumnFactory<C> columnFactory, FilteredTableModel.ColumnValueProvider<R, C> columnValueProvider) {
            this.columnFactory = Objects.requireNonNull(columnFactory);
            this.columnValueProvider = Objects.requireNonNull(columnValueProvider);
        }

        @Override
        public FilteredTableModel.Builder<R, C> filterModelFactory(ColumnConditionModel.Factory<C> filterModelFactory) {
            this.filterModelFactory = Objects.requireNonNull(filterModelFactory);
            return this;
        }

        @Override
        public FilteredTableModel.Builder<R, C> summaryValueProviderFactory(ColumnSummaryModel.SummaryValueProvider.Factory<C> summaryValueProviderFactory) {
            this.summaryValueProviderFactory = Objects.requireNonNull(summaryValueProviderFactory);
            return this;
        }

        @Override
        public FilteredTableModel.Builder<R, C> itemSupplier(Supplier<Collection<R>> itemSupplier) {
            this.itemSupplier = Objects.requireNonNull(itemSupplier);
            return this;
        }

        @Override
        public FilteredTableModel.Builder<R, C> itemValidator(Predicate<R> itemValidator) {
            this.itemValidator = Objects.requireNonNull(itemValidator);
            return this;
        }

        @Override
        public FilteredTableModel.Builder<R, C> mergeOnRefresh(boolean mergeOnRefresh) {
            this.mergeOnRefresh = mergeOnRefresh;
            return this;
        }

        @Override
        public FilteredTableModel.Builder<R, C> asyncRefresh(boolean asyncRefresh) {
            this.asyncRefresh = asyncRefresh;
            return this;
        }

        @Override
        public FilteredTableModel<R, C> build() {
            return new DefaultFilteredTableModel(this);
        }

        private static final class ValidPredicate<R>
        implements Predicate<R> {
            private ValidPredicate() {
            }

            @Override
            public boolean test(R r) {
                return true;
            }
        }
    }

    private final class DefaultFilterModelFactory
    implements ColumnConditionModel.Factory<C> {
        private DefaultFilterModelFactory() {
        }

        public Optional<ColumnConditionModel<? extends C, ?>> createConditionModel(C columnIdentifier) {
            Class<?> columnClass = DefaultFilteredTableModel.this.getColumnClass(columnIdentifier);
            if (Comparable.class.isAssignableFrom(columnClass)) {
                return Optional.of(ColumnConditionModel.builder(columnIdentifier, columnClass).build());
            }
            return Optional.empty();
        }
    }

    private final class DefaultSummaryValueProviderFactory
    implements ColumnSummaryModel.SummaryValueProvider.Factory<C> {
        private DefaultSummaryValueProviderFactory() {
        }

        public <T extends Number> Optional<ColumnSummaryModel.SummaryValueProvider<T>> createSummaryValueProvider(C columnIdentifier, Format format) {
            Class<?> columnClass = DefaultFilteredTableModel.this.getColumnClass(columnIdentifier);
            if (Number.class.isAssignableFrom(columnClass)) {
                return Optional.of(new DefaultSummaryValueProvider(columnIdentifier, DefaultFilteredTableModel.this, format));
            }
            return Optional.empty();
        }
    }

    private final class CombinedIncludeCondition
    implements Predicate<R> {
        private final List<? extends ColumnConditionModel<? extends C, ?>> columnFilters;
        private final Value<Predicate<R>> includeCondition = Value.value();

        private CombinedIncludeCondition(Collection<? extends ColumnConditionModel<? extends C, ?>> columnFilters) {
            this.columnFilters = columnFilters == null ? Collections.emptyList() : new ArrayList(columnFilters);
            this.includeCondition.addListener(DefaultFilteredTableModel.this::filterItems);
        }

        @Override
        public boolean test(R item) {
            if (this.includeCondition.isNotNull() && !((Predicate)this.includeCondition.get()).test(item)) {
                return false;
            }
            return this.columnFilters.stream().filter(conditionModel -> (Boolean)conditionModel.enabled().get()).allMatch(conditionModel -> this.accepts(item, (ColumnConditionModel)conditionModel, DefaultFilteredTableModel.this.columnValueProvider));
        }

        private boolean accepts(R item, ColumnConditionModel<? extends C, ?> conditionModel, FilteredTableModel.ColumnValueProvider<R, C> columnValueProvider) {
            if (conditionModel.columnClass().equals(String.class)) {
                String stringValue = columnValueProvider.string(item, conditionModel.columnIdentifier());
                return conditionModel.accepts((Comparable)((Object)(stringValue.isEmpty() ? null : stringValue)));
            }
            return conditionModel.accepts(columnValueProvider.comparable(item, conditionModel.columnIdentifier()));
        }
    }

    private final class DefaultRefresher
    extends AbstractFilteredModelRefresher<R> {
        private final State mergeOnRefresh;

        private DefaultRefresher(Supplier<Collection<R>> itemSupplier) {
            super(itemSupplier);
            this.mergeOnRefresh = State.state();
        }

        protected void processResult(Collection<R> items) {
            if (((Boolean)this.mergeOnRefresh.get()).booleanValue() && !items.isEmpty()) {
                this.merge((Object)items);
            } else {
                this.clearAndAdd(items);
            }
        }

        private void merge(Collection<R> items) {
            HashSet itemSet = new HashSet(items);
            DefaultFilteredTableModel.this.items().stream().filter(item -> !itemSet.contains(item)).forEach(DefaultFilteredTableModel.this::removeItem);
            items.forEach(this::merge);
        }

        private void merge(R item) {
            int index = DefaultFilteredTableModel.this.indexOf(item);
            if (index == -1) {
                DefaultFilteredTableModel.this.addItemInternal(item);
            } else {
                DefaultFilteredTableModel.this.setItemAt(index, item);
            }
        }

        private void clearAndAdd(Collection<R> items) {
            List selectedItems = DefaultFilteredTableModel.this.selectionModel.getSelectedItems();
            DefaultFilteredTableModel.this.clear();
            DefaultFilteredTableModel.this.addItemsSorted(items);
            DefaultFilteredTableModel.this.selectionModel.setSelectedItems(selectedItems);
        }
    }

    private final class RemoveSelectionListener
    implements TableModelListener {
        private RemoveSelectionListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == -1) {
                DefaultFilteredTableModel.this.selectionModel.removeIndexInterval(e.getFirstRow(), e.getLastRow());
            }
        }
    }

    static final class DefaultSummaryValueProvider<T extends Number, C>
    implements ColumnSummaryModel.SummaryValueProvider<T> {
        private final C columnIdentifier;
        private final FilteredTableModel<?, C> tableModel;
        private final Format format;
        private final Event<?> changeEvent = Event.event();

        DefaultSummaryValueProvider(C columnIdentifier, FilteredTableModel<?, C> tableModel, Format format) {
            this.columnIdentifier = Objects.requireNonNull(columnIdentifier);
            this.tableModel = Objects.requireNonNull(tableModel);
            this.format = Objects.requireNonNull(format);
            this.tableModel.dataChangedEvent().addListener(this.changeEvent);
            this.tableModel.selectionModel().selectionEvent().addListener(this.changeEvent);
        }

        public String format(Object value) {
            return this.format.format(value);
        }

        public EventObserver<?> changeEvent() {
            return this.changeEvent.observer();
        }

        public ColumnSummaryModel.SummaryValues<T> values() {
            FilteredTableSelectionModel<?> tableSelectionModel = this.tableModel.selectionModel();
            boolean subset = (Boolean)tableSelectionModel.selectionNotEmpty().get() != false && tableSelectionModel.selectionCount() != this.tableModel.visibleCount();
            return ColumnSummaryModel.summaryValues(subset ? this.tableModel.selectedValues(this.columnIdentifier) : this.tableModel.values(this.columnIdentifier), (boolean)subset);
        }
    }
}

