/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component.table;

import is.codion.common.event.EventObserver;
import is.codion.common.model.FilteredModel;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.ColumnSummaryModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.model.table.TableSummaryModel;
import is.codion.common.state.State;
import is.codion.swing.common.model.component.table.DefaultFilteredTableModel;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableColumnModel;
import is.codion.swing.common.model.component.table.FilteredTableSearchModel;
import is.codion.swing.common.model.component.table.FilteredTableSelectionModel;
import is.codion.swing.common.model.component.table.FilteredTableSortModel;
import java.text.Format;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.table.TableModel;

public interface FilteredTableModel<R, C>
extends TableModel,
FilteredModel<R> {
    public EventObserver<?> dataChangedEvent();

    public EventObserver<?> clearedEvent();

    public int indexOf(R var1);

    public R itemAt(int var1);

    public String getStringAt(int var1, C var2);

    public void addItems(Collection<R> var1);

    public void addItemsSorted(Collection<R> var1);

    public void addItemsAt(int var1, Collection<R> var2);

    public void addItemsAtSorted(int var1, Collection<R> var2);

    public void addItem(R var1);

    public void addItemAt(int var1, R var2);

    public void addItemSorted(R var1);

    public void setItemAt(int var1, R var2);

    public void removeItems(Collection<R> var1);

    public void removeItem(R var1);

    public R removeItemAt(int var1);

    public List<R> removeItems(int var1, int var2);

    public <T> Collection<T> values(C var1);

    public Class<?> getColumnClass(C var1);

    public <T> Collection<T> selectedValues(C var1);

    public String rowsAsDelimitedString(char var1);

    public State mergeOnRefresh();

    public void sortItems();

    public FilteredTableColumnModel<C> columnModel();

    public FilteredTableSelectionModel<R> selectionModel();

    public FilteredTableSortModel<R, C> sortModel();

    public FilteredTableSearchModel searchModel();

    public TableConditionModel<C> filterModel();

    public TableSummaryModel<C> summaryModel();

    public void refresh();

    public void refreshThen(Consumer<Collection<R>> var1);

    public void clear();

    public void fireTableDataChanged();

    public void fireTableRowsUpdated(int var1, int var2);

    public static <R, C> Builder<R, C> builder(ColumnFactory<C> columnFactory, ColumnValueProvider<R, C> columnValueProvider) {
        return new DefaultFilteredTableModel.DefaultBuilder<R, C>(columnFactory, columnValueProvider);
    }

    public static <T extends Number, C> ColumnSummaryModel.SummaryValueProvider<T> summaryValueProvider(C columnIdentifier, FilteredTableModel<?, C> tableModel, Format format) {
        return new DefaultFilteredTableModel.DefaultSummaryValueProvider(columnIdentifier, tableModel, format);
    }

    public static interface ColumnFactory<C> {
        public List<FilteredTableColumn<C>> createColumns();
    }

    public static interface ColumnValueProvider<R, C> {
        public Object value(R var1, C var2);

        default public String string(R row, C columnIdentifier) {
            Object columnValue = this.value(row, columnIdentifier);
            return columnValue == null ? "" : columnValue.toString();
        }

        default public <T> Comparable<T> comparable(R row, C columnIdentifier) {
            Object value = this.value(row, columnIdentifier);
            if (value instanceof Comparable) {
                return (Comparable)value;
            }
            return null;
        }
    }

    public static interface Builder<R, C> {
        public Builder<R, C> filterModelFactory(ColumnConditionModel.Factory<C> var1);

        public Builder<R, C> summaryValueProviderFactory(ColumnSummaryModel.SummaryValueProvider.Factory<C> var1);

        public Builder<R, C> itemSupplier(Supplier<Collection<R>> var1);

        public Builder<R, C> itemValidator(Predicate<R> var1);

        public Builder<R, C> mergeOnRefresh(boolean var1);

        public Builder<R, C> asyncRefresh(boolean var1);

        public FilteredTableModel<R, C> build();
    }
}

