/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component.table;

import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.state.State;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableColumnModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

final class DefaultFilteredTableColumnModel<C>
implements FilteredTableColumnModel<C> {
    private final DefaultTableColumnModel tableColumnModel = new DefaultTableColumnModel();
    private final Event<C> columnHiddenEvent = Event.event();
    private final Event<C> columnShownEvent = Event.event();
    private final Map<C, FilteredTableColumn<C>> columns = new LinkedHashMap<C, FilteredTableColumn<C>>();
    private final Map<Integer, C> columnIdentifiers = new HashMap<Integer, C>();
    private final Map<C, HiddenColumn> hiddenColumns = new LinkedHashMap<C, HiddenColumn>();
    private final Map<C, State> visibleStates = new HashMap<C, State>();
    private final State locked = State.state();

    DefaultFilteredTableColumnModel(List<FilteredTableColumn<C>> tableColumns) {
        if (Objects.requireNonNull(tableColumns, "columns").isEmpty()) {
            throw new IllegalArgumentException("One or more columns must be specified");
        }
        tableColumns.forEach(this::initializeColumn);
    }

    @Override
    public Collection<FilteredTableColumn<C>> columns() {
        return Collections.unmodifiableCollection(this.columns.values());
    }

    @Override
    public State locked() {
        return this.locked;
    }

    @Override
    public void setVisibleColumns(C ... columnIdentifiers) {
        this.setVisibleColumns(Arrays.asList(columnIdentifiers));
    }

    @Override
    public void setVisibleColumns(List<C> columnIdentifiers) {
        Objects.requireNonNull(columnIdentifiers);
        columnIdentifiers.forEach(this::validateColumn);
        int columnIndex = 0;
        for (C c : columnIdentifiers) {
            this.visibleStates.get(c).set((Object)true);
            this.moveColumn(this.getColumnIndex(c), columnIndex++);
        }
        for (FilteredTableColumn filteredTableColumn : this.columns()) {
            if (columnIdentifiers.contains(filteredTableColumn.getIdentifier())) continue;
            this.visibleStates.get(filteredTableColumn.getIdentifier()).set((Object)false);
        }
    }

    @Override
    public List<FilteredTableColumn<C>> visible() {
        ArrayList<FilteredTableColumn> tableColumns = new ArrayList<FilteredTableColumn>(this.tableColumnModel.getColumnCount());
        Enumeration<TableColumn> columnEnumeration = this.tableColumnModel.getColumns();
        while (columnEnumeration.hasMoreElements()) {
            tableColumns.add((FilteredTableColumn)columnEnumeration.nextElement());
        }
        return Collections.unmodifiableList(tableColumns);
    }

    @Override
    public Collection<FilteredTableColumn<C>> hidden() {
        return Collections.unmodifiableCollection(this.hiddenColumns.values().stream().map(hiddenColumn -> hiddenColumn.column).collect(Collectors.toList()));
    }

    @Override
    public FilteredTableColumn<C> column(C columnIdentifier) {
        FilteredTableColumn<C> column = this.columns.get(Objects.requireNonNull(columnIdentifier));
        if (column != null) {
            return column;
        }
        throw new IllegalArgumentException("Column not found: " + columnIdentifier);
    }

    @Override
    public boolean containsColumn(C columnIdentifier) {
        return this.columns.containsKey(Objects.requireNonNull(columnIdentifier));
    }

    @Override
    public State visible(C columnIdentifier) {
        return this.validateColumn(Objects.requireNonNull(columnIdentifier));
    }

    @Override
    public C columnIdentifier(int columnModelIndex) {
        C identifier = this.columnIdentifiers.get(columnModelIndex);
        if (identifier != null) {
            return identifier;
        }
        throw new IllegalArgumentException("Column at model index not found: " + columnModelIndex);
    }

    @Override
    public void resetColumns() {
        this.setVisibleColumns((List<C>)new ArrayList<C>(this.columns.keySet()));
    }

    @Override
    public void addColumn(TableColumn column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeColumn(TableColumn column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveColumn(int fromIndex, int toIndex) {
        this.tableColumnModel.moveColumn(fromIndex, toIndex);
    }

    @Override
    public void setColumnMargin(int columnMargin) {
        this.tableColumnModel.setColumnMargin(columnMargin);
    }

    @Override
    public int getColumnCount() {
        return this.tableColumnModel.getColumnCount();
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return this.tableColumnModel.getColumns();
    }

    @Override
    public int getColumnIndex(Object columnIdentifier) {
        return this.tableColumnModel.getColumnIndex(columnIdentifier);
    }

    @Override
    public FilteredTableColumn<C> getColumn(int columnIndex) {
        return (FilteredTableColumn)this.tableColumnModel.getColumn(columnIndex);
    }

    @Override
    public int getColumnMargin() {
        return this.tableColumnModel.getColumnMargin();
    }

    @Override
    public int getColumnIndexAtX(int xPosition) {
        return this.tableColumnModel.getColumnIndexAtX(xPosition);
    }

    @Override
    public int getTotalColumnWidth() {
        return this.tableColumnModel.getTotalColumnWidth();
    }

    @Override
    public void setColumnSelectionAllowed(boolean columnSelectionAllowed) {
        this.tableColumnModel.setColumnSelectionAllowed(columnSelectionAllowed);
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this.tableColumnModel.getColumnSelectionAllowed();
    }

    @Override
    public int[] getSelectedColumns() {
        return this.tableColumnModel.getSelectedColumns();
    }

    @Override
    public int getSelectedColumnCount() {
        return this.tableColumnModel.getSelectedColumnCount();
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        this.tableColumnModel.setSelectionModel(listSelectionModel);
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.tableColumnModel.getSelectionModel();
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener listener) {
        this.tableColumnModel.addColumnModelListener(listener);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener listener) {
        this.tableColumnModel.removeColumnModelListener(listener);
    }

    @Override
    public EventObserver<C> columnHiddenEvent() {
        return this.columnHiddenEvent.observer();
    }

    @Override
    public EventObserver<C> columnShownEvent() {
        return this.columnShownEvent.observer();
    }

    private void initializeColumn(FilteredTableColumn<C> column) {
        C identifier = column.getIdentifier();
        this.columns.put(identifier, column);
        this.columnIdentifiers.put(column.getModelIndex(), identifier);
        this.tableColumnModel.addColumn(column);
        this.visibleStates.put(identifier, this.createVisibleState(identifier));
    }

    private State createVisibleState(C identifier) {
        State visibleState = State.state((boolean)true);
        visibleState.addValidator(value -> this.checkIfLocked());
        visibleState.addConsumer(visible -> this.setColumnVisibleInternal(identifier, (boolean)visible));
        return visibleState;
    }

    private State validateColumn(C columnIdentifier) {
        State visibleState = this.visibleStates.get(columnIdentifier);
        if (visibleState == null) {
            throw new IllegalArgumentException("Column not found: " + columnIdentifier);
        }
        return visibleState;
    }

    private void setColumnVisibleInternal(C identifier, boolean visible) {
        if (visible) {
            this.showColumn(identifier);
        } else {
            this.hideColumn(identifier);
        }
    }

    private void showColumn(C columnIdentifier) {
        HiddenColumn column = this.hiddenColumns.get(columnIdentifier);
        if (column != null) {
            this.hiddenColumns.remove(columnIdentifier);
            this.tableColumnModel.addColumn(column.column);
            this.tableColumnModel.moveColumn(this.getColumnCount() - 1, column.indexWhenShown());
            this.columnShownEvent.accept(columnIdentifier);
        }
    }

    private void hideColumn(C columnIdentifier) {
        if (!this.hiddenColumns.containsKey(columnIdentifier)) {
            HiddenColumn hiddenColumn = new HiddenColumn(this.column(columnIdentifier));
            this.hiddenColumns.put(columnIdentifier, hiddenColumn);
            this.tableColumnModel.removeColumn(hiddenColumn.column);
            this.columnHiddenEvent.accept(columnIdentifier);
        }
    }

    private void checkIfLocked() {
        if (((Boolean)this.locked.get()).booleanValue()) {
            throw new IllegalStateException("Column model is locked");
        }
    }

    private final class HiddenColumn {
        private final FilteredTableColumn<C> column;
        private final Set<FilteredTableColumn<C>> columnsToTheRight;

        private HiddenColumn(FilteredTableColumn<C> column) {
            this.column = column;
            this.columnsToTheRight = this.columnsToTheRightOf(column);
        }

        private Set<FilteredTableColumn<C>> columnsToTheRightOf(FilteredTableColumn<C> column) {
            return IntStream.range(DefaultFilteredTableColumnModel.this.tableColumnModel.getColumnIndex(column.getIdentifier()) + 1, DefaultFilteredTableColumnModel.this.tableColumnModel.getColumnCount()).mapToObj(columnIndex -> (FilteredTableColumn)DefaultFilteredTableColumnModel.this.tableColumnModel.getColumn(columnIndex)).collect(Collectors.toSet());
        }

        private int indexWhenShown() {
            for (int i = 0; i < DefaultFilteredTableColumnModel.this.tableColumnModel.getColumnCount(); ++i) {
                if (!this.columnsToTheRight.contains(DefaultFilteredTableColumnModel.this.tableColumnModel.getColumn(i))) continue;
                return i;
            }
            return DefaultFilteredTableColumnModel.this.tableColumnModel.getColumnCount() - 1;
        }
    }
}

