/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.worker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public final class ProgressWorker<T, V>
extends SwingWorker<T, V> {
    private static final String STATE_PROPERTY = "state";
    private final ProgressTask<T, V> task;
    private final int maximumProgress;
    private final Runnable onStarted;
    private final Runnable onDone;
    private final Consumer<T> onResult;
    private final Consumer<Integer> onProgress;
    private final Consumer<List<V>> onPublish;
    private final Consumer<Exception> onException;
    private final Runnable onCancelled;
    private final Runnable onInterrupted;
    private boolean onDoneRun = false;

    private ProgressWorker(DefaultBuilder<T, V> builder) {
        this.task = builder.task;
        this.maximumProgress = builder.maximumProgress;
        this.onStarted = builder.onStarted;
        this.onDone = builder.onDone;
        this.onResult = builder.onResult;
        this.onProgress = builder.onProgress;
        this.onPublish = builder.onPublish;
        this.onException = builder.onException;
        this.onCancelled = builder.onCancelled;
        this.onInterrupted = builder.onInterrupted;
        this.getPropertyChangeSupport().addPropertyChangeListener(STATE_PROPERTY, new StateListener());
    }

    public static <T> Builder<T, ?> builder(Task<T> task) {
        Objects.requireNonNull(task);
        return ProgressWorker.builder((ProgressReporter<V> progressReporter) -> task.execute());
    }

    public static <T, V> Builder<T, V> builder(ProgressTask<T, V> task) {
        return new DefaultBuilder<T, V>(task);
    }

    @Override
    protected T doInBackground() throws Exception {
        return this.task.execute(new TaskProgressReporter());
    }

    @Override
    protected void done() {
        this.runOnDone();
        try {
            this.onResult.accept(this.get());
        }
        catch (CancellationException e) {
            this.onCancelled.run();
        }
        catch (InterruptedException e) {
            this.onInterrupted.run();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                this.onException.accept((Exception)cause);
            }
            this.onException.accept(new RuntimeException(cause));
        }
    }

    private void runOnDone() {
        if (!this.onDoneRun) {
            this.onDone.run();
            this.onDoneRun = true;
        }
    }

    private static final class DefaultBuilder<T, V>
    implements Builder<T, V> {
        private static final Runnable EMPTY_RUNNABLE = new EmptyRunnable();
        private static final Consumer<?> EMPTY_CONSUMER = new EmptyConsumer();
        private static final Consumer<Exception> RETHROW_HANDLER = new RethrowHandler();
        private static final Runnable INTERRUPT_CURRENT_ON_INTERRUPTED = new InterruptCurrentOnInterrupted();
        private final ProgressTask<T, V> task;
        private int maximumProgress = 100;
        private Runnable onStarted = EMPTY_RUNNABLE;
        private Runnable onDone = EMPTY_RUNNABLE;
        private Consumer<T> onResult = EMPTY_CONSUMER;
        private Consumer<Integer> onProgress = EMPTY_CONSUMER;
        private Consumer<List<V>> onPublish = EMPTY_CONSUMER;
        private Consumer<Exception> onException = RETHROW_HANDLER;
        private Runnable onCancelled = EMPTY_RUNNABLE;
        private Runnable onInterrupted = INTERRUPT_CURRENT_ON_INTERRUPTED;

        private DefaultBuilder(ProgressTask<T, V> task) {
            this.task = Objects.requireNonNull(task);
        }

        @Override
        public Builder<T, V> maximumProgress(int maximumProgress) {
            if (maximumProgress < 0) {
                throw new IllegalArgumentException("Maximum progress must be a positive integer");
            }
            this.maximumProgress = maximumProgress;
            return this;
        }

        @Override
        public Builder<T, V> onStarted(Runnable onStarted) {
            this.onStarted = Objects.requireNonNull(onStarted);
            return this;
        }

        @Override
        public Builder<T, V> onDone(Runnable onDone) {
            this.onDone = Objects.requireNonNull(onDone);
            return this;
        }

        @Override
        public Builder<T, V> onResult(Consumer<T> onResult) {
            this.onResult = Objects.requireNonNull(onResult);
            return this;
        }

        @Override
        public Builder<T, V> onProgress(Consumer<Integer> onProgress) {
            this.onProgress = Objects.requireNonNull(onProgress);
            return this;
        }

        @Override
        public Builder<T, V> onPublish(Consumer<List<V>> onPublish) {
            this.onPublish = Objects.requireNonNull(onPublish);
            return this;
        }

        @Override
        public Builder<T, V> onException(Consumer<Exception> onException) {
            this.onException = Objects.requireNonNull(onException);
            return this;
        }

        @Override
        public Builder<T, V> onCancelled(Runnable onCancelled) {
            this.onCancelled = Objects.requireNonNull(onCancelled);
            return this;
        }

        @Override
        public Builder<T, V> onInterrupted(Runnable onInterrupted) {
            this.onInterrupted = Objects.requireNonNull(onInterrupted);
            return this;
        }

        @Override
        public ProgressWorker<T, V> execute() {
            ProgressWorker<T, V> worker = this.build();
            worker.execute();
            return worker;
        }

        @Override
        public ProgressWorker<T, V> build() {
            return new ProgressWorker(this);
        }
    }

    public static interface ProgressTask<T, V> {
        public T execute(ProgressReporter<V> var1) throws Exception;
    }

    private final class StateListener
    implements PropertyChangeListener {
        private StateListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            if (changeEvent.getNewValue() == SwingWorker.StateValue.STARTED) {
                if (ProgressWorker.this.isDone()) {
                    ProgressWorker.this.runOnDone();
                } else {
                    ProgressWorker.this.onStarted.run();
                }
            }
        }
    }

    public static interface Task<T> {
        public T execute() throws Exception;
    }

    public static interface Builder<T, V> {
        public Builder<T, V> maximumProgress(int var1);

        public Builder<T, V> onStarted(Runnable var1);

        public Builder<T, V> onDone(Runnable var1);

        public Builder<T, V> onResult(Consumer<T> var1);

        public Builder<T, V> onProgress(Consumer<Integer> var1);

        public Builder<T, V> onPublish(Consumer<List<V>> var1);

        public Builder<T, V> onException(Consumer<Exception> var1);

        public Builder<T, V> onCancelled(Runnable var1);

        public Builder<T, V> onInterrupted(Runnable var1);

        public ProgressWorker<T, V> execute();

        public ProgressWorker<T, V> build();
    }

    private final class TaskProgressReporter
    implements ProgressReporter<V> {
        private TaskProgressReporter() {
        }

        @Override
        public void report(int progress) {
            ProgressWorker.this.setProgress(ProgressWorker.this.maximumProgress == 0 ? 100 : 100 * progress / ProgressWorker.this.maximumProgress);
            if (ProgressWorker.this.onProgress != DefaultBuilder.EMPTY_CONSUMER) {
                SwingUtilities.invokeLater(() -> ProgressWorker.this.onProgress.accept(progress));
            }
        }

        @Override
        public void publish(V ... chunks) {
            ProgressWorker.this.publish(chunks);
            if (ProgressWorker.this.onPublish != DefaultBuilder.EMPTY_CONSUMER) {
                SwingUtilities.invokeLater(() -> ProgressWorker.this.onPublish.accept(Arrays.asList(chunks)));
            }
        }
    }

    public static interface ProgressReporter<V> {
        public void report(int var1);

        public void publish(V ... var1);
    }

    private static final class InterruptCurrentOnInterrupted
    implements Runnable {
        private InterruptCurrentOnInterrupted() {
        }

        @Override
        public void run() {
            Thread.currentThread().interrupt();
        }
    }

    private static final class RethrowHandler
    implements Consumer<Exception> {
        private RethrowHandler() {
        }

        @Override
        public void accept(Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    private static final class EmptyConsumer<T>
    implements Consumer<T> {
        private EmptyConsumer() {
        }

        @Override
        public void accept(T result) {
        }
    }

    private static final class EmptyRunnable
    implements Runnable {
        private EmptyRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

