/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component;

import is.codion.common.model.FilteredModel;
import is.codion.swing.common.model.worker.ProgressWorker;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;

public abstract class AbstractFilteredModelRefresher<T>
extends FilteredModel.AbstractRefresher<T> {
    private ProgressWorker<Collection<T>, ?> refreshWorker;

    protected AbstractFilteredModelRefresher(Supplier<Collection<T>> itemSupplier) {
        super(itemSupplier);
    }

    protected final boolean supportsAsyncRefresh() {
        return SwingUtilities.isEventDispatchThread();
    }

    protected final void refreshAsync(Consumer<Collection<T>> afterRefresh) {
        this.cancelCurrentRefresh();
        this.refreshWorker = ProgressWorker.builder(((Supplier)((Supplier)this.itemSupplier().get()))::get).onStarted(this::onRefreshStarted).onResult(items -> this.onRefreshResult((Collection<T>)items, afterRefresh)).onException(this::onRefreshFailedAsync).execute();
    }

    protected final void refreshSync(Consumer<Collection<T>> afterRefresh) {
        this.onRefreshStarted();
        try {
            this.onRefreshResult((Collection)((Supplier)this.itemSupplier().get()).get(), afterRefresh);
        }
        catch (Exception e) {
            this.onRefreshFailedSync(e);
        }
    }

    private void onRefreshStarted() {
        this.setRefreshing(true);
    }

    private void onRefreshFailedAsync(Exception exception) {
        this.refreshWorker = null;
        this.setRefreshing(false);
        this.notifyFailure(exception);
    }

    private void onRefreshFailedSync(Exception exception) {
        this.setRefreshing(false);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    private void onRefreshResult(Collection<T> items, Consumer<Collection<T>> afterRefresh) {
        this.refreshWorker = null;
        this.setRefreshing(false);
        this.processResult(items);
        if (afterRefresh != null) {
            afterRefresh.accept(items);
        }
        this.notifySuccess();
    }

    private void cancelCurrentRefresh() {
        ProgressWorker<Collection<T>, ?> worker = this.refreshWorker;
        if (worker != null) {
            worker.cancel(true);
        }
    }
}

