/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component.table;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.SortOrder;

public interface FilteredTableSortModel<R, C> {
    public Comparator<R> comparator();

    public void setSortOrder(C var1, SortOrder var2);

    public void addSortOrder(C var1, SortOrder var2);

    public SortOrder sortOrder(C var1);

    public int sortPriority(C var1);

    public boolean sorted();

    public List<ColumnSortOrder<C>> columnSortOrder();

    public void clear();

    public void setSortingEnabled(C var1, boolean var2);

    public boolean isSortingEnabled(C var1);

    public void addSortingChangedListener(Consumer<C> var1);

    public void removeSortingChangedListener(Consumer<C> var1);

    public static SortOrder nextSortOrder(SortOrder currentSortOrder) {
        Objects.requireNonNull(currentSortOrder);
        switch (currentSortOrder) {
            case UNSORTED: {
                return SortOrder.ASCENDING;
            }
            case ASCENDING: {
                return SortOrder.DESCENDING;
            }
            case DESCENDING: {
                return SortOrder.UNSORTED;
            }
        }
        throw new IllegalStateException("Unknown sort order: " + currentSortOrder);
    }

    public static interface ColumnSortOrder<C> {
        public C columnIdentifier();

        public SortOrder sortOrder();
    }
}

