/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component.table;

import is.codion.common.event.Event;
import is.codion.swing.common.model.component.table.FilteredTableColumnModel;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.model.component.table.FilteredTableSortModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.SortOrder;

final class DefaultFilteredTableSortModel<R, C>
implements FilteredTableSortModel<R, C> {
    private final FilteredTableColumnModel<C> columnModel;
    private final FilteredTableModel.ColumnValueProvider<R, C> columnValueProvider;
    private final Map<C, Comparator<?>> columnComparators = new HashMap();
    private final Event<C> sortingChangedEvent = Event.event();
    private final List<FilteredTableSortModel.ColumnSortOrder<C>> columnSortOrders = new ArrayList<FilteredTableSortModel.ColumnSortOrder<C>>(0);
    private final Set<C> columnSortingDisabled = new HashSet<C>();
    private final RowComparator comparator = new RowComparator();

    DefaultFilteredTableSortModel(FilteredTableColumnModel<C> columnModel, FilteredTableModel.ColumnValueProvider<R, C> columnValueProvider) {
        this.columnModel = Objects.requireNonNull(columnModel);
        this.columnValueProvider = Objects.requireNonNull(columnValueProvider);
    }

    @Override
    public Comparator<R> comparator() {
        return this.comparator;
    }

    @Override
    public SortOrder sortOrder(C columnIdentifier) {
        Objects.requireNonNull(columnIdentifier);
        return this.columnSortOrders.stream().filter(columnSortOrder -> columnSortOrder.columnIdentifier().equals(columnIdentifier)).findFirst().map(FilteredTableSortModel.ColumnSortOrder::sortOrder).orElse(SortOrder.UNSORTED);
    }

    @Override
    public int sortPriority(C columnIdentifier) {
        Objects.requireNonNull(columnIdentifier);
        for (int i = 0; i < this.columnSortOrders.size(); ++i) {
            if (!this.columnSortOrders.get(i).columnIdentifier().equals(columnIdentifier)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setSortOrder(C columnIdentifier, SortOrder sortOrder) {
        this.setSortOrder(columnIdentifier, sortOrder, false);
    }

    @Override
    public void addSortOrder(C columnIdentifier, SortOrder sortOrder) {
        this.setSortOrder(columnIdentifier, sortOrder, true);
    }

    @Override
    public boolean sorted() {
        return !this.columnSortOrders.isEmpty();
    }

    @Override
    public List<FilteredTableSortModel.ColumnSortOrder<C>> columnSortOrder() {
        return Collections.unmodifiableList(this.columnSortOrders);
    }

    @Override
    public void clear() {
        if (!this.columnSortOrders.isEmpty()) {
            C firstSortColumn = this.columnSortOrders.get(0).columnIdentifier();
            this.columnSortOrders.clear();
            this.sortingChangedEvent.accept(firstSortColumn);
        }
    }

    @Override
    public void setSortingEnabled(C columnIdentifier, boolean sortingEnabled) {
        Objects.requireNonNull(columnIdentifier);
        if (sortingEnabled) {
            this.columnSortingDisabled.remove(columnIdentifier);
        } else {
            this.columnSortingDisabled.add(columnIdentifier);
            if (this.removeSortOrder(columnIdentifier)) {
                this.sortingChangedEvent.accept(columnIdentifier);
            }
        }
    }

    @Override
    public boolean isSortingEnabled(C columnIdentifier) {
        return !this.columnSortingDisabled.contains(Objects.requireNonNull(columnIdentifier));
    }

    @Override
    public void addSortingChangedListener(Consumer<C> listener) {
        this.sortingChangedEvent.addDataListener(listener);
    }

    @Override
    public void removeSortingChangedListener(Consumer<C> listener) {
        this.sortingChangedEvent.removeDataListener(listener);
    }

    private void setSortOrder(C columnIdentifier, SortOrder sortOrder, boolean addColumnToSort) {
        Objects.requireNonNull(columnIdentifier);
        Objects.requireNonNull(sortOrder);
        if (!this.isSortingEnabled(columnIdentifier)) {
            throw new IllegalStateException("Sorting is disabled for column: " + columnIdentifier);
        }
        if (!addColumnToSort) {
            this.columnSortOrders.clear();
        } else {
            this.removeSortOrder(columnIdentifier);
        }
        if (sortOrder != SortOrder.UNSORTED) {
            this.columnSortOrders.add(new DefaultColumnSortOrder<C>(columnIdentifier, sortOrder));
        }
        this.sortingChangedEvent.accept(columnIdentifier);
    }

    private boolean removeSortOrder(C columnIdentifier) {
        return this.columnSortOrders.removeIf(columnSortOrder -> columnSortOrder.columnIdentifier().equals(columnIdentifier));
    }

    private final class RowComparator
    implements Comparator<R> {
        private RowComparator() {
        }

        @Override
        public int compare(R rowOne, R rowTwo) {
            for (FilteredTableSortModel.ColumnSortOrder columnSortOrder : DefaultFilteredTableSortModel.this.columnSortOrders) {
                int comparison = this.compareRows(rowOne, rowTwo, columnSortOrder.columnIdentifier(), columnSortOrder.sortOrder());
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }

        private int compareRows(R rowOne, R rowTwo, C columnIdentifier, SortOrder sortOrder) {
            Object valueOne = DefaultFilteredTableSortModel.this.columnValueProvider.value(rowOne, columnIdentifier);
            Object valueTwo = DefaultFilteredTableSortModel.this.columnValueProvider.value(rowTwo, columnIdentifier);
            int comparison = valueOne == null && valueTwo == null ? 0 : (valueOne == null ? -1 : (valueTwo == null ? 1 : DefaultFilteredTableSortModel.this.columnComparators.computeIfAbsent(columnIdentifier, k -> DefaultFilteredTableSortModel.this.columnModel.column(columnIdentifier).comparator()).compare(valueOne, valueTwo)));
            if (comparison != 0) {
                return sortOrder == SortOrder.DESCENDING ? -comparison : comparison;
            }
            return 0;
        }
    }

    private static final class DefaultColumnSortOrder<C>
    implements FilteredTableSortModel.ColumnSortOrder<C> {
        private final C columnIdentifier;
        private final SortOrder sortOrder;

        private DefaultColumnSortOrder(C columnIdentifier, SortOrder sortOrder) {
            this.columnIdentifier = columnIdentifier;
            this.sortOrder = sortOrder;
        }

        @Override
        public C columnIdentifier() {
            return this.columnIdentifier;
        }

        @Override
        public SortOrder sortOrder() {
            return this.sortOrder;
        }
    }
}

