/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component.button;

import is.codion.common.value.Value;
import java.awt.event.ItemEvent;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.DefaultButtonModel;

public final class NullableToggleButtonModel
extends DefaultButtonModel {
    public static final int NULL = 3;
    private final Value<Boolean> buttonState = Value.value();

    public NullableToggleButtonModel() {
        this(null);
    }

    public NullableToggleButtonModel(Boolean initialState) {
        this.setState(initialState);
    }

    @Override
    public boolean isSelected() {
        return Objects.equals(this.buttonState.get(), Boolean.TRUE);
    }

    @Override
    public void setSelected(boolean selected) {
        this.setState(selected);
    }

    public void setState(Boolean state) {
        this.buttonState.set((Object)state);
        this.fireItemStateChanged(new ItemEvent(this, 701, this, state == null ? 3 : (state != false ? 1 : 2)));
        this.fireStateChanged();
    }

    public Boolean getState() {
        return (Boolean)this.buttonState.get();
    }

    public void nextState() {
        Boolean state = this.getState();
        if (state == null) {
            this.setState(false);
        } else if (!state.booleanValue()) {
            this.setState(true);
        } else {
            this.setState(null);
        }
    }

    public void addListener(Consumer<Boolean> listener) {
        this.buttonState.addDataListener(listener);
    }

    public void removeListener(Consumer<Boolean> listener) {
        this.buttonState.removeDataListener(listener);
    }
}

