/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component.table;

import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.model.component.table.FilteredTableSearchModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;

final class DefaultFilteredTableSearchModel<C>
implements FilteredTableSearchModel {
    private static final FilteredTableSearchModel.RowColumn NULL_COORDINATE = new DefaultRowColumn(-1, -1);
    private final FilteredTableModel<?, C> tableModel;
    private final State regularExpression = State.state();
    private final State caseSensitive = State.state();
    private final List<FilteredTableSearchModel.RowColumn> searchResults = new ArrayList<FilteredTableSearchModel.RowColumn>();
    private final Value<String> searchString = Value.value((Object)"", (Object)"");
    private final Value<Predicate<String>> searchPredicate = Value.value();
    private final Value<FilteredTableSearchModel.RowColumn> searchResult = Value.value((Object)NULL_COORDINATE, (Object)NULL_COORDINATE);
    private int searchResultIndex = -1;

    DefaultFilteredTableSearchModel(FilteredTableModel<?, C> tableModel) {
        this.tableModel = Objects.requireNonNull(tableModel);
        this.bindEvents();
    }

    @Override
    public State regularExpression() {
        return this.regularExpression;
    }

    @Override
    public State caseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public Value<String> searchString() {
        return this.searchString;
    }

    @Override
    public Value<Predicate<String>> searchPredicate() {
        return this.searchPredicate;
    }

    @Override
    public List<FilteredTableSearchModel.RowColumn> searchResults() {
        return Collections.unmodifiableList(new ArrayList<FilteredTableSearchModel.RowColumn>(this.searchResults));
    }

    @Override
    public FilteredTableSearchModel.RowColumn currentResult() {
        return this.searchResultIndex == -1 ? NULL_COORDINATE : (FilteredTableSearchModel.RowColumn)this.searchResult.get();
    }

    @Override
    public Optional<FilteredTableSearchModel.RowColumn> nextResult() {
        return this.nextResult(false);
    }

    @Override
    public Optional<FilteredTableSearchModel.RowColumn> selectNextResult() {
        return this.nextResult(true);
    }

    @Override
    public Optional<FilteredTableSearchModel.RowColumn> previousResult() {
        return this.previousResult(false);
    }

    @Override
    public Optional<FilteredTableSearchModel.RowColumn> selectPreviousResult() {
        return this.previousResult(true);
    }

    @Override
    public void addCurrentResultListener(Consumer<FilteredTableSearchModel.RowColumn> listener) {
        this.searchResult.addDataListener(listener);
    }

    @Override
    public void removeCurrentResultListener(Consumer<FilteredTableSearchModel.RowColumn> listener) {
        this.searchResult.removeDataListener(listener);
    }

    private Optional<FilteredTableSearchModel.RowColumn> nextResult(boolean addToSelection) {
        if (this.searchResults.isEmpty()) {
            return this.emptyResult(addToSelection);
        }
        this.searchResultIndex = this.incrementSearchResultIndex();
        this.searchResult.set((Object)this.searchResults.get(this.searchResultIndex));
        return this.selectResult(addToSelection);
    }

    private Optional<FilteredTableSearchModel.RowColumn> previousResult(boolean addToSelection) {
        if (this.searchResults.isEmpty()) {
            return this.emptyResult(addToSelection);
        }
        this.searchResultIndex = this.decrementSearchResultIndex();
        this.searchResult.set((Object)this.searchResults.get(this.searchResultIndex));
        return this.selectResult(addToSelection);
    }

    private Optional<FilteredTableSearchModel.RowColumn> selectResult(boolean addToSelection) {
        if (addToSelection) {
            this.tableModel.selectionModel().addSelectedIndex(((FilteredTableSearchModel.RowColumn)this.searchResult.get()).row());
        } else {
            this.tableModel.selectionModel().setSelectedIndex(((FilteredTableSearchModel.RowColumn)this.searchResult.get()).row());
        }
        return this.searchResult.optional();
    }

    private Optional<FilteredTableSearchModel.RowColumn> emptyResult(boolean addToSelection) {
        if (!addToSelection) {
            this.tableModel.selectionModel().clearSelection();
        }
        return Optional.empty();
    }

    private int incrementSearchResultIndex() {
        return this.searchResultIndex == -1 || this.searchResultIndex == this.searchResults.size() - 1 ? 0 : this.searchResultIndex + 1;
    }

    private int decrementSearchResultIndex() {
        return this.searchResultIndex == -1 || this.searchResultIndex == 0 ? this.searchResults.size() - 1 : this.searchResultIndex - 1;
    }

    private void performSearch() {
        this.clearSearchResults();
        if (this.searchPredicate.isNull() || this.tableModel.getRowCount() == 0 || this.tableModel.getColumnCount() == 0) {
            return;
        }
        Predicate predicate = (Predicate)this.searchPredicate.get();
        for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
            for (int column = 0; column < this.tableModel.getColumnCount(); ++column) {
                if (!predicate.test(this.tableModel.getStringAt(row, ((FilteredTableColumn)this.tableModel.columnModel().getColumn(column)).getIdentifier()))) continue;
                this.searchResults.add(new DefaultRowColumn(row, column));
            }
        }
    }

    private void clearSearchResults() {
        this.searchResults.clear();
        this.searchResultIndex = -1;
        this.searchResult.set(null);
    }

    private void bindEvents() {
        this.searchString.addDataListener(searchString -> this.searchPredicate.set(this.createSearchPredicate((String)searchString)));
        this.searchPredicate.addListener(this::performSearch);
        this.regularExpression.addListener(() -> this.searchString.set(null));
        this.caseSensitive.addListener(this::performSearch);
        this.tableModel.columnModel().addColumnModelListener(new ClearSearchListener());
        this.tableModel.addDataChangedListener(() -> {
            this.clearSearchResults();
            this.performSearch();
        });
    }

    private Predicate<String> createSearchPredicate(String searchText) {
        if (searchText.isEmpty()) {
            return null;
        }
        if (((Boolean)this.regularExpression.get()).booleanValue()) {
            try {
                return new RegexSearchCondition(searchText);
            }
            catch (PatternSyntaxException e) {
                return null;
            }
        }
        return new StringSearchCondition(searchText, this.caseSensitive);
    }

    static final class DefaultRowColumn
    implements FilteredTableSearchModel.RowColumn {
        private final int row;
        private final int column;

        DefaultRowColumn(int row, int column) {
            this.row = row;
            this.column = column;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int column() {
            return this.column;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof DefaultRowColumn && ((DefaultRowColumn)obj).row() == this.row() && ((DefaultRowColumn)obj).column() == this.column();
        }

        public int hashCode() {
            return this.row + this.column;
        }

        public String toString() {
            return "row: " + this.row + ", column: " + this.column;
        }
    }

    private final class ClearSearchListener
    implements TableColumnModelListener {
        private ClearSearchListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            DefaultFilteredTableSearchModel.this.clearSearchResults();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            DefaultFilteredTableSearchModel.this.clearSearchResults();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            DefaultFilteredTableSearchModel.this.clearSearchResults();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    private static final class RegexSearchCondition
    implements Predicate<String> {
        private final Pattern pattern;

        private RegexSearchCondition(String patternString) {
            this.pattern = Pattern.compile(patternString);
        }

        @Override
        public boolean test(String item) {
            return item != null && this.pattern.matcher(item).find();
        }
    }

    private static final class StringSearchCondition
    implements Predicate<String> {
        private final String searchText;
        private final State caseSensitiveSearch;

        private StringSearchCondition(String searchText, State caseSensitiveSearch) {
            this.searchText = searchText;
            this.caseSensitiveSearch = caseSensitiveSearch;
        }

        @Override
        public boolean test(String item) {
            return item != null && ((Boolean)this.caseSensitiveSearch.get() != false ? item : item.toLowerCase()).contains((Boolean)this.caseSensitiveSearch.get() != false ? this.searchText : this.searchText.toLowerCase());
        }
    }
}

