/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.component.combobox;

import is.codion.common.Configuration;
import is.codion.common.Text;
import is.codion.common.event.Event;
import is.codion.common.model.FilteredModel;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import is.codion.swing.common.model.component.AbstractFilteredModelRefresher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class FilteredComboBoxModel<T>
implements FilteredModel<T>,
ComboBoxModel<T> {
    public static final PropertyValue<String> COMBO_BOX_NULL_CAPTION = Configuration.stringValue((String)"is.codion.common.model.combobox.nullCaption", (String)"-");
    private static final Predicate<?> DEFAULT_ITEM_VALIDATOR = new DefaultItemValidator();
    private static final Function<Object, ?> DEFAULT_SELECTED_ITEM_TRANSLATOR = new DefaultSelectedItemTranslator();
    private static final Predicate<?> DEFAULT_ALLOW_SELECTION_PREDICATE = new DefaultAllowSelectionPredicate();
    private static final Comparator<?> DEFAULT_COMPARATOR = new DefaultComparator();
    private final Event<T> selectionChangedEvent = Event.event();
    private final State selectionEmpty = State.state((boolean)true);
    private final State includeNull = State.state();
    private final Value<T> nullItem = Value.value();
    private final State filterSelectedItem = State.state((boolean)true);
    private final List<T> visibleItems = new ArrayList<T>();
    private final List<T> filteredItems = new ArrayList<T>();
    private final FilteredModel.Refresher<T> refresher;
    private final Value<Predicate<T>> includeCondition = Value.value();
    private final Value<Predicate<T>> itemValidator = Value.value(DEFAULT_ITEM_VALIDATOR, DEFAULT_ITEM_VALIDATOR);
    private final Value<Function<Object, T>> selectedItemTranslator = Value.value(DEFAULT_SELECTED_ITEM_TRANSLATOR, DEFAULT_SELECTED_ITEM_TRANSLATOR);
    private final Value<Predicate<T>> allowSelectionPredicate = Value.value(DEFAULT_ALLOW_SELECTION_PREDICATE, DEFAULT_ALLOW_SELECTION_PREDICATE);
    private final Value<Comparator<T>> comparator = Value.value(DEFAULT_COMPARATOR);
    private boolean cleared = true;
    private T selectedItem = null;
    private final CopyOnWriteArrayList<ListDataListener> listDataListeners = new CopyOnWriteArrayList();

    public FilteredComboBoxModel() {
        this.refresher = new DefaultRefresher(new DefaultItemSupplier());
        this.includeCondition.addListener(this::filterItems);
        this.itemValidator.addValidator(validator -> this.items().stream().filter(Objects::nonNull).forEach(validator::test));
        this.comparator.addListener(this::sortVisibleItems);
        this.allowSelectionPredicate.addValidator(predicate -> {
            if (predicate != null && !predicate.test(this.selectedItem)) {
                throw new IllegalArgumentException("The current selected item does not satisfy the allow selection predicate");
            }
        });
        this.includeNull.addDataListener(value -> {
            if (value.booleanValue() && !this.visibleItems.contains(null)) {
                this.visibleItems.add(0, null);
            } else {
                this.visibleItems.remove(null);
            }
        });
        this.nullItem.addValidator(this::validate);
    }

    public final FilteredModel.Refresher<T> refresher() {
        return this.refresher;
    }

    public final void refresh() {
        this.refreshThen(null);
    }

    public final void refreshThen(Consumer<Collection<T>> afterRefresh) {
        this.refresher.refreshThen(afterRefresh);
    }

    public final void clear() {
        this.setSelectedItem(null);
        this.setItems(null);
    }

    public final boolean cleared() {
        return this.cleared;
    }

    public final void setItems(Collection<T> items) {
        this.filteredItems.clear();
        this.visibleItems.clear();
        if (items != null) {
            items.forEach(this::validate);
            this.visibleItems.addAll(items);
            if (((Boolean)this.includeNull.get()).booleanValue()) {
                this.visibleItems.add(0, null);
            }
        }
        this.filterItems();
        this.cleared = items == null;
    }

    public final void filterItems() {
        this.visibleItems.addAll(this.filteredItems);
        this.filteredItems.clear();
        if (this.includeCondition.isNotNull()) {
            ListIterator<T> iterator = this.visibleItems.listIterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (item == null || ((Predicate)this.includeCondition.get()).test(item)) continue;
                this.filteredItems.add(item);
                iterator.remove();
            }
        }
        this.sortVisibleItems();
        if (this.selectedItem != null && this.visibleItems.contains(this.selectedItem)) {
            this.selectedItem = this.visibleItems.get(this.visibleItems.indexOf(this.selectedItem));
        }
        if (this.selectedItem != null && !this.visibleItems.contains(this.selectedItem) && ((Boolean)this.filterSelectedItem.get()).booleanValue()) {
            this.setSelectedItem(null);
        } else {
            this.fireContentsChanged();
        }
    }

    public final List<T> visibleItems() {
        if (this.visibleItems.isEmpty()) {
            return Collections.emptyList();
        }
        if (!((Boolean)this.includeNull.get()).booleanValue()) {
            return Collections.unmodifiableList(this.visibleItems);
        }
        return Collections.unmodifiableList(this.visibleItems.subList(1, this.getSize()));
    }

    public final Collection<T> filteredItems() {
        return Collections.unmodifiableList(this.filteredItems);
    }

    public final Collection<T> items() {
        ArrayList<T> entities = new ArrayList<T>(this.visibleItems());
        entities.addAll(this.filteredItems);
        return Collections.unmodifiableList(entities);
    }

    public final Value<Predicate<T>> includeCondition() {
        return this.includeCondition;
    }

    public final int filteredCount() {
        return this.filteredItems.size();
    }

    public final int visibleCount() {
        return this.visibleItems.size();
    }

    public final boolean visible(T item) {
        if (item == null) {
            return (Boolean)this.includeNull.get();
        }
        return this.visibleItems.contains(item);
    }

    public final boolean filtered(T item) {
        return this.filteredItems.contains(item);
    }

    public final void add(T item) {
        this.validate(item);
        if (this.includeCondition.isNull() || ((Predicate)this.includeCondition.get()).test(item)) {
            if (!this.visibleItems.contains(item)) {
                this.visibleItems.add(item);
                this.sortVisibleItems();
            }
        } else if (!this.filteredItems.contains(item)) {
            this.filteredItems.add(item);
        }
    }

    public final void remove(T item) {
        Objects.requireNonNull(item);
        this.filteredItems.remove(item);
        if (this.visibleItems.remove(item)) {
            this.fireContentsChanged();
        }
    }

    public final void replace(T item, T replacement) {
        this.validate(replacement);
        this.remove(item);
        this.add(replacement);
        if (Objects.equals(this.selectedItem, item)) {
            this.selectedItem = ((Function)this.selectedItemTranslator.get()).apply(null);
            this.setSelectedItem(replacement);
        }
    }

    public final boolean containsItem(T item) {
        return this.visibleItems.contains(item) || this.filteredItems.contains(item);
    }

    public final Value<Comparator<T>> comparator() {
        return this.comparator;
    }

    public final Value<Predicate<T>> itemValidator() {
        return this.itemValidator;
    }

    public final Value<Function<Object, T>> selectedItemTranslator() {
        return this.selectedItemTranslator;
    }

    public final Value<Predicate<T>> allowSelectionPredicate() {
        return this.allowSelectionPredicate;
    }

    public final State includeNull() {
        return this.includeNull;
    }

    public final Value<T> nullItem() {
        return this.nullItem;
    }

    public final boolean nullSelected() {
        return (Boolean)this.includeNull.get() != false && this.selectedItem == null;
    }

    public final StateObserver selectionEmpty() {
        return this.selectionEmpty.observer();
    }

    public final T selectedValue() {
        if (this.nullSelected()) {
            return null;
        }
        return this.selectedItem;
    }

    @Override
    public final T getSelectedItem() {
        if (this.selectedItem == null && this.nullItem.isNotNull()) {
            return (T)this.nullItem.get();
        }
        return this.selectedItem;
    }

    @Override
    public final void setSelectedItem(Object item) {
        Object toSelect = ((Function)this.selectedItemTranslator.get()).apply(Objects.equals(this.nullItem.get(), item) ? null : item);
        if (!Objects.equals(this.selectedItem, toSelect) && ((Predicate)this.allowSelectionPredicate.get()).test(toSelect)) {
            this.selectedItem = toSelect;
            this.fireContentsChanged();
            this.selectionEmpty.set((Object)(this.selectedValue() == null ? 1 : 0));
            this.selectionChangedEvent.accept(this.selectedItem);
        }
    }

    public final State filterSelectedItem() {
        return this.filterSelectedItem;
    }

    @Override
    public final void addListDataListener(ListDataListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.listDataListeners.add(listener);
    }

    @Override
    public final void removeListDataListener(ListDataListener listener) {
        Objects.requireNonNull(listener, "listener");
        this.listDataListeners.remove(listener);
    }

    @Override
    public final T getElementAt(int index) {
        T element = this.visibleItems.get(index);
        if (element == null) {
            return (T)this.nullItem.get();
        }
        return element;
    }

    @Override
    public final int getSize() {
        return this.visibleItems.size();
    }

    public final <V> Value<V> createSelectorValue(ItemFinder<T, V> itemFinder) {
        return new SelectorValue<V>(itemFinder);
    }

    public final void addSelectionListener(Consumer<T> listener) {
        this.selectionChangedEvent.addDataListener(listener);
    }

    public final void removeSelectionListener(Consumer<T> listener) {
        this.selectionChangedEvent.removeDataListener(listener);
    }

    private void fireContentsChanged() {
        ListDataEvent event = new ListDataEvent(this, 0, 0, Integer.MAX_VALUE);
        for (ListDataListener dataListener : this.listDataListeners) {
            dataListener.contentsChanged(event);
        }
    }

    private void validate(T item) {
        if (!((Predicate)this.itemValidator.get()).test(item)) {
            throw new IllegalArgumentException("Invalid item: " + item);
        }
    }

    private void sortVisibleItems() {
        if (this.comparator.isNotNull() && !this.visibleItems.isEmpty()) {
            this.visibleItems.sort((Comparator)this.comparator.get());
            this.fireContentsChanged();
        }
    }

    private final class DefaultRefresher
    extends AbstractFilteredModelRefresher<T> {
        private DefaultRefresher(Supplier<Collection<T>> itemSupplier) {
            super(itemSupplier);
        }

        protected void processResult(Collection<T> items) {
            FilteredComboBoxModel.this.setItems(items);
        }
    }

    private final class DefaultItemSupplier
    implements Supplier<Collection<T>> {
        private DefaultItemSupplier() {
        }

        @Override
        public Collection<T> get() {
            return FilteredComboBoxModel.this.items();
        }
    }

    private final class SelectorValue<V>
    extends AbstractValue<V> {
        private final ItemFinder<T, V> itemFinder;

        private SelectorValue(ItemFinder<T, V> itemFinder) {
            this.itemFinder = Objects.requireNonNull(itemFinder);
            FilteredComboBoxModel.this.addSelectionListener(selected -> this.notifyListeners());
        }

        public V get() {
            if (((Boolean)FilteredComboBoxModel.this.selectionEmpty.get()).booleanValue()) {
                return null;
            }
            return this.itemFinder.value(FilteredComboBoxModel.this.selectedValue());
        }

        protected void setValue(V value) {
            FilteredComboBoxModel.this.setSelectedItem(value == null ? null : this.itemFinder.findItem(FilteredComboBoxModel.this.visibleItems(), value));
        }
    }

    public static interface ItemFinder<T, V> {
        public V value(T var1);

        public Predicate<T> createPredicate(V var1);

        default public T findItem(Collection<T> items, V value) {
            Objects.requireNonNull(value);
            return Objects.requireNonNull(items).stream().filter(this.createPredicate(value)).findFirst().orElse(null);
        }
    }

    private static final class DefaultItemValidator<T>
    implements Predicate<T> {
        private DefaultItemValidator() {
        }

        @Override
        public boolean test(T item) {
            return true;
        }
    }

    private static final class DefaultSelectedItemTranslator<T>
    implements Function<Object, T> {
        private DefaultSelectedItemTranslator() {
        }

        @Override
        public T apply(Object item) {
            return (T)item;
        }
    }

    private static final class DefaultAllowSelectionPredicate<T>
    implements Predicate<T> {
        private DefaultAllowSelectionPredicate() {
        }

        @Override
        public boolean test(T item) {
            return true;
        }
    }

    private static final class DefaultComparator<T>
    implements Comparator<T> {
        private final Comparator<T> comparator = Text.spaceAwareCollator();

        private DefaultComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return this.comparator.compare(o1, o2);
        }
    }
}

