/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.tools.loadtest;

import com.sun.management.OperatingSystemMXBean;
import is.codion.common.Memory;
import is.codion.common.model.loadtest.LoadTest;
import is.codion.common.scheduler.TaskScheduler;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.swing.common.model.component.table.FilterTableModel;
import is.codion.swing.common.model.tools.loadtest.LoadTestModel;
import java.lang.management.ManagementFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;

final class DefaultLoadTestModel<T>
implements LoadTestModel<T> {
    public static final int DEFAULT_CHART_DATA_UPDATE_INTERVAL_MS = 2000;
    private static final double HUNDRED = 100.0;
    private static final double THOUSAND = 1000.0;
    private static final int MAXIMUM_EXCEPTIONS = 20;
    private static final AtomicInteger ZERO = new AtomicInteger();
    private final LoadTest<T> loadTest;
    private final FilterTableModel<LoadTestModel.ApplicationRow, LoadTestModel.ApplicationRow.ColumnId> applicationTableModel;
    private final Counter counter = new Counter();
    private final State collectChartData = State.state();
    private final State autoRefreshApplications = State.state((boolean)true);
    private final StateObserver chartUpdateSchedulerEnabled;
    private final StateObserver applicationsRefreshSchedulerEnabled;
    private final TaskScheduler chartUpdateScheduler;
    private final TaskScheduler applicationsRefreshScheduler;
    private final XYSeries scenariosRunSeries = new XYSeries((Comparable)((Object)"Total"));
    private final XYSeriesCollection scenarioFailureCollection = new XYSeriesCollection();
    private final XYSeries minimumThinkTimeSeries = new XYSeries((Comparable)((Object)"Minimum think time"));
    private final XYSeries maximumThinkTimeSeries = new XYSeries((Comparable)((Object)"Maximum think time"));
    private final XYSeriesCollection thinkTimeCollection = new XYSeriesCollection();
    private final XYSeries numberOfApplicationsSeries = new XYSeries((Comparable)((Object)"Application count"));
    private final XYSeriesCollection numberOfApplicationsCollection = new XYSeriesCollection();
    private final XYSeriesCollection scenarioCollection = new XYSeriesCollection();
    private final XYSeries allocatedMemoryCollection = new XYSeries((Comparable)((Object)"Allocated"));
    private final XYSeries usedMemoryCollection = new XYSeries((Comparable)((Object)"Used"));
    private final XYSeries maxMemoryCollection = new XYSeries((Comparable)((Object)"Available"));
    private final XYSeriesCollection memoryUsageCollection = new XYSeriesCollection();
    private final Collection<XYSeries> usageSeries = new ArrayList<XYSeries>();
    private final Map<String, YIntervalSeries> durationSeries = new HashMap<String, YIntervalSeries>();
    private final Collection<XYSeries> failureSeries = new ArrayList<XYSeries>();
    private final XYSeries systemLoadSeries = new XYSeries((Comparable)((Object)"System Load"));
    private final XYSeries processLoadSeries = new XYSeries((Comparable)((Object)"Process Load"));
    private final XYSeriesCollection systemLoadCollection = new XYSeriesCollection();

    DefaultLoadTestModel(LoadTest<T> loadTest) {
        this.loadTest = Objects.requireNonNull(loadTest);
        this.applicationTableModel = FilterTableModel.builder((FilterTableModel.Columns)new ApplicationColumns()).items((Supplier)new ApplicationItems()).build();
        this.chartUpdateSchedulerEnabled = State.and((StateObserver[])new StateObserver[]{loadTest.paused().not(), this.collectChartData});
        this.applicationsRefreshSchedulerEnabled = State.and((StateObserver[])new StateObserver[]{loadTest.paused().not(), this.autoRefreshApplications});
        this.initializeChartModels();
        this.chartUpdateScheduler = TaskScheduler.builder((Runnable)new ChartUpdateTask()).interval(2000, TimeUnit.MILLISECONDS).build();
        this.applicationsRefreshScheduler = TaskScheduler.builder(() -> this.applicationTableModel.refresh()).interval(2000, TimeUnit.MILLISECONDS).start();
        this.bindEvents();
    }

    @Override
    public LoadTest<T> loadTest() {
        return this.loadTest;
    }

    @Override
    public void removeSelectedApplications() {
        this.applicationTableModel.selectionModel().getSelectedItems().stream().map(DefaultApplicationRow.class::cast).forEach(application -> this.loadTest.stop(application.applicationRunner));
    }

    @Override
    public FilterTableModel<LoadTestModel.ApplicationRow, LoadTestModel.ApplicationRow.ColumnId> applicationTableModel() {
        return this.applicationTableModel;
    }

    @Override
    public IntervalXYDataset scenarioDurationDataset(String name) {
        YIntervalSeriesCollection scenarioDurationCollection = new YIntervalSeriesCollection();
        scenarioDurationCollection.addSeries(this.durationSeries.get(name));
        return scenarioDurationCollection;
    }

    @Override
    public XYDataset thinkTimeDataset() {
        return this.thinkTimeCollection;
    }

    @Override
    public XYDataset numberOfApplicationsDataset() {
        return this.numberOfApplicationsCollection;
    }

    @Override
    public XYDataset scenarioDataset() {
        return this.scenarioCollection;
    }

    @Override
    public XYDataset scenarioFailureDataset() {
        return this.scenarioFailureCollection;
    }

    @Override
    public XYDataset memoryUsageDataset() {
        return this.memoryUsageCollection;
    }

    @Override
    public XYDataset systemLoadDataset() {
        return this.systemLoadCollection;
    }

    @Override
    public void clearCharts() {
        this.scenariosRunSeries.clear();
        this.minimumThinkTimeSeries.clear();
        this.maximumThinkTimeSeries.clear();
        this.numberOfApplicationsSeries.clear();
        this.allocatedMemoryCollection.clear();
        this.usedMemoryCollection.clear();
        this.maxMemoryCollection.clear();
        this.systemLoadSeries.clear();
        this.processLoadSeries.clear();
        for (XYSeries xYSeries : this.usageSeries) {
            xYSeries.clear();
        }
        for (XYSeries xYSeries : this.failureSeries) {
            xYSeries.clear();
        }
        for (YIntervalSeries yIntervalSeries : this.durationSeries.values()) {
            yIntervalSeries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int totalRunCount(String scenarioName) {
        Counter counter = this.counter;
        synchronized (counter) {
            return this.counter.scenarioRunCounts.getOrDefault(scenarioName, ZERO).get() + this.counter.scenarioFailureCounts.getOrDefault(scenarioName, ZERO).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int successfulRunCount(String scenarioName) {
        Counter counter = this.counter;
        synchronized (counter) {
            return this.counter.scenarioRunCounts.getOrDefault(scenarioName, ZERO).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unsuccessfulRunCount(String scenarioName) {
        Counter counter = this.counter;
        synchronized (counter) {
            return this.counter.scenarioFailureCounts.getOrDefault(scenarioName, ZERO).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetRunCounter() {
        Counter counter = this.counter;
        synchronized (counter) {
            this.counter.resetCounters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Exception> exceptions(String scenarioName) {
        Counter counter = this.counter;
        synchronized (counter) {
            Collection exceptions = this.counter.scenarioExceptions.get(scenarioName);
            return exceptions == null ? Collections.emptyList() : new ArrayList<Exception>(exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearExceptions(String scenarioName) {
        Counter counter = this.counter;
        synchronized (counter) {
            Collection exceptions = this.counter.scenarioExceptions.get(scenarioName);
            if (exceptions != null) {
                exceptions.clear();
            }
        }
    }

    @Override
    public int getUpdateInterval() {
        return (Integer)this.chartUpdateScheduler.interval().get();
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        this.chartUpdateScheduler.interval().set((Object)updateInterval);
    }

    @Override
    public State collectChartData() {
        return this.collectChartData;
    }

    @Override
    public State autoRefreshApplications() {
        return this.autoRefreshApplications;
    }

    private void initializeChartModels() {
        this.thinkTimeCollection.addSeries(this.minimumThinkTimeSeries);
        this.thinkTimeCollection.addSeries(this.maximumThinkTimeSeries);
        this.numberOfApplicationsCollection.addSeries(this.numberOfApplicationsSeries);
        this.memoryUsageCollection.addSeries(this.maxMemoryCollection);
        this.memoryUsageCollection.addSeries(this.allocatedMemoryCollection);
        this.memoryUsageCollection.addSeries(this.usedMemoryCollection);
        this.systemLoadCollection.addSeries(this.systemLoadSeries);
        this.systemLoadCollection.addSeries(this.processLoadSeries);
        this.scenarioCollection.addSeries(this.scenariosRunSeries);
        for (LoadTest.Scenario scenario : this.loadTest.scenarios()) {
            XYSeries series = new XYSeries((Comparable)((Object)scenario.name()));
            this.scenarioCollection.addSeries(series);
            this.usageSeries.add(series);
            YIntervalSeries avgDurSeries = new YIntervalSeries((Comparable)((Object)scenario.name()));
            this.durationSeries.put(scenario.name(), avgDurSeries);
            XYSeries failSeries = new XYSeries((Comparable)((Object)scenario.name()));
            this.scenarioFailureCollection.addSeries(failSeries);
            this.failureSeries.add(failSeries);
        }
    }

    private void bindEvents() {
        this.loadTest.resultEvent().addConsumer(this.counter::addScenarioResults);
        this.loadTest.addShutdownListener(() -> {
            this.applicationsRefreshScheduler.stop();
            this.chartUpdateScheduler.stop();
        });
        this.chartUpdateSchedulerEnabled.addConsumer((Consumer)new TaskSchedulerController(this.chartUpdateScheduler));
        this.applicationsRefreshSchedulerEnabled.addConsumer((Consumer)new TaskSchedulerController(this.applicationsRefreshScheduler));
    }

    private static double systemCpuLoad() {
        return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getSystemCpuLoad();
    }

    private static double processCpuLoad() {
        return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getProcessCpuLoad();
    }

    private final class Counter {
        private static final int UPDATE_INTERVAL = 5;
        private final Map<String, Integer> scenarioRates = new HashMap<String, Integer>();
        private final Map<String, Integer> scenarioAvgDurations = new HashMap<String, Integer>();
        private final Map<String, Integer> scenarioMaxDurations = new HashMap<String, Integer>();
        private final Map<String, Integer> scenarioMinDurations = new HashMap<String, Integer>();
        private final Map<String, Integer> scenarioFailures = new HashMap<String, Integer>();
        private final Map<String, List<Integer>> scenarioDurations = new HashMap<String, List<Integer>>();
        private final Map<String, AtomicInteger> scenarioRunCounts = new HashMap<String, AtomicInteger>();
        private final Map<String, AtomicInteger> scenarioFailureCounts = new HashMap<String, AtomicInteger>();
        private final Map<String, List<Exception>> scenarioExceptions = new HashMap<String, List<Exception>>();
        private final AtomicInteger workRequestCounter = new AtomicInteger();
        private double workRequestsPerSecond = 0.0;
        private long time = System.currentTimeMillis();

        private Counter() {
        }

        private double workRequestsPerSecond() {
            return this.workRequestsPerSecond;
        }

        private int minimumScenarioDuration(String scenarioName) {
            if (!this.scenarioMinDurations.containsKey(scenarioName)) {
                return 0;
            }
            return this.scenarioMinDurations.get(scenarioName);
        }

        private int maximumScenarioDuration(String scenarioName) {
            if (!this.scenarioMaxDurations.containsKey(scenarioName)) {
                return 0;
            }
            return this.scenarioMaxDurations.get(scenarioName);
        }

        private int averageScenarioDuration(String scenarioName) {
            if (!this.scenarioAvgDurations.containsKey(scenarioName)) {
                return 0;
            }
            return this.scenarioAvgDurations.get(scenarioName);
        }

        private double scenarioFailureRate(String scenarioName) {
            if (!this.scenarioFailures.containsKey(scenarioName)) {
                return 0.0;
            }
            return this.scenarioFailures.get(scenarioName).intValue();
        }

        private int scenarioRate(String scenarioName) {
            if (!this.scenarioRates.containsKey(scenarioName)) {
                return 0;
            }
            return this.scenarioRates.get(scenarioName);
        }

        private synchronized void addScenarioResults(LoadTest.Scenario.Result result) {
            LoadTest.Scenario scenario = DefaultLoadTestModel.this.loadTest.scenario(result.scenario());
            this.scenarioDurations.computeIfAbsent(scenario.name(), scenarioName -> new ArrayList()).add(result.duration());
            if (result.successful()) {
                this.scenarioRunCounts.computeIfAbsent(scenario.name(), scenarioName -> new AtomicInteger()).incrementAndGet();
            } else {
                this.scenarioFailureCounts.computeIfAbsent(scenario.name(), scenarioName -> new AtomicInteger()).incrementAndGet();
                result.exception().ifPresent(exception -> {
                    List exceptions = this.scenarioExceptions.computeIfAbsent(scenario.name(), scenarioName -> new ArrayList());
                    exceptions.add(exception);
                    if (exceptions.size() > 20) {
                        exceptions.remove(0);
                    }
                });
            }
            this.workRequestCounter.incrementAndGet();
        }

        private synchronized void updateRequestsPerSecond() {
            long current = System.currentTimeMillis();
            double elapsedSeconds = (double)(current - this.time) / 1000.0;
            if (elapsedSeconds > 5.0) {
                this.scenarioAvgDurations.clear();
                this.scenarioMinDurations.clear();
                this.scenarioMaxDurations.clear();
                this.workRequestsPerSecond = (double)this.workRequestCounter.get() / elapsedSeconds;
                for (LoadTest.Scenario scenario : DefaultLoadTestModel.this.loadTest.scenarios()) {
                    this.scenarioRates.put(scenario.name(), (int)((double)this.scenarioRunCounts.getOrDefault(scenario.name(), ZERO).get() / elapsedSeconds));
                    this.scenarioFailures.put(scenario.name(), this.scenarioFailureCounts.getOrDefault(scenario.name(), ZERO).get());
                    this.calculateScenarioDuration(scenario);
                }
                this.resetCounters();
                this.time = current;
            }
        }

        private void calculateScenarioDuration(LoadTest.Scenario<T> scenario) {
            Collection durations = this.scenarioDurations.getOrDefault(scenario.name(), Collections.emptyList());
            if (!durations.isEmpty()) {
                int totalDuration = 0;
                int minDuration = -1;
                int maxDuration = -1;
                for (Integer duration : durations) {
                    totalDuration += duration.intValue();
                    if (minDuration == -1) {
                        minDuration = duration;
                        maxDuration = duration;
                        continue;
                    }
                    minDuration = Math.min(minDuration, duration);
                    maxDuration = Math.max(maxDuration, duration);
                }
                this.scenarioAvgDurations.put(scenario.name(), totalDuration / durations.size());
                this.scenarioMinDurations.put(scenario.name(), minDuration);
                this.scenarioMaxDurations.put(scenario.name(), maxDuration);
            }
        }

        private synchronized void resetCounters() {
            this.workRequestCounter.set(0);
            this.scenarioDurations.clear();
            this.scenarioRunCounts.clear();
            this.scenarioFailureCounts.clear();
            this.scenarioExceptions.clear();
        }
    }

    public static final class ApplicationColumns
    implements FilterTableModel.Columns<LoadTestModel.ApplicationRow, LoadTestModel.ApplicationRow.ColumnId> {
        private static final List<LoadTestModel.ApplicationRow.ColumnId> IDENTIFIERS = Collections.unmodifiableList(Arrays.asList(LoadTestModel.ApplicationRow.ColumnId.values()));

        public List<LoadTestModel.ApplicationRow.ColumnId> identifiers() {
            return IDENTIFIERS;
        }

        public Class<?> columnClass(LoadTestModel.ApplicationRow.ColumnId identifier) {
            switch (identifier) {
                case NAME: {
                    return String.class;
                }
                case USERNAME: {
                    return String.class;
                }
                case SCENARIO: {
                    return String.class;
                }
                case SUCCESSFUL: {
                    return Boolean.class;
                }
                case DURATION: {
                    return Integer.class;
                }
                case EXCEPTION: {
                    return String.class;
                }
                case MESSAGE: {
                    return String.class;
                }
                case CREATED: {
                    return LocalDateTime.class;
                }
            }
            throw new IllegalArgumentException("Unknown column: " + identifier);
        }

        public Object value(LoadTestModel.ApplicationRow application, LoadTestModel.ApplicationRow.ColumnId identifier) {
            List<LoadTest.Scenario.Result> results = application.results();
            LoadTest.Scenario.Result result = results.isEmpty() ? null : results.get(results.size() - 1);
            Throwable exception = result == null ? null : (Throwable)result.exception().orElse(null);
            switch (identifier) {
                case NAME: {
                    return application.name();
                }
                case USERNAME: {
                    return application.username();
                }
                case SCENARIO: {
                    return result == null ? null : result.scenario();
                }
                case SUCCESSFUL: {
                    return result == null ? null : Boolean.valueOf(result.successful());
                }
                case DURATION: {
                    return result == null ? null : Integer.valueOf(result.duration());
                }
                case EXCEPTION: {
                    return exception;
                }
                case MESSAGE: {
                    return exception == null ? null : exception.getMessage();
                }
                case CREATED: {
                    return application.created();
                }
            }
            throw new IllegalArgumentException("Unknown column: " + identifier);
        }
    }

    private final class ApplicationItems
    implements Supplier<Collection<LoadTestModel.ApplicationRow>> {
        private ApplicationItems() {
        }

        @Override
        public Collection<LoadTestModel.ApplicationRow> get() {
            return DefaultLoadTestModel.this.loadTest.applications().keySet().stream().map(DefaultApplicationRow::new).collect(Collectors.toList());
        }
    }

    private final class ChartUpdateTask
    implements Runnable {
        private ChartUpdateTask() {
        }

        @Override
        public void run() {
            DefaultLoadTestModel.this.counter.updateRequestsPerSecond();
            this.updateChartData();
        }

        private void updateChartData() {
            long time = System.currentTimeMillis();
            DefaultLoadTestModel.this.minimumThinkTimeSeries.add((double)time, (Number)DefaultLoadTestModel.this.loadTest.minimumThinkTime().get());
            DefaultLoadTestModel.this.maximumThinkTimeSeries.add((double)time, (Number)DefaultLoadTestModel.this.loadTest.maximumThinkTime().get());
            DefaultLoadTestModel.this.numberOfApplicationsSeries.add((double)time, (Number)DefaultLoadTestModel.this.loadTest.applicationCount().get());
            DefaultLoadTestModel.this.allocatedMemoryCollection.add((double)time, (double)Memory.allocatedMemory() / 1000.0);
            DefaultLoadTestModel.this.usedMemoryCollection.add((double)time, (double)Memory.usedMemory() / 1000.0);
            DefaultLoadTestModel.this.maxMemoryCollection.add((double)time, (double)Memory.maxMemory() / 1000.0);
            DefaultLoadTestModel.this.systemLoadSeries.add((double)time, DefaultLoadTestModel.systemCpuLoad() * 100.0);
            DefaultLoadTestModel.this.processLoadSeries.add((double)time, DefaultLoadTestModel.processCpuLoad() * 100.0);
            DefaultLoadTestModel.this.scenariosRunSeries.add((double)time, DefaultLoadTestModel.this.counter.workRequestsPerSecond());
            for (XYSeries xYSeries : DefaultLoadTestModel.this.usageSeries) {
                xYSeries.add((double)time, (double)DefaultLoadTestModel.this.counter.scenarioRate((String)((Object)xYSeries.getKey())));
            }
            for (YIntervalSeries yIntervalSeries : DefaultLoadTestModel.this.durationSeries.values()) {
                String scenario = (String)((Object)yIntervalSeries.getKey());
                yIntervalSeries.add((double)time, (double)DefaultLoadTestModel.this.counter.averageScenarioDuration(scenario), (double)DefaultLoadTestModel.this.counter.minimumScenarioDuration(scenario), (double)DefaultLoadTestModel.this.counter.maximumScenarioDuration(scenario));
            }
            for (XYSeries xYSeries : DefaultLoadTestModel.this.failureSeries) {
                xYSeries.add((double)time, DefaultLoadTestModel.this.counter.scenarioFailureRate((String)((Object)xYSeries.getKey())));
            }
        }
    }

    private static final class DefaultApplicationRow
    implements LoadTestModel.ApplicationRow {
        private final LoadTest.ApplicationRunner applicationRunner;
        private final String user;
        private final LocalDateTime created;
        private final List<LoadTest.Scenario.Result> results;

        private DefaultApplicationRow(LoadTest.ApplicationRunner applicationRunner) {
            this.applicationRunner = applicationRunner;
            this.user = applicationRunner.user().username();
            this.created = applicationRunner.created();
            this.results = applicationRunner.results();
        }

        @Override
        public String name() {
            return this.applicationRunner.name();
        }

        @Override
        public String username() {
            return this.user;
        }

        @Override
        public LocalDateTime created() {
            return this.created;
        }

        @Override
        public List<LoadTest.Scenario.Result> results() {
            return this.results;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof DefaultApplicationRow)) {
                return false;
            }
            DefaultApplicationRow that = (DefaultApplicationRow)object;
            return this.applicationRunner == that.applicationRunner;
        }

        public int hashCode() {
            return Objects.hash(this.applicationRunner);
        }
    }

    private static final class TaskSchedulerController
    implements Consumer<Boolean> {
        private final TaskScheduler taskScheduler;

        private TaskSchedulerController(TaskScheduler taskScheduler) {
            this.taskScheduler = taskScheduler;
        }

        @Override
        public void accept(Boolean enabled) {
            if (enabled.booleanValue()) {
                this.taskScheduler.start();
            } else {
                this.taskScheduler.stop();
            }
        }
    }
}

