/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.tools.loadtest;

import is.codion.common.db.connection.ConnectionFactory;
import is.codion.common.db.database.Database;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.pool.ConnectionPoolFactory;
import is.codion.common.db.pool.ConnectionPoolWrapper;
import is.codion.common.model.loadtest.LoadTest;
import is.codion.common.user.User;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class QueryLoadTestModel {
    private static final int DEFAULT_MAXIMUM_THINK_TIME_MS = 500;
    private static final int DEFAULT_LOGIN_DELAY_FACTOR = 2;
    private static final int DEFAULT_BATCH_SIZE = 5;
    private final LoadTest<QueryApplication> loadTest;
    private final ConnectionPoolWrapper pool;

    public QueryLoadTestModel(Database database, User user, Collection<? extends LoadTest.Scenario<QueryApplication>> scenarios) throws DatabaseException {
        this.loadTest = LoadTest.builder(this::createApplication, this::disconnectApplication).user(user).scenarios(scenarios).minimumThinkTime(250).maximumThinkTime(500).loginDelayFactor(2).applicationBatchSize(5).build();
        ConnectionPoolFactory poolProvider = ConnectionPoolFactory.instance();
        this.pool = poolProvider.createConnectionPool((ConnectionFactory)database, user);
        this.loadTest.addShutdownListener(() -> ((ConnectionPoolWrapper)this.pool).close());
    }

    public LoadTest<QueryApplication> loadTest() {
        return this.loadTest;
    }

    public ConnectionPoolWrapper connectionPool() {
        return this.pool;
    }

    private void disconnectApplication(QueryApplication application) {
    }

    private QueryApplication createApplication(User user) {
        return new QueryApplication(this.pool);
    }

    public static final class QueryApplication {
        private final ConnectionPoolWrapper pool;

        private QueryApplication(ConnectionPoolWrapper pool) {
            this.pool = pool;
        }
    }

    public static class QueryPerformer
    implements LoadTest.Scenario.Performer<QueryApplication> {
        private final User user;
        private final String query;
        private final boolean transactional;

        public QueryPerformer(User user, String query) {
            this(user, query, false);
        }

        public QueryPerformer(User user, String query, boolean transactional) {
            this.user = user;
            this.query = query;
            this.transactional = transactional;
        }

        public void perform(QueryApplication application) throws Exception {
            Connection connection = null;
            CallableStatement statement = null;
            ResultSet resultSet = null;
            try {
                connection = application.pool.connection(this.user);
                statement = connection.prepareCall(this.query);
                this.setStatementParameters(statement);
                resultSet = statement.executeQuery();
                QueryPerformer.fetchResult(resultSet);
                if (this.transactional) {
                    connection.commit();
                }
            }
            catch (Exception e) {
                try {
                    if (this.transactional && connection != null) {
                        try {
                            connection.rollback();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    QueryPerformer.closeSilently(connection);
                    QueryPerformer.closeSilently(resultSet);
                    QueryPerformer.closeSilently(statement);
                    throw throwable;
                }
            }
            QueryPerformer.closeSilently(connection);
            QueryPerformer.closeSilently(resultSet);
            QueryPerformer.closeSilently(statement);
        }

        protected List<Object> parameters() {
            return Collections.emptyList();
        }

        private void setStatementParameters(PreparedStatement statement) throws SQLException {
            List<Object> parameters = this.parameters();
            int index = 1;
            for (Object parameter : parameters) {
                statement.setObject(index++, parameter);
            }
        }

        private static void fetchResult(ResultSet resultSet) throws SQLException {
            int columnCount = resultSet.getMetaData().getColumnCount();
            if (columnCount > 0) {
                while (resultSet.next()) {
                    for (int i = 1; i <= columnCount; ++i) {
                        resultSet.getObject(i);
                    }
                }
            }
        }

        private static void closeSilently(AutoCloseable closeable) {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

