/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.tools.loadtest;

import is.codion.common.model.loadtest.LoadTest;
import is.codion.common.state.State;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.model.tools.loadtest.DefaultLoadTestModel;
import java.time.LocalDateTime;
import java.util.List;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public interface LoadTestModel<T> {
    public LoadTest<T> loadTest();

    public FilteredTableModel<ApplicationRow, Integer> applicationTableModel();

    public int getUpdateInterval();

    public void setUpdateInterval(int var1);

    public State collectChartData();

    public State autoRefreshApplications();

    public void removeSelectedApplications();

    public void clearCharts();

    public int totalRunCount(String var1);

    public int successfulRunCount(String var1);

    public int unsuccessfulRunCount(String var1);

    public void resetRunCounter();

    public List<Exception> exceptions(String var1);

    public void clearExceptions(String var1);

    public IntervalXYDataset scenarioDurationDataset(String var1);

    public XYDataset thinkTimeDataset();

    public XYDataset numberOfApplicationsDataset();

    public XYDataset scenarioDataset();

    public XYDataset memoryUsageDataset();

    public XYDataset systemLoadDataset();

    public XYDataset scenarioFailureDataset();

    public static <T> LoadTestModel<T> loadTestModel(LoadTest<T> loadTest) {
        return new DefaultLoadTestModel<T>(loadTest);
    }

    public static interface ApplicationRow {
        public static final int NAME_INDEX = 0;
        public static final int USERNAME_INDEX = 1;
        public static final int SCENARIO_INDEX = 2;
        public static final int SUCCESSFUL_INDEX = 3;
        public static final int DURATION_INDEX = 4;
        public static final int EXCEPTION_INDEX = 5;
        public static final int MESSAGE_INDEX = 6;
        public static final int CREATED_INDEX = 7;

        public String name();

        public String username();

        public LocalDateTime created();

        public List<LoadTest.Scenario.Result> results();
    }
}

