/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.tools.randomizer;

import is.codion.swing.common.model.tools.randomizer.BoundedItemRandomizer;
import is.codion.swing.common.model.tools.randomizer.DefaultItemRandomizer;
import is.codion.swing.common.model.tools.randomizer.DefaultRandomItem;
import java.util.Collection;

public interface ItemRandomizer<T> {
    public int itemCount();

    public Collection<RandomItem<T>> items();

    public int weight(T var1);

    public void setWeight(T var1, int var2);

    public T randomItem();

    public double weightRatio(T var1);

    public void incrementWeight(T var1);

    public void decrementWeight(T var1);

    public boolean isItemEnabled(T var1);

    public void setItemEnabled(T var1, boolean var2);

    public static <T> ItemRandomizer<T> itemRandomizer(Collection<RandomItem<T>> items) {
        return new DefaultItemRandomizer<T>(items);
    }

    public static <T> ItemRandomizer<T> boundedItemRandomizer(Collection<T> items) {
        return new BoundedItemRandomizer<T>(items, 100);
    }

    public static <T> ItemRandomizer<T> boundedItemRandomizer(Collection<T> items, int maximumTotalWeights) {
        return new BoundedItemRandomizer<T>(items, maximumTotalWeights);
    }

    public static interface RandomItem<T> {
        public void incrementWeight();

        public void decrementWeight();

        public void setWeight(int var1);

        public int weight();

        public boolean isEnabled();

        public void setEnabled(boolean var1);

        public T item();

        public static <T> RandomItem<T> randomItem(T item, int weight) {
            return new DefaultRandomItem<T>(item, weight);
        }
    }
}

