/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.tools.randomizer;

import is.codion.swing.common.model.tools.randomizer.DefaultItemRandomizer;
import is.codion.swing.common.model.tools.randomizer.ItemRandomizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

final class BoundedItemRandomizer<T>
extends DefaultItemRandomizer<T> {
    private final Object lock = new Object();
    private final int maximumTotalWeight;
    private ItemRandomizer.RandomItem<T> lastAffected;

    BoundedItemRandomizer(Collection<T> items, int maximumTotalWeight) {
        super(BoundedItemRandomizer.initializeItems(items, maximumTotalWeight));
        this.maximumTotalWeight = maximumTotalWeight;
        this.lastAffected = (ItemRandomizer.RandomItem)this.items().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementWeight(T item) {
        Object object = this.lock;
        synchronized (object) {
            ItemRandomizer.RandomItem<T> randomItem = this.randomItem(item);
            if (randomItem.weight() >= this.maximumTotalWeight) {
                throw new IllegalStateException("Maximum weight reached");
            }
            this.decrementWeight(randomItem);
            this.randomItem(item).incrementWeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrementWeight(T item) {
        Object object = this.lock;
        synchronized (object) {
            ItemRandomizer.RandomItem<T> randomItem = this.randomItem(item);
            if (randomItem.weight() == 0) {
                throw new IllegalStateException("No weight to shed");
            }
            this.incrementWeight(randomItem);
            randomItem.decrementWeight();
        }
    }

    @Override
    public void setWeight(T item, int weight) {
        throw new UnsupportedOperationException("setWeight is not implemented in " + this.getClass().getSimpleName());
    }

    private static <T> Collection<ItemRandomizer.RandomItem<T>> initializeItems(Collection<T> items, int weightBounds) {
        if (weightBounds <= 0) {
            throw new IllegalArgumentException("Bounded weight must be a positive integer");
        }
        if (Objects.requireNonNull(items, "items").isEmpty()) {
            throw new IllegalArgumentException("Items must not be empty");
        }
        int rest = weightBounds % items.size();
        int amountEach = weightBounds / items.size();
        ArrayList<ItemRandomizer.RandomItem<T>> randomItems = new ArrayList<ItemRandomizer.RandomItem<T>>(items.size());
        Iterator<T> itemIterator = items.iterator();
        int i = 0;
        while (itemIterator.hasNext()) {
            randomItems.add(ItemRandomizer.RandomItem.randomItem(itemIterator.next(), i++ < items.size() - 1 ? amountEach : amountEach + rest));
        }
        return randomItems;
    }

    @Override
    private void incrementWeight(ItemRandomizer.RandomItem<?> exclude) {
        this.lastAffected = this.nextItem(exclude, false);
        this.lastAffected.incrementWeight();
    }

    @Override
    private void decrementWeight(ItemRandomizer.RandomItem<?> exclude) {
        this.lastAffected = this.nextItem(exclude, true);
        this.lastAffected.decrementWeight();
    }

    private ItemRandomizer.RandomItem<T> nextItem(ItemRandomizer.RandomItem<?> exclude, boolean nonEmpty) {
        int index = this.items().indexOf(this.lastAffected);
        Object item = null;
        while (item == null || item.equals(exclude) || (nonEmpty ? item.weight() == 0 : item.weight() == this.maximumTotalWeight)) {
            index = index == 0 ? this.items().size() - 1 : --index;
            item = (ItemRandomizer.RandomItem)this.items().get(index);
        }
        return item;
    }
}

