/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.tools.loadtest;

import is.codion.common.state.State;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.model.tools.loadtest.DefaultLoadTestModel;
import is.codion.swing.common.model.tools.loadtest.UsageScenario;
import is.codion.swing.common.model.tools.randomizer.ItemRandomizer;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public interface LoadTestModel<T> {
    public void shutdown();

    public Value<User> user();

    public FilteredTableModel<Application, Integer> applicationTableModel();

    public String title();

    public void setWeight(String var1, int var2);

    public boolean isScenarioEnabled(String var1);

    public void setScenarioEnabled(String var1, boolean var2);

    public Collection<String> usageScenarios();

    public UsageScenario<T> usageScenario(String var1);

    public int getUpdateInterval();

    public void setUpdateInterval(int var1);

    public void addShutdownListener(Runnable var1);

    public Value<Integer> applicationBatchSize();

    public State paused();

    public Value<Integer> maximumThinkTime();

    public Value<Integer> minimumThinkTime();

    public Value<Integer> loginDelayFactor();

    public State collectChartData();

    public State autoRefreshApplications();

    public ValueObserver<Integer> applicationCount();

    public void addApplicationBatch();

    public void removeApplicationBatch();

    public void removeSelectedApplications();

    public void clearCharts();

    public IntervalXYDataset scenarioDurationDataset(String var1);

    public XYDataset thinkTimeDataset();

    public XYDataset numberOfApplicationsDataset();

    public XYDataset usageScenarioDataset();

    public XYDataset memoryUsageDataset();

    public XYDataset systemLoadDataset();

    public XYDataset usageScenarioFailureDataset();

    public ItemRandomizer<UsageScenario<T>> scenarioChooser();

    public static <T> Builder<T> builder(Function<User, T> applicationFactory, Consumer<T> closeApplication) {
        return new DefaultLoadTestModel.DefaultBuilder<T>(applicationFactory, closeApplication);
    }

    public static interface Application {
        public static final int NAME_INDEX = 0;
        public static final int USERNAME_INDEX = 1;
        public static final int SCENARIO_INDEX = 2;
        public static final int SUCCESSFUL_INDEX = 3;
        public static final int DURATION_INDEX = 4;
        public static final int EXCEPTION_INDEX = 5;
        public static final int MESSAGE_INDEX = 6;
        public static final int CREATED_INDEX = 7;

        public String name();

        public String username();

        public String scenario();

        public Boolean successful();

        public Integer duration();

        public Throwable exception();

        public String message();

        public LocalDateTime created();
    }

    public static interface Builder<T> {
        public Builder<T> user(User var1);

        public Builder<T> minimumThinkTime(int var1);

        public Builder<T> maximumThinkTime(int var1);

        public Builder<T> loginDelayFactor(int var1);

        public Builder<T> applicationBatchSize(int var1);

        public Builder<T> usageScenarios(Collection<? extends UsageScenario<T>> var1);

        public Builder<T> titleFactory(Function<LoadTestModel<T>, String> var1);

        public LoadTestModel<T> build();
    }
}

