/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.tools.loadtest;

import com.sun.management.OperatingSystemMXBean;
import is.codion.common.Memory;
import is.codion.common.NullOrEmpty;
import is.codion.common.event.Event;
import is.codion.common.scheduler.TaskScheduler;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.user.User;
import is.codion.common.value.Value;
import is.codion.common.value.ValueObserver;
import is.codion.swing.common.model.component.table.FilteredTableColumn;
import is.codion.swing.common.model.component.table.FilteredTableModel;
import is.codion.swing.common.model.tools.loadtest.AbstractUsageScenario;
import is.codion.swing.common.model.tools.loadtest.LoadTestModel;
import is.codion.swing.common.model.tools.loadtest.UsageScenario;
import is.codion.swing.common.model.tools.randomizer.ItemRandomizer;
import java.lang.management.ManagementFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultLoadTestModel<T>
implements LoadTestModel<T> {
    public static final int DEFAULT_CHART_DATA_UPDATE_INTERVAL_MS = 2000;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLoadTestModel.class);
    private static final Random RANDOM = new Random();
    private static final double THOUSAND = 1000.0;
    private static final double HUNDRED = 100.0;
    private static final int MINIMUM_NUMBER_OF_THREADS = 12;
    private final Function<User, T> applicationFactory;
    private final Consumer<T> closeApplication;
    private final State paused = State.state();
    private final State collectChartData = State.state();
    private final State autoRefreshApplications = State.state((boolean)true);
    private final StateObserver chartUpdateSchedulerEnabled = State.and((StateObserver[])new StateObserver[]{this.paused.not(), this.collectChartData});
    private final StateObserver applicationsRefreshSchedulerEnabled = State.and((StateObserver[])new StateObserver[]{this.paused.not(), this.autoRefreshApplications});
    private final Value<Integer> loginDelayFactor;
    private final Value<Integer> applicationBatchSize;
    private final Value<Integer> maximumThinkTime;
    private final Value<Integer> minimumThinkTime;
    private final Value<Integer> applicationCount = Value.value((Object)0);
    private final Event<?> shutdownEvent = Event.event();
    private final Value<User> user;
    private final List<ApplicationRunner> applications = new ArrayList<ApplicationRunner>();
    private final FilteredTableModel<LoadTestModel.Application, Integer> applicationTableModel;
    private final Map<String, UsageScenario<T>> usageScenarios;
    private final ItemRandomizer<UsageScenario<T>> scenarioChooser;
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(Math.max(12, Runtime.getRuntime().availableProcessors() * 2));
    private final Counter counter = new Counter();
    private final TaskScheduler chartUpdateScheduler;
    private final TaskScheduler applicationsRefreshScheduler;
    private final XYSeries scenariosRunSeries = new XYSeries((Comparable)((Object)"Total"));
    private final XYSeries delayedScenarioRunsSeries = new XYSeries((Comparable)((Object)"Warn. time exceeded"));
    private final XYSeriesCollection scenarioFailureCollection = new XYSeriesCollection();
    private final XYSeries minimumThinkTimeSeries = new XYSeries((Comparable)((Object)"Minimum think time"));
    private final XYSeries maximumThinkTimeSeries = new XYSeries((Comparable)((Object)"Maximum think time"));
    private final XYSeriesCollection thinkTimeCollection = new XYSeriesCollection();
    private final XYSeries numberOfApplicationsSeries = new XYSeries((Comparable)((Object)"Application count"));
    private final XYSeriesCollection numberOfApplicationsCollection = new XYSeriesCollection();
    private final XYSeriesCollection usageScenarioCollection = new XYSeriesCollection();
    private final XYSeries allocatedMemoryCollection = new XYSeries((Comparable)((Object)"Allocated"));
    private final XYSeries usedMemoryCollection = new XYSeries((Comparable)((Object)"Used"));
    private final XYSeries maxMemoryCollection = new XYSeries((Comparable)((Object)"Available"));
    private final XYSeriesCollection memoryUsageCollection = new XYSeriesCollection();
    private final Collection<XYSeries> usageSeries = new ArrayList<XYSeries>();
    private final Map<String, YIntervalSeries> durationSeries = new HashMap<String, YIntervalSeries>();
    private final Collection<XYSeries> failureSeries = new ArrayList<XYSeries>();
    private final XYSeries systemLoadSeries = new XYSeries((Comparable)((Object)"System Load"));
    private final XYSeries processLoadSeries = new XYSeries((Comparable)((Object)"Process Load"));
    private final XYSeriesCollection systemLoadCollection = new XYSeriesCollection();
    private final Function<LoadTestModel<T>, String> titleFactory;

    DefaultLoadTestModel(DefaultBuilder<T> builder) {
        this.applicationFactory = builder.applicationFactory;
        this.closeApplication = builder.closeApplication;
        this.titleFactory = builder.titleFactory;
        this.applicationTableModel = FilteredTableModel.builder(DefaultLoadTestModel::createApplicationTableModelColumns, (FilteredTableModel.ColumnValueProvider)new ApplicationColumnValueProvider()).itemSupplier((Supplier)new ApplicationItemSupplier()).build();
        this.user = Value.value((Object)builder.user, (Object)builder.user);
        this.loginDelayFactor = Value.value((Object)builder.loginDelayFactor, (Object)builder.loginDelayFactor);
        this.applicationBatchSize = Value.value((Object)builder.applicationBatchSize, (Object)builder.applicationBatchSize);
        this.minimumThinkTime = Value.value((Object)builder.minimumThinkTime, (Object)builder.minimumThinkTime);
        this.maximumThinkTime = Value.value((Object)builder.maximumThinkTime, (Object)builder.maximumThinkTime);
        this.loginDelayFactor.addValidator((Value.Validator)new MinimumValidator(1));
        this.applicationBatchSize.addValidator((Value.Validator)new MinimumValidator(1));
        this.minimumThinkTime.addValidator((Value.Validator)new MinimumThinkTimeValidator());
        this.maximumThinkTime.addValidator((Value.Validator)new MaximumThinkTimeValidator());
        this.usageScenarios = Collections.unmodifiableMap(builder.usageScenarios.stream().collect(Collectors.toMap(UsageScenario::name, Function.identity())));
        this.scenarioChooser = this.createScenarioChooser();
        this.initializeChartModels();
        this.chartUpdateScheduler = TaskScheduler.builder((Runnable)new ChartUpdateTask()).interval(2000, TimeUnit.MILLISECONDS).build();
        this.applicationsRefreshScheduler = TaskScheduler.builder(() -> this.applicationTableModel.refresh()).interval(2000, TimeUnit.MILLISECONDS).start();
        this.bindEvents();
    }

    @Override
    public Value<User> user() {
        return this.user;
    }

    @Override
    public FilteredTableModel<LoadTestModel.Application, Integer> applicationTableModel() {
        return this.applicationTableModel;
    }

    @Override
    public String title() {
        return this.titleFactory.apply(this);
    }

    @Override
    public UsageScenario<T> usageScenario(String usageScenarioName) {
        UsageScenario<T> scenario = this.usageScenarios.get(Objects.requireNonNull(usageScenarioName));
        if (scenario == null) {
            throw new IllegalArgumentException("UsageScenario not found: " + usageScenarioName);
        }
        return scenario;
    }

    @Override
    public Collection<String> usageScenarios() {
        return this.usageScenarios.keySet();
    }

    @Override
    public void setWeight(String scenarioName, int weight) {
        this.scenarioChooser.setWeight(this.usageScenario(scenarioName), weight);
    }

    @Override
    public boolean isScenarioEnabled(String scenarioName) {
        return this.scenarioChooser.isItemEnabled(this.usageScenario(scenarioName));
    }

    @Override
    public void setScenarioEnabled(String scenarioName, boolean enabled) {
        this.scenarioChooser.setItemEnabled(this.usageScenario(scenarioName), enabled);
    }

    @Override
    public ItemRandomizer<UsageScenario<T>> scenarioChooser() {
        return this.scenarioChooser;
    }

    @Override
    public IntervalXYDataset scenarioDurationDataset(String name) {
        YIntervalSeriesCollection scenarioDurationCollection = new YIntervalSeriesCollection();
        scenarioDurationCollection.addSeries(this.durationSeries.get(name));
        return scenarioDurationCollection;
    }

    @Override
    public XYDataset thinkTimeDataset() {
        return this.thinkTimeCollection;
    }

    @Override
    public XYDataset numberOfApplicationsDataset() {
        return this.numberOfApplicationsCollection;
    }

    @Override
    public XYDataset usageScenarioDataset() {
        return this.usageScenarioCollection;
    }

    @Override
    public XYDataset usageScenarioFailureDataset() {
        return this.scenarioFailureCollection;
    }

    @Override
    public XYDataset memoryUsageDataset() {
        return this.memoryUsageCollection;
    }

    @Override
    public XYDataset systemLoadDataset() {
        return this.systemLoadCollection;
    }

    @Override
    public void clearCharts() {
        this.scenariosRunSeries.clear();
        this.delayedScenarioRunsSeries.clear();
        this.minimumThinkTimeSeries.clear();
        this.maximumThinkTimeSeries.clear();
        this.numberOfApplicationsSeries.clear();
        this.allocatedMemoryCollection.clear();
        this.usedMemoryCollection.clear();
        this.maxMemoryCollection.clear();
        this.systemLoadSeries.clear();
        this.processLoadSeries.clear();
        for (XYSeries xYSeries : this.usageSeries) {
            xYSeries.clear();
        }
        for (XYSeries xYSeries : this.failureSeries) {
            xYSeries.clear();
        }
        for (YIntervalSeries yIntervalSeries : this.durationSeries.values()) {
            yIntervalSeries.clear();
        }
    }

    @Override
    public int getUpdateInterval() {
        return (Integer)this.chartUpdateScheduler.interval().get();
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        this.chartUpdateScheduler.interval().set((Object)updateInterval);
    }

    @Override
    public Value<Integer> applicationBatchSize() {
        return this.applicationBatchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationBatch() {
        List<ApplicationRunner> list = this.applications;
        synchronized (list) {
            int batchSize = (Integer)this.applicationBatchSize.get();
            for (int i = 0; i < batchSize; ++i) {
                ApplicationRunner applicationRunner = new ApplicationRunner((User)this.user.get(), this.applicationFactory);
                List<ApplicationRunner> list2 = this.applications;
                synchronized (list2) {
                    this.applications.add(applicationRunner);
                    this.applicationCount.set((Object)this.applications.size());
                }
                this.scheduledExecutor.schedule(applicationRunner, (long)this.initialDelay(), TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationBatch() {
        List<ApplicationRunner> list = this.applications;
        synchronized (list) {
            if (!this.applications.isEmpty()) {
                int batchSize = (Integer)this.applicationBatchSize.get();
                List<ApplicationRunner> toStop = this.applications.stream().filter(applicationRunner -> !applicationRunner.stopped.get()).limit(batchSize).collect(Collectors.toList());
                toStop.forEach(this::stop);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSelectedApplications() {
        List<ApplicationRunner> list = this.applications;
        synchronized (list) {
            List applicationRunners = this.applicationTableModel.selectionModel().getSelectedItems().stream().map(DefaultApplication.class::cast).map(application -> application.applicationRunner).collect(Collectors.toList());
            if (!applicationRunners.isEmpty()) {
                List<ApplicationRunner> toStop = this.applications.stream().filter(applicationRunner -> !applicationRunner.stopped.get()).filter(applicationRunners::contains).collect(Collectors.toList());
                toStop.forEach(this::stop);
            }
        }
    }

    @Override
    public State paused() {
        return this.paused;
    }

    @Override
    public State collectChartData() {
        return this.collectChartData;
    }

    @Override
    public State autoRefreshApplications() {
        return this.autoRefreshApplications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.applicationsRefreshScheduler.stop();
        this.chartUpdateScheduler.stop();
        List<ApplicationRunner> list = this.applications;
        synchronized (list) {
            new ArrayList<ApplicationRunner>(this.applications).forEach(this::stop);
        }
        this.scheduledExecutor.shutdown();
        try {
            this.scheduledExecutor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.shutdownEvent.run();
    }

    @Override
    public Value<Integer> maximumThinkTime() {
        return this.maximumThinkTime;
    }

    @Override
    public Value<Integer> minimumThinkTime() {
        return this.minimumThinkTime;
    }

    @Override
    public Value<Integer> loginDelayFactor() {
        return this.loginDelayFactor;
    }

    @Override
    public ValueObserver<Integer> applicationCount() {
        return this.applicationCount.observer();
    }

    @Override
    public void addShutdownListener(Runnable listener) {
        this.shutdownEvent.addListener(listener);
    }

    private int initialDelay() {
        int time = (Integer)this.maximumThinkTime.get() - (Integer)this.minimumThinkTime.get();
        return time > 0 ? RANDOM.nextInt(time * (Integer)this.loginDelayFactor.get()) + (Integer)this.minimumThinkTime.get() : (Integer)this.minimumThinkTime.get();
    }

    private ItemRandomizer<UsageScenario<T>> createScenarioChooser() {
        return ItemRandomizer.itemRandomizer(this.usageScenarios.values().stream().map(scenario -> ItemRandomizer.RandomItem.randomItem(scenario, scenario.defaultWeight())).collect(Collectors.toList()));
    }

    private void initializeChartModels() {
        this.thinkTimeCollection.addSeries(this.minimumThinkTimeSeries);
        this.thinkTimeCollection.addSeries(this.maximumThinkTimeSeries);
        this.numberOfApplicationsCollection.addSeries(this.numberOfApplicationsSeries);
        this.memoryUsageCollection.addSeries(this.maxMemoryCollection);
        this.memoryUsageCollection.addSeries(this.allocatedMemoryCollection);
        this.memoryUsageCollection.addSeries(this.usedMemoryCollection);
        this.systemLoadCollection.addSeries(this.systemLoadSeries);
        this.systemLoadCollection.addSeries(this.processLoadSeries);
        this.usageScenarioCollection.addSeries(this.scenariosRunSeries);
        for (UsageScenario<T> usageScenario : this.usageScenarios.values()) {
            XYSeries series = new XYSeries((Comparable)((Object)usageScenario.name()));
            this.usageScenarioCollection.addSeries(series);
            this.usageSeries.add(series);
            YIntervalSeries avgDurSeries = new YIntervalSeries((Comparable)((Object)usageScenario.name()));
            this.durationSeries.put(usageScenario.name(), avgDurSeries);
            XYSeries failSeries = new XYSeries((Comparable)((Object)usageScenario.name()));
            this.scenarioFailureCollection.addSeries(failSeries);
            this.failureSeries.add(failSeries);
        }
        this.usageScenarioCollection.addSeries(this.delayedScenarioRunsSeries);
    }

    private void bindEvents() {
        this.chartUpdateSchedulerEnabled.addDataListener((Consumer)new TaskSchedulerController(this.chartUpdateScheduler));
        this.applicationsRefreshSchedulerEnabled.addDataListener((Consumer)new TaskSchedulerController(this.applicationsRefreshScheduler));
    }

    private void stop(ApplicationRunner applicationRunner) {
        applicationRunner.stopped.set(true);
        this.applications.remove(applicationRunner);
        this.applicationCount.set((Object)this.applications.size());
    }

    private static List<FilteredTableColumn<Integer>> createApplicationTableModelColumns() {
        return Arrays.asList(FilteredTableColumn.builder((int)0).headerValue((Object)"Name").columnClass(String.class).build(), FilteredTableColumn.builder((int)1).headerValue((Object)"User").columnClass(String.class).build(), FilteredTableColumn.builder((int)2).headerValue((Object)"Scenario").columnClass(String.class).build(), FilteredTableColumn.builder((int)3).headerValue((Object)"Success").columnClass(Boolean.class).build(), FilteredTableColumn.builder((int)4).headerValue((Object)"Duration (\u03bcs)").columnClass(Integer.class).build(), FilteredTableColumn.builder((int)5).headerValue((Object)"Exception").columnClass(Throwable.class).build(), FilteredTableColumn.builder((int)6).headerValue((Object)"Message").columnClass(String.class).build(), FilteredTableColumn.builder((int)7).headerValue((Object)"Created").columnClass(LocalDateTime.class).build());
    }

    private static double systemCpuLoad() {
        return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getSystemCpuLoad();
    }

    private static double processCpuLoad() {
        return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getProcessCpuLoad();
    }

    private final class Counter {
        private static final int UPDATE_INTERVAL = 5;
        private final Map<String, Integer> usageScenarioRates = new HashMap<String, Integer>();
        private final Map<String, Integer> usageScenarioAvgDurations = new HashMap<String, Integer>();
        private final Map<String, Integer> usageScenarioMaxDurations = new HashMap<String, Integer>();
        private final Map<String, Integer> usageScenarioMinDurations = new HashMap<String, Integer>();
        private final Map<String, Integer> usageScenarioFailures = new HashMap<String, Integer>();
        private final Map<String, Collection<Integer>> scenarioDurations = new HashMap<String, Collection<Integer>>();
        private double workRequestsPerSecond = 0.0;
        private int workRequestCounter = 0;
        private int delayedWorkRequestsPerSecond = 0;
        private int delayedWorkRequestCounter = 0;
        private long time = System.currentTimeMillis();

        private Counter() {
        }

        private double workRequestsPerSecond() {
            return this.workRequestsPerSecond;
        }

        private int delayedWorkRequestsPerSecond() {
            return this.delayedWorkRequestsPerSecond;
        }

        private int minimumScenarioDuration(String scenarioName) {
            if (!this.usageScenarioMinDurations.containsKey(scenarioName)) {
                return 0;
            }
            return this.usageScenarioMinDurations.get(scenarioName);
        }

        private int maximumScenarioDuration(String scenarioName) {
            if (!this.usageScenarioMaxDurations.containsKey(scenarioName)) {
                return 0;
            }
            return this.usageScenarioMaxDurations.get(scenarioName);
        }

        private int averageScenarioDuration(String scenarioName) {
            if (!this.usageScenarioAvgDurations.containsKey(scenarioName)) {
                return 0;
            }
            return this.usageScenarioAvgDurations.get(scenarioName);
        }

        private double scenarioFailureRate(String scenarioName) {
            if (!this.usageScenarioFailures.containsKey(scenarioName)) {
                return 0.0;
            }
            return this.usageScenarioFailures.get(scenarioName).intValue();
        }

        private int scenarioRate(String scenarioName) {
            if (!this.usageScenarioRates.containsKey(scenarioName)) {
                return 0;
            }
            return this.usageScenarioRates.get(scenarioName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addScenarioDuration(UsageScenario<T> scenario, int duration) {
            Map<String, Collection<Integer>> map = this.scenarioDurations;
            synchronized (map) {
                this.scenarioDurations.computeIfAbsent(scenario.name(), scenarioName -> new ArrayList()).add(duration);
                ++this.workRequestCounter;
                if (scenario.maximumTime() > 0 && duration > scenario.maximumTime()) {
                    ++this.delayedWorkRequestCounter;
                }
            }
        }

        private void updateRequestsPerSecond() {
            long current = System.currentTimeMillis();
            double elapsedSeconds = (double)(current - this.time) / 1000.0;
            if (elapsedSeconds > 5.0) {
                this.usageScenarioAvgDurations.clear();
                this.usageScenarioMinDurations.clear();
                this.usageScenarioMaxDurations.clear();
                this.workRequestsPerSecond = (double)this.workRequestCounter / elapsedSeconds;
                this.delayedWorkRequestsPerSecond = (int)((double)this.delayedWorkRequestCounter / elapsedSeconds);
                for (UsageScenario scenario : DefaultLoadTestModel.this.usageScenarios.values()) {
                    this.usageScenarioRates.put(scenario.name(), (int)((double)scenario.totalRunCount() / elapsedSeconds));
                    this.usageScenarioFailures.put(scenario.name(), scenario.unsuccessfulRunCount());
                    this.calculateScenarioDuration(scenario);
                }
                this.resetCounters();
                this.time = current;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateScenarioDuration(UsageScenario<T> scenario) {
            Map<String, Collection<Integer>> map = this.scenarioDurations;
            synchronized (map) {
                Collection<Integer> durations = this.scenarioDurations.get(scenario.name());
                if (!NullOrEmpty.nullOrEmpty(durations)) {
                    int totalDuration = 0;
                    int minDuration = -1;
                    int maxDuration = -1;
                    for (Integer duration : durations) {
                        totalDuration += duration.intValue();
                        if (minDuration == -1) {
                            minDuration = duration;
                            maxDuration = duration;
                            continue;
                        }
                        minDuration = Math.min(minDuration, duration);
                        maxDuration = Math.max(maxDuration, duration);
                    }
                    this.usageScenarioAvgDurations.put(scenario.name(), totalDuration / durations.size());
                    this.usageScenarioMinDurations.put(scenario.name(), minDuration);
                    this.usageScenarioMaxDurations.put(scenario.name(), maxDuration);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetCounters() {
            for (UsageScenario scenario : DefaultLoadTestModel.this.usageScenarios.values()) {
                scenario.resetRunCount();
            }
            this.workRequestCounter = 0;
            this.delayedWorkRequestCounter = 0;
            Map<String, Collection<Integer>> map = this.scenarioDurations;
            synchronized (map) {
                this.scenarioDurations.clear();
            }
        }
    }

    static final class DefaultBuilder<T>
    implements LoadTestModel.Builder<T> {
        private final Function<User, T> applicationFactory;
        private final List<UsageScenario<T>> usageScenarios = new ArrayList<UsageScenario<T>>();
        private final Consumer<T> closeApplication;
        private User user;
        private int minimumThinkTime = 2500;
        private int maximumThinkTime = 5000;
        private int loginDelayFactor = 2;
        private int applicationBatchSize = 10;
        private Function<LoadTestModel<T>, String> titleFactory = new DefaultTitleFactory();

        DefaultBuilder(Function<User, T> applicationFactory, Consumer<T> closeApplication) {
            this.applicationFactory = Objects.requireNonNull(applicationFactory);
            this.closeApplication = Objects.requireNonNull(closeApplication);
        }

        @Override
        public LoadTestModel.Builder<T> user(User user) {
            this.user = user;
            return this;
        }

        @Override
        public LoadTestModel.Builder<T> minimumThinkTime(int minimumThinkTime) {
            if (minimumThinkTime <= 0) {
                throw new IllegalArgumentException("Minimum think time must be a positive integer");
            }
            if (minimumThinkTime > this.maximumThinkTime) {
                throw new IllegalArgumentException("Minimum think time must be less than maximum think time");
            }
            this.minimumThinkTime = minimumThinkTime;
            return this;
        }

        @Override
        public LoadTestModel.Builder<T> maximumThinkTime(int maximumThinkTime) {
            if (maximumThinkTime <= 0) {
                throw new IllegalArgumentException("Maximum think time must be a positive integer");
            }
            if (maximumThinkTime < this.minimumThinkTime) {
                throw new IllegalArgumentException("Maximum think time must be greater than than minimum think time");
            }
            this.maximumThinkTime = maximumThinkTime;
            return this;
        }

        @Override
        public LoadTestModel.Builder<T> loginDelayFactor(int loginDelayFactor) {
            if (loginDelayFactor < 1) {
                throw new IllegalArgumentException("Login delay factor must be greatar than or equal to one");
            }
            this.loginDelayFactor = loginDelayFactor;
            return this;
        }

        @Override
        public LoadTestModel.Builder<T> applicationBatchSize(int applicationBatchSize) {
            if (this.loginDelayFactor < 1) {
                throw new IllegalArgumentException("Application batch size must be greatar than or equal to one");
            }
            this.applicationBatchSize = applicationBatchSize;
            return this;
        }

        @Override
        public LoadTestModel.Builder<T> usageScenarios(Collection<? extends UsageScenario<T>> usageScenarios) {
            this.usageScenarios.addAll(usageScenarios);
            return this;
        }

        @Override
        public LoadTestModel.Builder<T> titleFactory(Function<LoadTestModel<T>, String> titleFactory) {
            this.titleFactory = Objects.requireNonNull(titleFactory);
            return this;
        }

        @Override
        public LoadTestModel<T> build() {
            return new DefaultLoadTestModel(this);
        }

        private static final class DefaultTitleFactory<T>
        implements Function<LoadTestModel<T>, String> {
            private DefaultTitleFactory() {
            }

            @Override
            public String apply(LoadTestModel<T> loadTest) {
                return loadTest.getClass().getSimpleName();
            }
        }
    }

    private static final class ApplicationColumnValueProvider
    implements FilteredTableModel.ColumnValueProvider<LoadTestModel.Application, Integer> {
        private ApplicationColumnValueProvider() {
        }

        public Object value(LoadTestModel.Application application, Integer columnIdentifier) {
            switch (columnIdentifier) {
                case 0: {
                    return application.name();
                }
                case 1: {
                    return application.username();
                }
                case 2: {
                    return application.scenario();
                }
                case 3: {
                    return application.successful();
                }
                case 4: {
                    return application.duration();
                }
                case 5: {
                    return application.exception();
                }
                case 6: {
                    return application.message();
                }
                case 7: {
                    return application.created();
                }
            }
            throw new IllegalArgumentException("Unknown column: " + columnIdentifier);
        }
    }

    private final class ApplicationItemSupplier
    implements Supplier<Collection<LoadTestModel.Application>> {
        private ApplicationItemSupplier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<LoadTestModel.Application> get() {
            List<ApplicationRunner> list = DefaultLoadTestModel.this.applications;
            synchronized (list) {
                return DefaultLoadTestModel.this.applications.stream().map(this::toApplication).collect(Collectors.toList());
            }
        }

        private LoadTestModel.Application toApplication(ApplicationRunner applicationRunner) {
            return new DefaultApplication(applicationRunner);
        }
    }

    private static class MinimumValidator
    implements Value.Validator<Integer> {
        private final int minimumValue;

        private MinimumValidator(int minimumValue) {
            this.minimumValue = minimumValue;
        }

        public void validate(Integer value) {
            if (value == null || value < this.minimumValue) {
                throw new IllegalArgumentException("Value must be larger than: " + this.minimumValue);
            }
        }
    }

    private final class MinimumThinkTimeValidator
    extends MinimumValidator {
        private MinimumThinkTimeValidator() {
            super(0);
        }

        @Override
        public void validate(Integer value) {
            super.validate(value);
            if (value > (Integer)DefaultLoadTestModel.this.maximumThinkTime.get()) {
                throw new IllegalArgumentException("Minimum think time must be equal to or below maximum think time");
            }
        }
    }

    private final class MaximumThinkTimeValidator
    extends MinimumValidator {
        private MaximumThinkTimeValidator() {
            super(0);
        }

        @Override
        public void validate(Integer value) {
            super.validate(value);
            if (value < (Integer)DefaultLoadTestModel.this.minimumThinkTime.get()) {
                throw new IllegalArgumentException("Maximum think time must be equal to or exceed minimum think time");
            }
        }
    }

    private final class ChartUpdateTask
    implements Runnable {
        private ChartUpdateTask() {
        }

        @Override
        public void run() {
            DefaultLoadTestModel.this.counter.updateRequestsPerSecond();
            this.updateChartData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateChartData() {
            long time = System.currentTimeMillis();
            DefaultLoadTestModel.this.delayedScenarioRunsSeries.add((double)time, (double)DefaultLoadTestModel.this.counter.delayedWorkRequestsPerSecond());
            DefaultLoadTestModel.this.minimumThinkTimeSeries.add((double)time, (Number)DefaultLoadTestModel.this.minimumThinkTime.get());
            DefaultLoadTestModel.this.maximumThinkTimeSeries.add((double)time, (Number)DefaultLoadTestModel.this.maximumThinkTime.get());
            Iterator<YIntervalSeries> iterator = DefaultLoadTestModel.this.applications;
            synchronized (iterator) {
                DefaultLoadTestModel.this.numberOfApplicationsSeries.add((double)time, (double)DefaultLoadTestModel.this.applications.size());
            }
            DefaultLoadTestModel.this.allocatedMemoryCollection.add((double)time, (double)Memory.allocatedMemory() / 1000.0);
            DefaultLoadTestModel.this.usedMemoryCollection.add((double)time, (double)Memory.usedMemory() / 1000.0);
            DefaultLoadTestModel.this.maxMemoryCollection.add((double)time, (double)Memory.maxMemory() / 1000.0);
            DefaultLoadTestModel.this.systemLoadSeries.add((double)time, DefaultLoadTestModel.systemCpuLoad() * 100.0);
            DefaultLoadTestModel.this.processLoadSeries.add((double)time, DefaultLoadTestModel.processCpuLoad() * 100.0);
            DefaultLoadTestModel.this.scenariosRunSeries.add((double)time, DefaultLoadTestModel.this.counter.workRequestsPerSecond());
            for (XYSeries xYSeries : DefaultLoadTestModel.this.usageSeries) {
                xYSeries.add((double)time, (double)DefaultLoadTestModel.this.counter.scenarioRate((String)((Object)xYSeries.getKey())));
            }
            for (YIntervalSeries yIntervalSeries : DefaultLoadTestModel.this.durationSeries.values()) {
                String scenario = (String)((Object)yIntervalSeries.getKey());
                yIntervalSeries.add((double)time, (double)DefaultLoadTestModel.this.counter.averageScenarioDuration(scenario), (double)DefaultLoadTestModel.this.counter.minimumScenarioDuration(scenario), (double)DefaultLoadTestModel.this.counter.maximumScenarioDuration(scenario));
            }
            for (XYSeries xYSeries : DefaultLoadTestModel.this.failureSeries) {
                xYSeries.add((double)time, DefaultLoadTestModel.this.counter.scenarioFailureRate((String)((Object)xYSeries.getKey())));
            }
        }
    }

    private final class ApplicationRunner
    implements Runnable {
        private static final int MAX_RESULTS = 20;
        private final User user;
        private final Function<User, T> applicationFactory;
        private final List<UsageScenario.RunResult> runResults = new ArrayList<UsageScenario.RunResult>();
        private final AtomicBoolean stopped = new AtomicBoolean();
        private final LocalDateTime created = LocalDateTime.now();
        private T application;

        private ApplicationRunner(User user, Function<User, T> applicationFactory) {
            this.user = user;
            this.applicationFactory = applicationFactory;
        }

        @Override
        public void run() {
            if (this.stopped.get()) {
                this.cleanupOnStop();
                return;
            }
            try {
                if (!((Boolean)DefaultLoadTestModel.this.paused.get()).booleanValue()) {
                    if (this.application == null && !this.stopped.get()) {
                        this.application = this.initializeApplication();
                    } else if (!this.stopped.get()) {
                        this.runScenario(this.application, DefaultLoadTestModel.this.scenarioChooser.randomItem());
                    }
                }
                if (this.stopped.get()) {
                    this.cleanupOnStop();
                    return;
                }
                DefaultLoadTestModel.this.scheduledExecutor.schedule(this, (long)this.thinkTime(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.debug("Exception during run " + this.application, (Throwable)e);
            }
        }

        private void cleanupOnStop() {
            if (this.application != null) {
                DefaultLoadTestModel.this.closeApplication.accept(this.application);
                LOG.debug("LoadTestModel disconnected application: {}", this.application);
                this.application = null;
            }
        }

        private T initializeApplication() {
            try {
                long startTime = System.nanoTime();
                Object application = this.applicationFactory.apply(this.user);
                int duration = (int)TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime);
                this.addRunResult(new AbstractUsageScenario.DefaultRunResult("Initialization", duration, null));
                LOG.debug("LoadTestModel initialized application: {}", application);
                return application;
            }
            catch (Exception e) {
                this.addRunResult(new AbstractUsageScenario.DefaultRunResult("Initialization", -1, e));
                return null;
            }
        }

        private void runScenario(T application, UsageScenario<T> scenario) {
            UsageScenario.RunResult runResult = scenario.run(application);
            DefaultLoadTestModel.this.counter.addScenarioDuration(scenario, runResult.duration());
            this.addRunResult(runResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addRunResult(UsageScenario.RunResult runResult) {
            List<UsageScenario.RunResult> list = this.runResults;
            synchronized (list) {
                this.runResults.add(runResult);
                if (this.runResults.size() > 20) {
                    this.runResults.remove(0);
                }
            }
        }

        private int thinkTime() {
            int time = (Integer)DefaultLoadTestModel.this.maximumThinkTime.get() - (Integer)DefaultLoadTestModel.this.minimumThinkTime.get();
            return time > 0 ? RANDOM.nextInt(time) + (Integer)DefaultLoadTestModel.this.minimumThinkTime.get() : (Integer)DefaultLoadTestModel.this.minimumThinkTime.get();
        }

        private LocalDateTime created() {
            return this.created;
        }
    }

    private static final class DefaultApplication
    implements LoadTestModel.Application {
        private final ApplicationRunner applicationRunner;
        private final List<UsageScenario.RunResult> runResults;
        private final String user;
        private final String scenario;
        private final Boolean successful;
        private final int duration;
        private final Throwable exception;
        private final LocalDateTime created;

        private DefaultApplication(ApplicationRunner applicationRunner) {
            this.applicationRunner = applicationRunner;
            this.runResults = applicationRunner.runResults == null ? Collections.emptyList() : applicationRunner.runResults;
            UsageScenario.RunResult runResult = this.runResults.isEmpty() ? null : this.runResults.get(this.runResults.size() - 1);
            this.user = applicationRunner.user.username();
            this.scenario = runResult == null ? null : runResult.scenario();
            this.successful = runResult == null ? null : Boolean.valueOf(runResult.successful());
            this.duration = runResult == null ? -1 : runResult.duration();
            this.exception = runResult == null ? null : (Throwable)runResult.exception().orElse(null);
            this.created = applicationRunner.created();
        }

        @Override
        public String name() {
            return this.applicationRunner.application == null ? "Not initialized" : this.applicationRunner.application.toString();
        }

        @Override
        public String username() {
            return this.user;
        }

        @Override
        public String scenario() {
            return this.scenario;
        }

        @Override
        public Boolean successful() {
            return this.successful;
        }

        @Override
        public Integer duration() {
            return this.duration == -1 ? null : Integer.valueOf(this.duration);
        }

        @Override
        public Throwable exception() {
            return this.exception;
        }

        @Override
        public String message() {
            return this.exception == null ? null : this.exception.getMessage();
        }

        @Override
        public LocalDateTime created() {
            return this.created;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof DefaultApplication)) {
                return false;
            }
            DefaultApplication that = (DefaultApplication)object;
            return Objects.equals(this.applicationRunner, that.applicationRunner);
        }

        public int hashCode() {
            return Objects.hash(this.applicationRunner);
        }
    }

    private static final class TaskSchedulerController
    implements Consumer<Boolean> {
        private final TaskScheduler taskScheduler;

        private TaskSchedulerController(TaskScheduler taskScheduler) {
            this.taskScheduler = taskScheduler;
        }

        @Override
        public void accept(Boolean enabled) {
            if (enabled.booleanValue()) {
                this.taskScheduler.start();
            } else {
                this.taskScheduler.stop();
            }
        }
    }
}

