/*
 * Decompiled with CFR 0.152.
 */
package is.codion.swing.common.model.tools.loadtest;

import is.codion.swing.common.model.tools.loadtest.UsageScenario;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractUsageScenario<T>
implements UsageScenario<T> {
    private static final int MAXIMUM_EXCEPTIONS = 50;
    private final String name;
    private final int maximumTime;
    private final AtomicInteger successfulRunCount = new AtomicInteger();
    private final AtomicInteger unsuccessfulRunCount = new AtomicInteger();
    private final LinkedList<Throwable> exceptions = new LinkedList();

    protected AbstractUsageScenario() {
        this.name = this.getClass().getSimpleName();
        this.maximumTime = 0;
    }

    protected AbstractUsageScenario(String name) {
        this(name, 0);
    }

    protected AbstractUsageScenario(String name, int maximumTimeMs) {
        this.name = Objects.requireNonNull(name, "name");
        if (maximumTimeMs < 0) {
            throw new IllegalArgumentException("Maximum time in ms must be a positive integer");
        }
        this.maximumTime = maximumTimeMs;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final int maximumTime() {
        return this.maximumTime;
    }

    @Override
    public final int successfulRunCount() {
        return this.successfulRunCount.get();
    }

    @Override
    public final int unsuccessfulRunCount() {
        return this.unsuccessfulRunCount.get();
    }

    @Override
    public final int totalRunCount() {
        return this.successfulRunCount.get() + this.unsuccessfulRunCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<Throwable> exceptions() {
        LinkedList<Throwable> linkedList = this.exceptions;
        synchronized (linkedList) {
            return new ArrayList<Throwable>(this.exceptions);
        }
    }

    @Override
    public final void resetRunCount() {
        this.successfulRunCount.set(0);
        this.unsuccessfulRunCount.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearExceptions() {
        LinkedList<Throwable> linkedList = this.exceptions;
        synchronized (linkedList) {
            this.exceptions.clear();
        }
    }

    public final String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final UsageScenario.RunResult run(T application) {
        if (application == null) {
            throw new IllegalArgumentException("Can not run without an application");
        }
        try {
            this.prepare(application);
            long startTime = System.nanoTime();
            this.perform(application);
            this.successfulRunCount.incrementAndGet();
            UsageScenario.RunResult runResult = UsageScenario.RunResult.success(this.name, (int)TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime));
            return runResult;
        }
        catch (Throwable e) {
            this.unsuccessfulRunCount.incrementAndGet();
            Object object = this.exceptions;
            synchronized (object) {
                this.exceptions.add(e);
                if (this.exceptions.size() > 50) {
                    this.exceptions.removeFirst();
                }
            }
            object = UsageScenario.RunResult.failure(this.name, e);
            return object;
        }
        finally {
            this.cleanup(application);
        }
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        return obj instanceof UsageScenario && ((UsageScenario)obj).name().equals(this.name);
    }

    @Override
    public int defaultWeight() {
        return 1;
    }

    protected abstract void perform(T var1) throws Exception;

    protected void prepare(T application) {
    }

    protected void cleanup(T application) {
    }

    static final class DefaultRunResult
    implements UsageScenario.RunResult {
        private final String scenario;
        private final int duration;
        private final Throwable exception;

        DefaultRunResult(String scenario, int duration, Throwable exception) {
            this.scenario = scenario;
            this.duration = duration;
            this.exception = exception;
        }

        @Override
        public int duration() {
            return this.duration;
        }

        @Override
        public String scenario() {
            return this.scenario;
        }

        @Override
        public boolean successful() {
            return this.exception == null;
        }

        @Override
        public Optional<Throwable> exception() {
            return Optional.ofNullable(this.exception);
        }
    }
}

