/*
 * Decompiled with CFR 0.152.
 */
package is.codion.plugin.tomcat.pool;

import is.codion.common.db.connection.ConnectionFactory;
import is.codion.common.db.pool.AbstractConnectionPoolWrapper;
import is.codion.common.db.pool.ConnectionPoolFactory;
import is.codion.common.db.pool.ConnectionPoolWrapper;
import is.codion.common.user.User;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.apache.tomcat.jdbc.pool.Validator;

public final class TomcatConnectionPoolFactory
implements ConnectionPoolFactory {
    public ConnectionPoolWrapper createConnectionPoolWrapper(ConnectionFactory connectionFactory, User user) {
        return new DataSourceWrapper(connectionFactory, user, TomcatConnectionPoolFactory.createDataSource(user, connectionFactory));
    }

    private static DataSource createDataSource(User user, ConnectionFactory connectionFactory) {
        PoolProperties pp = new PoolProperties();
        pp.setUrl(connectionFactory.url());
        pp.setDefaultAutoCommit(Boolean.valueOf(false));
        pp.setName(user.username());
        pp.setTestOnBorrow(true);
        pp.setValidator((Validator)new ConnectionValidator(connectionFactory));
        pp.setMaxActive(((Integer)ConnectionPoolWrapper.DEFAULT_MAXIMUM_POOL_SIZE.get()).intValue());
        pp.setInitialSize(((Integer)ConnectionPoolWrapper.DEFAULT_MAXIMUM_POOL_SIZE.get()).intValue());
        pp.setMaxIdle(((Integer)ConnectionPoolWrapper.DEFAULT_MAXIMUM_POOL_SIZE.get()).intValue());
        pp.setMinIdle(((Integer)ConnectionPoolWrapper.DEFAULT_MINIMUM_POOL_SIZE.get()).intValue());
        pp.setSuspectTimeout((Integer)ConnectionPoolWrapper.DEFAULT_IDLE_TIMEOUT.get() / 1000);
        return new DataSource((PoolConfiguration)pp);
    }

    private static final class DataSourceWrapper
    extends AbstractConnectionPoolWrapper<DataSource> {
        private DataSourceWrapper(ConnectionFactory connectionFactory, User user, DataSource dataSource) {
            super(connectionFactory, user, (javax.sql.DataSource)dataSource);
            dataSource.setDataSource((Object)this.poolDataSource());
            this.setPool(dataSource);
        }

        public void close() {
            ((DataSource)this.getPool()).close();
        }

        public int getCleanupInterval() {
            return ((DataSource)this.getPool()).getTimeBetweenEvictionRunsMillis();
        }

        public void setCleanupInterval(int poolCleanupInterval) {
            ((DataSource)this.getPool()).setTimeBetweenEvictionRunsMillis(poolCleanupInterval);
        }

        public int getIdleConnectionTimeout() {
            return ((DataSource)this.getPool()).getSuspectTimeout() * 1000;
        }

        public void setIdleConnectionTimeout(int idleConnectionTimeout) {
            ((DataSource)this.getPool()).setSuspectTimeout(idleConnectionTimeout / 1000);
        }

        public int getMinimumPoolSize() {
            return ((DataSource)this.getPool()).getMinIdle();
        }

        public void setMinimumPoolSize(int minimumPoolSize) {
            ((DataSource)this.getPool()).setMinIdle(minimumPoolSize);
        }

        public int getMaximumPoolSize() {
            return ((DataSource)this.getPool()).getMaxActive();
        }

        public void setMaximumPoolSize(int maximumPoolSize) {
            ((DataSource)this.getPool()).setMaxActive(maximumPoolSize);
            ((DataSource)this.getPool()).setMaxIdle(maximumPoolSize);
        }

        public int getMaximumCheckOutTime() {
            return ((DataSource)this.getPool()).getMaxWait();
        }

        public void setMaximumCheckOutTime(int maximumCheckOutTime) {
            ((DataSource)this.getPool()).setMaxWait(maximumCheckOutTime);
        }

        protected Connection fetchConnection() throws SQLException {
            return ((DataSource)this.getPool()).getConnection();
        }

        protected int available() {
            return ((DataSource)this.getPool()).getSize() - ((DataSource)this.getPool()).getActive();
        }

        protected int inUse() {
            return ((DataSource)this.getPool()).getActive();
        }

        protected int waiting() {
            return ((DataSource)this.getPool()).getWaitCount();
        }
    }

    private static final class ConnectionValidator
    implements Validator {
        private final ConnectionFactory connectionFactory;

        private ConnectionValidator(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        public boolean validate(Connection connection, int i) {
            return this.connectionFactory.connectionValid(connection);
        }
    }
}

