/*
 * Decompiled with CFR 0.152.
 */
package is.codion.plugin.log4j;

import is.codion.common.logging.LoggerProxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.LoggerConfig;

public final class Log4jProxy
implements LoggerProxy {
    public Object getLogLevel() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        LoggerConfig loggerConfig = context.getConfiguration().getLoggerConfig("");
        return loggerConfig.getLevel();
    }

    public void setLogLevel(Object logLevel) {
        if (!(logLevel instanceof Level)) {
            throw new IllegalArgumentException("logLevel should be of type " + Level.class.getName());
        }
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        LoggerConfig loggerConfig = context.getConfiguration().getLoggerConfig("");
        loggerConfig.setLevel((Level)logLevel);
        context.updateLoggers();
    }

    public List<Object> levels() {
        return Arrays.asList(Level.OFF, Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.ALL);
    }

    public Collection<String> files() {
        Map appenderMap = ((Logger)LogManager.getLogger()).getAppenders();
        return appenderMap.values().stream().filter(RollingFileAppender.class::isInstance).map(RollingFileAppender.class::cast).map(RollingFileAppender::getFileName).collect(Collectors.toList());
    }
}

