/*
 * Decompiled with CFR 0.152.
 */
package is.codion.plugin.jasperreports;

import is.codion.common.db.report.ReportException;
import is.codion.plugin.jasperreports.AbstractJRReport;
import java.net.URL;
import java.util.Objects;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;

final class ClassPathJRReport
extends AbstractJRReport {
    private final Class<?> resourceClass;

    ClassPathJRReport(Class<?> resourceClass, String reportPath) {
        super(reportPath, true);
        this.resourceClass = Objects.requireNonNull(resourceClass);
    }

    public JasperReport load() throws ReportException {
        try {
            return (JasperReport)JRLoader.loadObject((URL)this.resourceClass.getResource(this.reportPath));
        }
        catch (Exception e) {
            throw new ReportException("Unable to load report '" + this.reportPath + "' from classpath", (Throwable)e);
        }
    }

    protected String fullReportPath() {
        return this.resourceClass.getName() + " " + this.reportPath;
    }
}

